/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class Sentinel1RemoveThermalNoiseOpUI
extends BaseOperatorUI {
    private final JList<String> polList = new JList();
    private final JCheckBox removeThermalNoiseCheckBox = new JCheckBox("Remove Thermal Noise");
    private final JCheckBox reIntroduceThermalNoiseCheckBox = new JCheckBox("Re-Introduce Thermal Noise");
    private boolean removeThermalNoise = false;
    private boolean reIntroduceThermalNoise = false;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.removeThermalNoiseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Sentinel1RemoveThermalNoiseOpUI.this.removeThermalNoise = e.getStateChange() == 1;
                if (Sentinel1RemoveThermalNoiseOpUI.this.removeThermalNoise) {
                    Sentinel1RemoveThermalNoiseOpUI.this.reIntroduceThermalNoise = false;
                    Sentinel1RemoveThermalNoiseOpUI.this.reIntroduceThermalNoiseCheckBox.setSelected(false);
                } else {
                    Sentinel1RemoveThermalNoiseOpUI.this.reIntroduceThermalNoise = true;
                    Sentinel1RemoveThermalNoiseOpUI.this.reIntroduceThermalNoiseCheckBox.setSelected(true);
                }
            }
        });
        this.reIntroduceThermalNoiseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Sentinel1RemoveThermalNoiseOpUI.this.reIntroduceThermalNoise = e.getStateChange() == 1;
                if (Sentinel1RemoveThermalNoiseOpUI.this.reIntroduceThermalNoise) {
                    Sentinel1RemoveThermalNoiseOpUI.this.removeThermalNoise = false;
                    Sentinel1RemoveThermalNoiseOpUI.this.removeThermalNoiseCheckBox.setSelected(false);
                } else {
                    Sentinel1RemoveThermalNoiseOpUI.this.removeThermalNoise = true;
                    Sentinel1RemoveThermalNoiseOpUI.this.removeThermalNoiseCheckBox.setSelected(true);
                }
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        Boolean paramVal;
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]);
            String[] polarisations = Sentinel1Utils.getProductPolarizations((MetadataElement)absRoot);
            this.polList.setListData((String[])polarisations);
            OperatorUIUtils.initParamList(this.polList, (String[])polarisations);
        }
        if ((paramVal = (Boolean)this.paramMap.get("removeThermalNoise")) != null) {
            this.removeThermalNoise = paramVal;
            this.removeThermalNoiseCheckBox.setSelected(this.removeThermalNoise);
        }
        if ((paramVal = (Boolean)this.paramMap.get("reIntroduceThermalNoise")) != null) {
            this.reIntroduceThermalNoise = paramVal;
            this.reIntroduceThermalNoiseCheckBox.setSelected(this.reIntroduceThermalNoise);
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList(this.polList, (Map)this.paramMap, (String)"selectedPolarisations");
        this.paramMap.put("removeThermalNoise", this.removeThermalNoise);
        this.paramMap.put("reIntroduceThermalNoise", this.reIntroduceThermalNoise);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Polarisations:", this.polList);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.removeThermalNoiseCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.reIntroduceThermalNoiseCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

