/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class CalibrationOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JScrollPane bandListPane = new JScrollPane(this.bandList);
    private final JLabel bandListLabel = new JLabel("Source Bands:");
    private final JComboBox auxFile = new JComboBox<String>(new String[]{"Latest Auxiliary File", "Product Auxiliary File", "External Auxiliary File"});
    private final JLabel auxFileLabel = new JLabel("ENVISAT Auxiliary File:");
    private final JLabel externalAuxFileLabel = new JLabel("External Auxiliary File:");
    private final JTextField externalAuxFile = new JTextField("");
    private final JButton externalAuxFileBrowseButton = new JButton("...");
    private final JCheckBox saveInComplexCheckBox = new JCheckBox("Save as complex output");
    private final JCheckBox saveInDbCheckBox = new JCheckBox("Save in dB");
    private final JCheckBox createGamma0VirtualBandCheckBox = new JCheckBox("Create gamma0 virtual band");
    private final JCheckBox createBeta0VirtualBandCheckBox = new JCheckBox("Create beta0 virtual band");
    private boolean saveInComplex = false;
    private boolean saveInDb = false;
    private boolean createGamma0VirtualBand = false;
    private boolean createBeta0VirtualBand = false;
    private final JList<String> polList = new JList();
    private final JScrollPane polListPane = new JScrollPane(this.polList);
    private final JLabel polListLabel = new JLabel("Polarisations:");
    private final JCheckBox outputSigmaBandCheckBox = new JCheckBox("Output sigma0 band");
    private final JCheckBox outputGammaBandCheckBox = new JCheckBox("Output gamma0 band");
    private final JCheckBox outputBetaBandCheckBox = new JCheckBox("Output beta0 band");
    private final JCheckBox outputDNBandCheckBox = new JCheckBox("Output DN band");
    private boolean outputSigmaBand = false;
    private boolean outputGammaBand = false;
    private boolean outputBetaBand = false;
    private boolean outputDNBand = false;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.auxFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                String item = (String)CalibrationOpUI.this.auxFile.getSelectedItem();
                if (item.equals("External Auxiliary File")) {
                    CalibrationOpUI.this.enableExternalAuxFile(true);
                } else {
                    CalibrationOpUI.this.externalAuxFile.setText("");
                    CalibrationOpUI.this.enableExternalAuxFile(false);
                }
            }
        });
        this.externalAuxFile.setColumns(20);
        this.auxFile.setSelectedItem(parameterMap.get("auxFile"));
        this.enableExternalAuxFile(false);
        this.externalAuxFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"External Auxiliary File", (boolean)false, null, (String)"s1tbx.calibration.aux.file");
                CalibrationOpUI.this.externalAuxFile.setText(file.getAbsolutePath());
            }
        });
        this.saveInComplexCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalibrationOpUI.this.saveInComplex = e.getStateChange() == 1;
                if (CalibrationOpUI.this.saveInComplex) {
                    CalibrationOpUI.this.saveInDbCheckBox.setEnabled(false);
                    CalibrationOpUI.this.createGamma0VirtualBandCheckBox.setEnabled(false);
                    CalibrationOpUI.this.createBeta0VirtualBandCheckBox.setEnabled(false);
                    CalibrationOpUI.this.saveInDbCheckBox.setSelected(false);
                    CalibrationOpUI.this.createGamma0VirtualBandCheckBox.setSelected(false);
                    CalibrationOpUI.this.createBeta0VirtualBandCheckBox.setSelected(false);
                    CalibrationOpUI.this.outputSigmaBandCheckBox.setEnabled(false);
                    CalibrationOpUI.this.outputGammaBandCheckBox.setEnabled(false);
                    CalibrationOpUI.this.outputBetaBandCheckBox.setEnabled(false);
                    CalibrationOpUI.this.outputDNBandCheckBox.setEnabled(false);
                    CalibrationOpUI.this.outputSigmaBandCheckBox.setSelected(true);
                    CalibrationOpUI.this.outputGammaBandCheckBox.setSelected(false);
                    CalibrationOpUI.this.outputBetaBandCheckBox.setSelected(false);
                    CalibrationOpUI.this.outputDNBandCheckBox.setSelected(false);
                } else {
                    CalibrationOpUI.this.saveInDbCheckBox.setEnabled(true);
                    CalibrationOpUI.this.createGamma0VirtualBandCheckBox.setEnabled(true);
                    CalibrationOpUI.this.createBeta0VirtualBandCheckBox.setEnabled(true);
                    CalibrationOpUI.this.outputSigmaBandCheckBox.setEnabled(true);
                    CalibrationOpUI.this.outputGammaBandCheckBox.setEnabled(true);
                    CalibrationOpUI.this.outputBetaBandCheckBox.setEnabled(true);
                    CalibrationOpUI.this.outputDNBandCheckBox.setEnabled(true);
                    CalibrationOpUI.this.outputSigmaBandCheckBox.setSelected(true);
                }
            }
        });
        this.saveInDbCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalibrationOpUI.this.saveInDb = e.getStateChange() == 1;
            }
        });
        this.createGamma0VirtualBandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalibrationOpUI.this.createGamma0VirtualBand = e.getStateChange() == 1;
            }
        });
        this.createBeta0VirtualBandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalibrationOpUI.this.createBeta0VirtualBand = e.getStateChange() == 1;
            }
        });
        this.outputSigmaBandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalibrationOpUI.this.outputSigmaBand = e.getStateChange() == 1;
            }
        });
        this.outputGammaBandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalibrationOpUI.this.outputGammaBand = e.getStateChange() == 1;
            }
        });
        this.outputBetaBandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalibrationOpUI.this.outputBetaBand = e.getStateChange() == 1;
            }
        });
        this.outputDNBandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalibrationOpUI.this.outputDNBand = e.getStateChange() == 1;
            }
        });
        return panel;
    }

    public void initParameters() {
        Boolean paramVal;
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames(), (Object[])((Object[])this.paramMap.get("sourceBands")));
        if (this.sourceProducts != null) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]);
            if (absRoot != null) {
                String sampleType = absRoot.getAttributeString("SAMPLE_TYPE");
                if (sampleType.equals("COMPLEX")) {
                    this.auxFile.removeItem("Product Auxiliary File");
                    this.auxFile.setSelectedItem(this.paramMap.get("auxFile"));
                } else {
                    if (this.auxFile.getItemCount() == 2) {
                        this.auxFile.addItem("Product Auxiliary File");
                    }
                    this.auxFile.setSelectedItem("Product Auxiliary File");
                }
                String mission = absRoot.getAttributeString("MISSION");
                if (!mission.equals("ENVISAT")) {
                    this.auxFile.setEnabled(false);
                    this.auxFileLabel.setEnabled(false);
                } else {
                    this.auxFile.setEnabled(true);
                    this.auxFileLabel.setEnabled(true);
                }
                DialogUtils.enableComponents((JComponent)this.auxFileLabel, (JComponent)this.auxFile, (boolean)true);
                DialogUtils.enableComponents((JComponent)this.bandListLabel, (JComponent)this.bandListPane, (boolean)true);
                this.saveInComplexCheckBox.setVisible(true);
                this.saveInDbCheckBox.setVisible(true);
                this.createGamma0VirtualBandCheckBox.setVisible(true);
                this.createBeta0VirtualBandCheckBox.setVisible(true);
                DialogUtils.enableComponents((JComponent)this.polListLabel, (JComponent)this.polListPane, (boolean)false);
                this.outputSigmaBandCheckBox.setVisible(false);
                this.outputGammaBandCheckBox.setVisible(false);
                this.outputBetaBandCheckBox.setVisible(false);
                this.outputDNBandCheckBox.setVisible(false);
                if (sampleType.equals("COMPLEX")) {
                    this.saveInComplexCheckBox.setEnabled(true);
                    this.saveInComplexCheckBox.setSelected(false);
                    if (this.saveInComplex) {
                        this.saveInDbCheckBox.setEnabled(false);
                        this.createGamma0VirtualBandCheckBox.setEnabled(false);
                        this.createBeta0VirtualBandCheckBox.setEnabled(false);
                        this.saveInDbCheckBox.setSelected(false);
                        this.createGamma0VirtualBandCheckBox.setSelected(false);
                        this.createBeta0VirtualBandCheckBox.setSelected(false);
                        this.outputSigmaBandCheckBox.setEnabled(false);
                        this.outputGammaBandCheckBox.setEnabled(false);
                        this.outputBetaBandCheckBox.setEnabled(false);
                        this.outputDNBandCheckBox.setEnabled(false);
                        this.outputSigmaBandCheckBox.setSelected(false);
                        this.outputGammaBandCheckBox.setSelected(false);
                        this.outputBetaBandCheckBox.setSelected(false);
                        this.outputDNBandCheckBox.setSelected(false);
                    } else {
                        this.saveInDbCheckBox.setEnabled(true);
                        this.createGamma0VirtualBandCheckBox.setEnabled(true);
                        this.createBeta0VirtualBandCheckBox.setEnabled(true);
                        this.outputSigmaBandCheckBox.setVisible(true);
                        this.outputGammaBandCheckBox.setVisible(true);
                        this.outputBetaBandCheckBox.setVisible(true);
                        this.outputDNBandCheckBox.setVisible(true);
                    }
                } else {
                    this.saveInComplexCheckBox.setEnabled(false);
                    this.saveInComplexCheckBox.setSelected(false);
                    this.outputSigmaBandCheckBox.setVisible(true);
                    this.outputGammaBandCheckBox.setVisible(true);
                    this.outputBetaBandCheckBox.setVisible(true);
                    this.outputDNBandCheckBox.setVisible(true);
                }
                if (mission.startsWith("SENTINEL-1")) {
                    OperatorUIUtils.initParamList(this.polList, (String[])Sentinel1Utils.getProductPolarizations((MetadataElement)absRoot), (Object[])((String[])this.paramMap.get("selectedPolarisations")));
                    DialogUtils.enableComponents((JComponent)this.auxFileLabel, (JComponent)this.auxFile, (boolean)false);
                    DialogUtils.enableComponents((JComponent)this.externalAuxFileLabel, (JComponent)this.externalAuxFile, (boolean)false);
                    DialogUtils.enableComponents((JComponent)this.bandListLabel, (JComponent)this.bandListPane, (boolean)false);
                    this.saveInDbCheckBox.setVisible(false);
                    this.createGamma0VirtualBandCheckBox.setVisible(false);
                    this.createBeta0VirtualBandCheckBox.setVisible(false);
                    DialogUtils.enableComponents((JComponent)this.polListLabel, (JComponent)this.polListPane, (boolean)true);
                }
            }
        } else {
            this.auxFile.setSelectedItem(this.paramMap.get("auxFile"));
        }
        File extFile = (File)this.paramMap.get("externalAuxFile");
        if (extFile != null) {
            this.externalAuxFile.setText(extFile.getAbsolutePath());
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputImageInComplex")) != null) {
            this.saveInComplex = paramVal;
            this.saveInComplexCheckBox.setSelected(this.saveInComplex);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputImageScaleInDb")) != null) {
            this.saveInDb = paramVal;
            this.saveInDbCheckBox.setSelected(this.saveInDb);
        }
        if ((paramVal = (Boolean)this.paramMap.get("createGammaBand")) != null) {
            this.createGamma0VirtualBand = paramVal;
            this.createGamma0VirtualBandCheckBox.setSelected(this.createGamma0VirtualBand);
        }
        if ((paramVal = (Boolean)this.paramMap.get("createBetaBand")) != null) {
            this.createBeta0VirtualBand = paramVal;
            this.createBeta0VirtualBandCheckBox.setSelected(this.createBeta0VirtualBand);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputSigmaBand")) != null) {
            this.outputSigmaBand = paramVal;
            this.outputSigmaBandCheckBox.setSelected(this.outputSigmaBand);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputGammaBand")) != null) {
            this.outputGammaBand = paramVal;
            this.outputGammaBandCheckBox.setSelected(this.outputGammaBand);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputBetaBand")) != null) {
            this.outputBetaBand = paramVal;
            this.outputBetaBandCheckBox.setSelected(this.outputBetaBand);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputDNBand")) != null) {
            this.outputDNBand = paramVal;
            this.outputDNBandCheckBox.setSelected(this.outputDNBand);
        }
    }

    public UIValidation validateParameters() {
        String procSysId;
        float version;
        String mission;
        MetadataElement absRoot;
        if (this.sourceProducts != null && (absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0])) != null && (mission = absRoot.getAttributeString("MISSION")).startsWith("SENTINEL-1") && (version = Float.valueOf((procSysId = absRoot.getAttributeString("Processing_system_identifier")).substring(procSysId.lastIndexOf(" "))).floatValue()) < 2.34f) {
            return new UIValidation(UIValidation.State.WARNING, "The calibration LUT for this product could be incorrect and therefore the calibration result may not be reliable.");
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("auxFile", this.auxFile.getSelectedItem());
        String extFileStr = this.externalAuxFile.getText();
        if (!extFileStr.isEmpty()) {
            this.paramMap.put("externalAuxFile", new File(extFileStr));
        }
        this.paramMap.put("outputImageInComplex", this.saveInComplex);
        this.paramMap.put("outputImageScaleInDb", this.saveInDb);
        this.paramMap.put("createGammaBand", this.createGamma0VirtualBand);
        this.paramMap.put("createBetaBand", this.createBeta0VirtualBand);
        OperatorUIUtils.updateParamList(this.polList, (Map)this.paramMap, (String)"selectedPolarisations");
        this.paramMap.put("outputSigmaBand", this.outputSigmaBand);
        this.paramMap.put("outputGammaBand", this.outputGammaBand);
        this.paramMap.put("outputBetaBand", this.outputBetaBand);
        this.paramMap.put("outputDNBand", this.outputDNBand);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.bandListLabel, (JComponent)this.bandListPane);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.polListLabel, (JComponent)this.polListPane);
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.auxFileLabel, (JComponent)this.auxFile);
        ++gbc.gridy;
        DialogUtils.addInnerPanel((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalAuxFileLabel, (JComponent)this.externalAuxFile, (JComponent)this.externalAuxFileBrowseButton);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.saveInComplexCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.saveInDbCheckBox, gbc);
        contentPane.add((Component)this.outputSigmaBandCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.createGamma0VirtualBandCheckBox, gbc);
        contentPane.add((Component)this.outputGammaBandCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.createBeta0VirtualBandCheckBox, gbc);
        contentPane.add((Component)this.outputBetaBandCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        DialogUtils.enableComponents((JComponent)this.polListLabel, (JComponent)this.polListPane, (boolean)false);
        this.outputSigmaBandCheckBox.setVisible(false);
        this.outputGammaBandCheckBox.setVisible(false);
        this.outputBetaBandCheckBox.setVisible(false);
        this.outputDNBandCheckBox.setVisible(false);
        return contentPane;
    }

    private void enableExternalAuxFile(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.externalAuxFileLabel, (JComponent)this.externalAuxFile, (boolean)flag);
        this.externalAuxFileBrowseButton.setVisible(flag);
    }
}

