/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import java.awt.Color;
import java.io.File;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.gpf.CommonReaders;

public class GraphData {
    private String title;
    private final File[] files;
    private final Color color;
    private final Product[] productList;

    public GraphData(String title) {
        this.title = title;
        this.files = new File[0];
        this.color = Color.BLACK;
        this.productList = null;
    }

    public GraphData(String title, File[] files, Color color) {
        this.title = title;
        this.files = files;
        this.color = color;
        this.productList = GraphData.readProducts(files);
    }

    private static Product[] readProducts(File[] fileList) {
        Product[] prodList = new Product[fileList.length];
        int i = 0;
        for (File file : fileList) {
            try {
                prodList[i] = CommonReaders.readProduct((File)file);
                ++i;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return prodList;
    }

    public String getTitle() {
        return this.title;
    }

    public Color getColor() {
        return this.color;
    }

    public File[] getFileList() {
        return this.files;
    }

    public Product[] getProducts() {
        return this.productList;
    }
}

