/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries.graphs;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.support.ImageLayer;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesGraph;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.IndexValidator;
import org.esa.snap.core.util.math.Range;

public class PlacemarkGraph
extends TimeSeriesGraph {
    private Placemark placemark = null;
    private final String graphName;

    public PlacemarkGraph(Placemark placemark, String graphName) {
        this.placemark = placemark;
        this.graphName = graphName;
    }

    public Placemark getPlacemark() {
        return this.placemark;
    }

    @Override
    public String getXName() {
        return "Time";
    }

    @Override
    public String getYName() {
        return this.graphName + ' ' + this.placemark.getLabel();
    }

    @Override
    public void readValues(ImageLayer imageLayer, GeoPos geoPos, int level) {
        this.resetData();
        if (this.placemark != null) {
            for (Band band : this.selectedBands) {
                int index = this.getTimeIndex(band);
                if (index < 0) continue;
                PixelPos pix = band.getGeoCoding().getPixelPos(this.placemark.getGeoPos(), null);
                this.dataPoints[index] = ProductUtils.getGeophysicalSampleAsLong((RasterDataNode)band, (int)((int)pix.getX()), (int)((int)pix.getY()), (int)level);
                if (this.dataPoints[index] != band.getNoDataValue()) continue;
                this.dataPoints[index] = Double.NaN;
            }
        }
        Range.computeRangeDouble((double[])this.dataPoints, (IndexValidator)IndexValidator.TRUE, (Range)this.dataPointRange, (ProgressMonitor)ProgressMonitor.NULL);
    }

    @Override
    public void dispose() {
        this.placemark = null;
        super.dispose();
    }
}

