/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.support.ImageLayer;
import java.util.HashMap;
import java.util.Map;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesTimes;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.util.math.IndexValidator;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.ui.diagram.AbstractDiagramGraph;

public abstract class TimeSeriesGraph
extends AbstractDiagramGraph {
    protected TimeSeriesTimes times;
    protected Band[] selectedBands;
    protected double[] dataPoints;
    protected double[] timeData;
    protected final Range dataPointRange = new Range();
    protected final Range timeRange = new Range();
    private final Map<Band, Integer> timeBandMap = new HashMap<Band, Integer>(10);

    public String getXName() {
        return "Time";
    }

    public String getYName() {
        return "Cursor";
    }

    public final int getNumValues() {
        return this.dataPoints.length;
    }

    public final double getXValueAt(int index) {
        return this.timeData[index];
    }

    public double getYValueAt(int index) {
        return this.dataPoints[index];
    }

    public final double getXMin() {
        return this.timeRange.getMin();
    }

    public final double getXMax() {
        return this.timeRange.getMax();
    }

    public final double getYMin() {
        return this.dataPointRange.getMin();
    }

    public final double getYMax() {
        return this.dataPointRange.getMax();
    }

    protected final boolean isSelected(Band band) {
        for (Band b : this.selectedBands) {
            if (b != band) continue;
            return true;
        }
        return false;
    }

    protected final void resetData() {
        for (int i = 0; i < this.dataPoints.length; ++i) {
            this.dataPoints[i] = Double.NaN;
        }
    }

    public final int getTimeIndex(Band band) {
        Integer index = this.timeBandMap.get(band);
        return index == null ? this.times.getIndex(band) : index.intValue();
    }

    public void setBands(TimeSeriesTimes tsTimes, Band[] selBands) {
        this.times = tsTimes;
        this.selectedBands = (Band[])selBands.clone();
        int numTimes = this.times.length();
        if (this.timeData == null || this.timeData.length != numTimes) {
            this.timeData = new double[numTimes];
        }
        if (this.dataPoints == null || this.dataPoints.length != numTimes) {
            this.dataPoints = new double[numTimes];
        }
        for (int i = 0; i < numTimes; ++i) {
            this.timeData[i] = this.times.getTimeAt(i).getMJD();
            this.dataPoints[i] = 0.0;
        }
        this.timeBandMap.clear();
        for (Band band : this.selectedBands) {
            this.timeBandMap.put(band, this.times.getIndex(band));
        }
        Range.computeRangeDouble((double[])this.timeData, (IndexValidator)IndexValidator.TRUE, (Range)this.timeRange, (ProgressMonitor)ProgressMonitor.NULL);
        Range.computeRangeDouble((double[])this.dataPoints, (IndexValidator)IndexValidator.TRUE, (Range)this.dataPointRange, (ProgressMonitor)ProgressMonitor.NULL);
    }

    public abstract void readValues(ImageLayer var1, GeoPos var2, int var3);

    public void dispose() {
        this.times = null;
        this.selectedBands = null;
        this.dataPoints = null;
        this.timeData = null;
        super.dispose();
    }
}

