/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.DateAxis;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.GraphData;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesGraph;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesTimes;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.graphs.CursorGraph;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.graphs.PlacemarkGraph;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.graphs.VectorGraph;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.ui.diagram.DefaultDiagramGraphStyle;
import org.esa.snap.ui.diagram.Diagram;
import org.esa.snap.ui.diagram.DiagramAxis;
import org.esa.snap.ui.diagram.DiagramGraph;

class TimeSeriesDiagram
extends Diagram {
    private Product product;
    private final DateAxis dateAxis;

    public TimeSeriesDiagram(Product product) {
        this.product = product;
        this.dateAxis = new DateAxis("Band", "");
        this.setXAxis(this.dateAxis);
        this.setYAxis(new DiagramAxis("", "1"));
    }

    public TimeSeriesGraph[] getCursorGraphs() {
        ArrayList<CursorGraph> graphs = new ArrayList<CursorGraph>(5);
        for (DiagramGraph graph : this.getGraphs()) {
            if (!(graph instanceof CursorGraph)) continue;
            graphs.add((CursorGraph)graph);
        }
        return graphs.toArray(new TimeSeriesGraph[graphs.size()]);
    }

    public TimeSeriesGraph addCursorGraph(GraphData graphData) {
        CursorGraph graph = new CursorGraph();
        DefaultDiagramGraphStyle style = (DefaultDiagramGraphStyle)graph.getStyle();
        style.setOutlineColor(graphData.getColor());
        style.setOutlineStroke((Stroke)new BasicStroke(1.5f));
        style.setFillPaint((Paint)Color.WHITE);
        this.addGraph((DiagramGraph)graph);
        return graph;
    }

    public TimeSeriesGraph addPlacemarkGraph(Placemark placemark, GraphData graphData) {
        PlacemarkGraph graph = new PlacemarkGraph(placemark, graphData.getTitle());
        DefaultDiagramGraphStyle style = (DefaultDiagramGraphStyle)graph.getStyle();
        FigureStyle figureStyle = DefaultFigureStyle.createFromCss((String)placemark.getStyleCss());
        style.setOutlineColor(graphData.getColor());
        style.setOutlineStroke((Stroke)new BasicStroke(1.2f));
        style.setFillPaint(figureStyle.getFillPaint());
        this.addGraph((DiagramGraph)graph);
        return graph;
    }

    public TimeSeriesGraph addVectorGraph(VectorDataNode vectorNode, GraphData graphData, VectorGraph.TYPE type) {
        VectorGraph graph = new VectorGraph(vectorNode, type);
        DefaultDiagramGraphStyle style = (DefaultDiagramGraphStyle)graph.getStyle();
        FigureStyle figureStyle = DefaultFigureStyle.createFromCss((String)vectorNode.getDefaultStyleCss());
        style.setOutlineColor(graphData.getColor());
        style.setOutlineStroke((Stroke)new BasicStroke(3.5f));
        style.setFillPaint(figureStyle.getFillPaint());
        this.addGraph((DiagramGraph)graph);
        return graph;
    }

    public void removeCursorGraph() {
        TimeSeriesGraph[] cursorGraphs = this.getCursorGraphs();
        if (cursorGraphs != null) {
            for (TimeSeriesGraph graph : cursorGraphs) {
                this.removeGraph((DiagramGraph)graph);
            }
        }
    }

    public void initAxis(TimeSeriesTimes times, Band[] bands) {
        this.dateAxis.setTimes(times);
        this.getYAxis().setUnit(TimeSeriesDiagram.getUnit(bands));
        this.adjustAxes(true);
        this.invalidate();
    }

    public void updateDiagram(ImageLayer imageLayer, int pixelX, int pixelY, int level) {
        DiagramGraph[] graphs;
        GeoPos geoPos = this.product.getSceneGeoCoding().getGeoPos(new PixelPos((double)((float)pixelX + 0.5f), (double)((float)pixelY + 0.5f)), null);
        for (DiagramGraph graph : graphs = this.getGraphs()) {
            ((TimeSeriesGraph)graph).readValues(imageLayer, geoPos, level);
        }
        this.adjustAxes(false);
        this.invalidate();
    }

    private static String getUnit(Band[] bands) {
        String unit = null;
        for (Band band : bands) {
            if (unit == null) {
                unit = band.getUnit();
                continue;
            }
            if (unit.equals(band.getUnit())) continue;
            unit = " mixed units ";
            break;
        }
        return unit != null ? unit : "?";
    }

    public void dispose() {
        if (this.product != null) {
            this.product = null;
            for (DiagramGraph graph : this.getGraphs()) {
                TimeSeriesGraph tsGraph = (TimeSeriesGraph)graph;
                tsGraph.dispose();
            }
        }
        super.dispose();
    }
}

