/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.swing.Action;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesDiagram;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.AbstractExportImageAction;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;

public class GraphExportImageAction
extends AbstractExportImageAction {
    private static final String[][] SCENE_IMAGE_FORMAT_DESCRIPTIONS = new String[][]{BMP_FORMAT_DESCRIPTION, PNG_FORMAT_DESCRIPTION, JPEG_FORMAT_DESCRIPTION, TIFF_FORMAT_DESCRIPTION, GEOTIFF_FORMAT_DESCRIPTION};
    private static final String HELP_ID = "exportImageFile";
    private final TimeSeriesDiagram diagram;
    private SnapFileFilter[] sceneImageFileFilters;

    public GraphExportImageAction(TimeSeriesDiagram diagram) {
        super("Export Time Series Image", HELP_ID);
        this.diagram = diagram;
        this.sceneImageFileFilters = new SnapFileFilter[SCENE_IMAGE_FORMAT_DESCRIPTIONS.length];
        for (int i = 0; i < SCENE_IMAGE_FORMAT_DESCRIPTIONS.length; ++i) {
            this.sceneImageFileFilters[i] = GraphExportImageAction.createFileFilter((String[])SCENE_IMAGE_FORMAT_DESCRIPTIONS[i]);
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.exportImage(this.sceneImageFileFilters);
    }

    public void exportImage() {
        this.exportImage(this.sceneImageFileFilters);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new GraphExportImageAction(this.diagram);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnabled(SnapApp.getDefault().getSelectedProductSceneView() != null);
    }

    protected void configureFileChooser(SnapFileChooser fileChooser, ProductSceneView view, String imageBaseName) {
        fileChooser.setDialogTitle("Export Image");
        fileChooser.setCurrentFilename(imageBaseName + "_" + view.getRaster().getName());
    }

    protected RenderedImage createImage(String imageFormat, ProductSceneView view) {
        this.diagram.invalidate();
        Rectangle r = this.diagram.getGraphArea();
        BufferedImage img = new BufferedImage(r.x + r.width, r.y + r.height, 5);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        this.diagram.render(g, r.x, r.y, r.width, r.height);
        return img;
    }

    protected boolean isEntireImageSelected() {
        return true;
    }
}

