/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import com.bc.ceres.glayer.support.ImageLayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.Bundle;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.GraphData;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.GraphExportImageAction;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesCanvas;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesDiagram;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesExportAction;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesGraph;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesSettings;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesSettingsDlg;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesTimes;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.graphs.VectorGraph;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.dialogs.CheckListDialog;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.PixelPositionListener;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.BandChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TimeSeriesToolView", iconBase="org/esa/s1tbx/analysis/icons/timeseries24.png", persistenceType=0)
public class TimeSeriesToolView
extends ToolTopComponent {
    private static final String SUPPRESS_MESSAGE_KEY = "plugin.spectrum.tip";
    private static final String MSG_NO_BANDS = "Open a band and add products with settings.";
    private final Map<Product, TimeSeriesDiagram> productToDiagramMap;
    private final ProductNodeListenerAdapter productNodeHandler;
    private final PinSelectionChangeListener pinSelectionChangeListener;
    private final CursorPPL ppl;
    private TimeSeriesCanvas diagramCanvas;
    private AbstractButton filterButton;
    private AbstractButton showForCursorButton;
    private AbstractButton showForSelectedPinsButton;
    private AbstractButton showForAllPinsButton;
    private AbstractButton showVectorAverageButton;
    private AbstractButton showAveragePinSpectrumButton;
    private AbstractButton exportTextButton;
    private AbstractButton exportImageButton;
    private boolean tipShown;
    private ProductSceneView currentView;
    private Product currentProduct;
    private boolean isShown = false;
    private Band[] userSelectedBands = null;
    private VectorGraph.TYPE vectorStatistic = VectorGraph.TYPE.AVERAGE;
    private ProductNode oldNode = null;
    private TimeSeriesSettings settings = new TimeSeriesSettings();

    public TimeSeriesToolView() {
        this.setLayout(new BorderLayout());
        this.setDisplayName(Bundle.CTL_TimeSeriesToolView_Name());
        this.setToolTipText(Bundle.CTL_TimeSeriesToolViewDescription());
        this.add(this.createPanel(), "Center");
        SnapApp snapApp = SnapApp.getDefault();
        snapApp.getProductManager().addListener((ProductManager.Listener)new ProductManagerListener());
        snapApp.getSelectionSupport(ProductNode.class).addHandler((SelectionSupport.Handler)new SelectionSupport.Handler<ProductNode>(){

            public void selectionChange(@NullAllowed ProductNode oldValue, @NullAllowed ProductNode newValue) {
                if (newValue != null && newValue != TimeSeriesToolView.this.oldNode) {
                    TimeSeriesToolView.this.oldNode = newValue;
                }
            }
        });
        this.productNodeHandler = new ProductNodeHandler();
        this.pinSelectionChangeListener = new PinSelectionChangeListener();
        this.productToDiagramMap = new HashMap<Product, TimeSeriesDiagram>(4);
        this.ppl = new CursorPPL();
    }

    protected void componentOpened() {
        ProductSceneView view;
        this.isShown = true;
        if (this.currentView == null && (view = SnapApp.getDefault().getSelectedProductSceneView()) != null) {
            this.handleViewActivated(view);
        }
    }

    protected void componentClosed() {
        this.isShown = false;
    }

    protected void productSceneViewSelected(ProductSceneView view) {
        this.handleViewActivated(view);
    }

    protected void productSceneViewDeselected(ProductSceneView view) {
        this.handleViewDeactivated(view);
    }

    private void setCurrentView(ProductSceneView view) {
        ProductSceneView oldView = this.currentView;
        this.currentView = view;
        if (oldView != this.currentView) {
            if (oldView != null) {
                oldView.removePropertyChangeListener("selectedPin", (PropertyChangeListener)this.pinSelectionChangeListener);
            }
            if (this.currentView != null) {
                this.currentView.addPropertyChangeListener("selectedPin", (PropertyChangeListener)this.pinSelectionChangeListener);
                this.setCurrentProduct(this.currentView.getProduct());
            } else {
                this.setCurrentProduct(null);
            }
            this.updateUIState();
        }
    }

    private void setCurrentProduct(Product product) {
        Product oldProduct = this.currentProduct;
        this.currentProduct = product;
        if (this.currentProduct != oldProduct) {
            if (oldProduct != null) {
                oldProduct.removeProductNodeListener((ProductNodeListener)this.productNodeHandler);
            }
            if (this.currentProduct != null) {
                this.currentProduct.addProductNodeListener((ProductNodeListener)this.productNodeHandler);
                TimeSeriesDiagram diagram = this.getDiagram();
                if (diagram != null) {
                    this.diagramCanvas.setDiagram(diagram);
                } else {
                    this.recreateDiagram();
                }
            }
            if (this.currentProduct == null) {
                this.diagramCanvas.setDiagram(null);
                this.diagramCanvas.setMessageText(MSG_NO_BANDS);
            } else {
                this.diagramCanvas.setMessageText(null);
            }
            this.updateUIState();
        }
    }

    private void updateUIState() {
        boolean hasView = this.currentView != null;
        boolean hasProduct = this.currentProduct != null;
        boolean hasSelectedPins = hasView && this.currentView.getSelectedPins().length > 0;
        boolean hasPins = hasProduct && this.currentProduct.getPinGroup().getNodeCount() > 0;
        boolean hasDiagram = this.diagramCanvas.getDiagram() != null;
        this.filterButton.setEnabled(hasProduct);
        this.showForCursorButton.setEnabled(hasView);
        this.showForSelectedPinsButton.setEnabled(hasSelectedPins);
        this.showForAllPinsButton.setEnabled(hasPins);
        this.showVectorAverageButton.setEnabled(hasDiagram);
        this.showAveragePinSpectrumButton.setEnabled(hasPins);
        this.diagramCanvas.setEnabled(hasProduct);
        this.exportTextButton.setEnabled(hasProduct);
        this.exportImageButton.setEnabled(hasProduct);
        if (this.diagramCanvas.getDiagram() != null) {
            this.diagramCanvas.getDiagram().setDrawGrid(this.settings.isShowingGrid());
        }
    }

    private void updateDiagram(ImageLayer imageLayer, int pixelX, int pixelY, int level) {
        this.diagramCanvas.setMessageText(null);
        TimeSeriesDiagram diagram = this.getDiagram();
        if (diagram != null && this.userSelectedBands != null && this.userSelectedBands.length > 0) {
            diagram.updateDiagram(imageLayer, pixelX, pixelY, level);
        } else {
            this.diagramCanvas.setMessageText(MSG_NO_BANDS);
        }
    }

    private TimeSeriesTimes getProductTimes() {
        boolean isCoreg = StackUtils.isCoregisteredStack((Product)this.currentProduct);
        if (isCoreg) {
            ProductData.UTC[] coregTimes = StackUtils.getProductTimes((Product)this.currentProduct);
            return new TimeSeriesTimes(coregTimes);
        }
        ArrayList<Product> products = new ArrayList<Product>(100);
        for (GraphData data : this.settings.getGraphDataList()) {
            products.addAll(Arrays.asList(data.getProducts()));
        }
        ArrayList<ProductData.UTC> utcList = new ArrayList<ProductData.UTC>(products.size());
        for (Product prod : products) {
            utcList.add(prod.getStartTime());
        }
        return new TimeSeriesTimes(utcList.toArray(new ProductData.UTC[utcList.size()]));
    }

    private Band[] getSelectedBands() {
        Band band;
        RasterDataNode currentRaster;
        if ((this.userSelectedBands == null || this.userSelectedBands.length == 0 || this.userSelectedBands[0].getProduct() == null) && this.currentView != null && (currentRaster = this.currentView.getRaster()) != null && (band = this.currentProduct.getBand(currentRaster.getName())) != null) {
            this.userSelectedBands = new Band[]{band};
        }
        return this.userSelectedBands;
    }

    private Band[] findBandAcrossProducts(Band userBand, Product[] products) {
        boolean isCoreg = StackUtils.isCoregisteredStack((Product)this.currentProduct);
        if (isCoreg) {
            ArrayList<Band> bands = new ArrayList<Band>();
            String bandName = TimeSeriesToolView.getCoregBandName(userBand);
            for (Band band : this.currentProduct.getBands()) {
                if (!band.getName().startsWith(bandName)) continue;
                bands.add(band);
            }
            return bands.toArray(new Band[bands.size()]);
        }
        ArrayList<Band> bands = new ArrayList<Band>(products.length);
        for (Product prod : products) {
            Band prodBand = prod.getBand(userBand.getName());
            if (prodBand == null) continue;
            bands.add(prodBand);
        }
        return bands.toArray(new Band[bands.size()]);
    }

    private static String getCoregBandName(Band band) {
        String bandName = band.getName();
        int suffixLoc = bandName.indexOf("_mst");
        if (suffixLoc < 0) {
            suffixLoc = bandName.indexOf("_slv");
        }
        if (suffixLoc < 0) {
            suffixLoc = bandName.indexOf("_");
        }
        return bandName.substring(0, suffixLoc);
    }

    private static Band[] getAvailableBands(Product[] products) {
        ArrayList<Band> availBands = new ArrayList<Band>(15);
        HashSet<String> nameSet = new HashSet<String>(15);
        for (Product prod : products) {
            Band[] bands = prod.getBands();
            boolean isCoreg = StackUtils.isCoregisteredStack((Product)prod);
            for (Band band : bands) {
                String bandName = band.getName();
                if (isCoreg) {
                    bandName = TimeSeriesToolView.getCoregBandName(band);
                }
                if (nameSet.contains(bandName)) continue;
                availBands.add(band);
                nameSet.add(bandName);
            }
        }
        return availBands.toArray(new Band[availBands.size()]);
    }

    public JComponent createPanel() {
        JButton settingsButton = DialogUtils.createButton((String)"Settings", (String)"Settings", (ImageIcon)UIUtils.loadImageIcon((String)"icons/Properties24.gif"), null, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesToolView.this.openSettingsDlg();
            }
        });
        this.filterButton = DialogUtils.createButton((String)"filterButton", (String)"Filter bands", (ImageIcon)UIUtils.loadImageIcon((String)"icons/Filter24.gif"), null, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.filterButton.setEnabled(false);
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesToolView.this.selectBands();
            }
        });
        this.showForCursorButton = DialogUtils.createIconButton((String)"showForCursorButton", (String)"Show at cursor position", (ImageIcon)UIUtils.loadImageIcon((String)"icons/CursorSpectrum24.gif"), (boolean)true);
        this.showForCursorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesToolView.this.recreateDiagram();
            }
        });
        this.showForCursorButton.setSelected(true);
        this.showForSelectedPinsButton = DialogUtils.createIconButton((String)"showForSelectedPinsButton", (String)"Show for selected pins", (ImageIcon)UIUtils.loadImageIcon((String)"icons/SelectedPinSpectra24.gif"), (boolean)true);
        this.showForSelectedPinsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeSeriesToolView.this.isShowingForAllPins()) {
                    TimeSeriesToolView.this.showForAllPinsButton.setSelected(false);
                }
                TimeSeriesToolView.this.recreateDiagram();
            }
        });
        this.showForAllPinsButton = DialogUtils.createIconButton((String)"showForAllPinsButton", (String)"Show for all pins", (ImageIcon)UIUtils.loadImageIcon((String)"icons/PinSpectra24.gif"), (boolean)true);
        this.showForAllPinsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeSeriesToolView.this.isShowingForSelectedPins()) {
                    TimeSeriesToolView.this.showForSelectedPinsButton.setSelected(false);
                }
                TimeSeriesToolView.this.recreateDiagram();
            }
        });
        this.showAveragePinSpectrumButton = DialogUtils.createIconButton((String)"showAveragePinSpectrumButton", (String)"Show average of all pins", (ImageIcon)UIUtils.loadImageIcon((String)"icons/AverageSpectrum24.gif"), (boolean)true);
        this.showAveragePinSpectrumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "Not implemented");
            }
        });
        this.showVectorAverageButton = DialogUtils.createIconButton((String)"showVectorAverageButton", (String)"Show averaged ROI", (ImageIcon)UIUtils.loadImageIcon((String)"icons/VectorDataNode24.gif"), (boolean)true);
        this.showVectorAverageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeSeriesToolView.this.showVectorAverageButton.isSelected()) {
                    TimeSeriesToolView.this.vectorStatistic = TimeSeriesToolView.this.getVectorStatisticType();
                }
                TimeSeriesToolView.this.recreateDiagram();
            }
        });
        this.exportTextButton = DialogUtils.createIconButton((String)"exportTextButton", (String)"Export graph to text file.", (ImageIcon)UIUtils.loadImageIcon((String)"icons/ExportTable.gif"), (boolean)false);
        this.exportTextButton.addActionListener(new TimeSeriesExportAction(this));
        this.exportImageButton = DialogUtils.createIconButton((String)"exportImageButton", (String)"Export graph to image file.", (ImageIcon)UIUtils.loadImageIcon((String)"icons/Export24.gif"), (boolean)false);
        this.exportImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesToolView.this.exportImage();
            }
        });
        JButton helpButton = DialogUtils.createIconButton((String)"helpButton", (String)"Help", (ImageIcon)UIUtils.loadImageIcon((String)"icons/Help24.gif"), (boolean)false);
        JPanel buttonPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets.top = 2;
        gbc.gridy = 0;
        buttonPane.add((Component)settingsButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.filterButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.showForCursorButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.showForSelectedPinsButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.showForAllPinsButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.showVectorAverageButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.exportTextButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.exportImageButton, gbc);
        ++gbc.gridy;
        gbc.insets.bottom = 0;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        buttonPane.add((Component)new JLabel(" "), gbc);
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.gridy = 10;
        gbc.anchor = 13;
        buttonPane.add((Component)helpButton, gbc);
        this.diagramCanvas = new TimeSeriesCanvas(this.settings);
        this.diagramCanvas.setPreferredSize(new Dimension(300, 200));
        this.diagramCanvas.setMessageText(MSG_NO_BANDS);
        this.diagramCanvas.setBackground(Color.white);
        this.diagramCanvas.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        JPanel mainPane = new JPanel(new BorderLayout(4, 4));
        mainPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPane.add("Center", (Component)((Object)this.diagramCanvas));
        mainPane.add("East", buttonPane);
        mainPane.setPreferredSize(new Dimension(320, 200));
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view != null) {
            this.handleViewActivated(view);
        } else {
            this.setCurrentView(view);
        }
        this.updateUIState();
        return mainPane;
    }

    private void exportImage() {
        GraphExportImageAction action = new GraphExportImageAction(this.getDiagram());
        action.exportImage();
    }

    private VectorGraph.TYPE getVectorStatisticType() {
        HashMap<String, Boolean> checkBoxMap = new HashMap<String, Boolean>(3);
        checkBoxMap.put("Mean", true);
        checkBoxMap.put("Standard Deviation", false);
        CheckListDialog dlg = new CheckListDialog("ROI Statistic", checkBoxMap, true);
        dlg.show();
        boolean doAverage = (Boolean)checkBoxMap.get("Mean");
        boolean doStdDev = (Boolean)checkBoxMap.get("Standard Deviation");
        if (doStdDev) {
            return VectorGraph.TYPE.STD_DEV;
        }
        return VectorGraph.TYPE.AVERAGE;
    }

    public void refresh() {
        this.recreateDiagram();
        this.updateUIState();
    }

    private void openSettingsDlg() {
        TimeSeriesSettingsDlg settingsDlg = new TimeSeriesSettingsDlg(SnapApp.getDefault().getMainFrame(), "Time Series Analysis Settings", "help", this.settings, this);
        settingsDlg.show();
    }

    private void selectBands() {
        BandChooser bandChooser;
        ArrayList<Product> productList = new ArrayList<Product>();
        for (GraphData data : this.settings.getGraphDataList()) {
            productList.addAll(Arrays.asList(data.getProducts()));
        }
        Band[] allBandNames = TimeSeriesToolView.getAvailableBands(productList.toArray(new Product[productList.size()]));
        Band[] selectedBands = this.getSelectedBands();
        if (selectedBands == null) {
            selectedBands = allBandNames;
        }
        if ((bandChooser = new BandChooser((Window)SnapApp.getDefault().getMainFrame(), "Available Bands", "help", allBandNames, selectedBands, true)).show() == 1) {
            this.userSelectedBands = bandChooser.getSelectedBands();
            this.recreateDiagram();
        }
    }

    TimeSeriesDiagram getDiagram() {
        Debug.assertNotNull((Object)this.currentProduct);
        return this.productToDiagramMap.get(this.currentProduct);
    }

    private void setDiagram(TimeSeriesDiagram newDiagram) {
        Debug.assertNotNull((Object)this.currentProduct);
        TimeSeriesDiagram oldDiagram = newDiagram != null ? this.productToDiagramMap.put(this.currentProduct, newDiagram) : this.productToDiagramMap.remove(this.currentProduct);
        this.diagramCanvas.setDiagram(newDiagram);
        if (oldDiagram != null && oldDiagram != newDiagram) {
            oldDiagram.dispose();
        }
    }

    private boolean isShowingCursor() {
        return this.showForCursorButton.isSelected();
    }

    private boolean isShowingPinSpectra() {
        return this.isShowingForSelectedPins() || this.isShowingForAllPins();
    }

    private boolean isShowingForAllPins() {
        return this.showForAllPinsButton.isSelected();
    }

    private boolean isShowingVectorAverage() {
        return this.showVectorAverageButton.isSelected();
    }

    private void recreateDiagram() {
        try {
            if (this.currentView == null) {
                return;
            }
            Product[] defaultProductList = this.settings.getGraphDataList().get(0).getProducts();
            if (defaultProductList == null || defaultProductList.length == 0) {
                return;
            }
            TimeSeriesDiagram diagram = new TimeSeriesDiagram(this.currentProduct);
            this.userSelectedBands = this.getSelectedBands();
            TimeSeriesTimes times = this.getProductTimes();
            for (Band band : this.userSelectedBands) {
                ProductNodeGroup vectorNodeGroup;
                if (this.isShowingForAllPins() || this.isShowingForSelectedPins()) {
                    Placemark[] pins = null;
                    if (this.isShowingForSelectedPins()) {
                        pins = this.currentView.getSelectedPins();
                    } else if (this.isShowingForAllPins()) {
                        Placemark[] pinGroup = this.currentProduct.getPinGroup();
                        pins = (Placemark[])pinGroup.toArray((ProductNode[])new Placemark[pinGroup.getNodeCount()]);
                    }
                    for (Placemark pin : pins) {
                        for (GraphData graphData : this.settings.getGraphDataList()) {
                            Band[] bands;
                            if (graphData.getProducts() == null || (bands = this.findBandAcrossProducts(band, graphData.getProducts())) == null || bands.length <= 0) continue;
                            TimeSeriesGraph graph = diagram.addPlacemarkGraph(pin, graphData);
                            graph.setBands(times, bands);
                        }
                    }
                }
                if (this.isShowingVectorAverage() && (vectorNodeGroup = this.currentProduct.getVectorDataGroup()) != null) {
                    String[] vectorNames;
                    for (String name : vectorNames = vectorNodeGroup.getNodeNames()) {
                        if (name.equals("pins") || name.equals("ground_control_points")) continue;
                        for (GraphData graphData : this.settings.getGraphDataList()) {
                            Band[] bands;
                            if (graphData.getProducts() == null || (bands = this.findBandAcrossProducts(band, graphData.getProducts())) == null || bands.length <= 0) continue;
                            TimeSeriesGraph graph = diagram.addVectorGraph((VectorDataNode)vectorNodeGroup.get(name), graphData, this.vectorStatistic);
                            graph.setBands(times, bands);
                        }
                    }
                }
                if (!this.isShowingCursor()) continue;
                for (GraphData graphData : this.settings.getGraphDataList()) {
                    Band[] bands;
                    if (graphData.getProducts() == null || (bands = this.findBandAcrossProducts(band, graphData.getProducts())) == null || bands.length <= 0) continue;
                    TimeSeriesGraph graph = diagram.addCursorGraph(graphData);
                    graph.setBands(times, bands);
                }
            }
            diagram.initAxis(times, this.findBandAcrossProducts(this.userSelectedBands[0], defaultProductList));
            this.setDiagram(diagram);
            this.updateUIState();
        }
        catch (Exception e) {
            System.out.println("Failed to create time series graphs " + e.getMessage());
        }
    }

    private boolean isShowingForSelectedPins() {
        return this.showForSelectedPinsButton.isSelected();
    }

    private void handleViewActivated(ProductSceneView view) {
        if (!this.isShown) {
            return;
        }
        view.addPixelPositionListener((PixelPositionListener)this.ppl);
        this.setCurrentView(view);
    }

    private void handleViewDeactivated(ProductSceneView view) {
        if (!this.isShown) {
            return;
        }
        view.removePixelPositionListener((PixelPositionListener)this.ppl);
        this.setCurrentView(null);
    }

    static /* synthetic */ Band[] access$2702(TimeSeriesToolView x0, Band[] x1) {
        x0.userSelectedBands = x1;
        return x1;
    }

    private class PinSelectionChangeListener
    implements PropertyChangeListener {
        private PinSelectionChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TimeSeriesToolView.this.recreateDiagram();
        }
    }

    public class ProductManagerListener
    implements ProductManager.Listener {
        public void productAdded(ProductManager.Event event) {
            Product product = event.getProduct();
        }

        public void productRemoved(ProductManager.Event event) {
            Product product = event.getProduct();
            if (TimeSeriesToolView.this.currentProduct == product) {
                TimeSeriesToolView.this.setDiagram(null);
                TimeSeriesToolView.this.setCurrentView(null);
                TimeSeriesToolView.this.setCurrentProduct(null);
                TimeSeriesToolView.access$2702(TimeSeriesToolView.this, null);
            }
        }
    }

    private class ProductNodeHandler
    extends ProductNodeListenerAdapter {
        private ProductNodeHandler() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            if (!this.isActive()) {
                return;
            }
            if (event.getSourceNode() instanceof Band) {
                String propertyName = event.getPropertyName();
                if (propertyName.equals("unit") || propertyName.equals("spectralWavelength")) {
                    TimeSeriesToolView.this.recreateDiagram();
                }
            } else if (event.getSourceNode() instanceof Placemark && TimeSeriesToolView.this.isShowingPinSpectra()) {
                TimeSeriesToolView.this.recreateDiagram();
            }
            TimeSeriesToolView.this.updateUIState();
        }

        public void nodeAdded(ProductNodeEvent event) {
            if (!this.isActive()) {
                return;
            }
            if (event.getSourceNode() instanceof Band) {
                TimeSeriesToolView.this.recreateDiagram();
            } else if (event.getSourceNode() instanceof Placemark && TimeSeriesToolView.this.isShowingPinSpectra()) {
                TimeSeriesToolView.this.recreateDiagram();
            }
            TimeSeriesToolView.this.updateUIState();
        }

        public void nodeRemoved(ProductNodeEvent event) {
            if (!this.isActive()) {
                return;
            }
            if (event.getSourceNode() instanceof Band) {
                TimeSeriesToolView.this.recreateDiagram();
            } else if (event.getSourceNode() instanceof Placemark && TimeSeriesToolView.this.isShowingPinSpectra()) {
                TimeSeriesToolView.this.recreateDiagram();
            }
            TimeSeriesToolView.this.updateUIState();
        }

        private boolean isActive() {
            return TimeSeriesToolView.this.isVisible() && TimeSeriesToolView.this.currentProduct != null;
        }
    }

    private class CursorPPL
    implements PixelPositionListener {
        private CursorPPL() {
        }

        public void pixelPosChanged(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
            TimeSeriesDiagram diagram;
            if (!TimeSeriesToolView.this.isShown) {
                return;
            }
            TimeSeriesToolView.this.diagramCanvas.setMessageText(null);
            if (pixelPosValid) {
                TimeSeriesToolView.this.updateDiagram(imageLayer, pixelX, pixelY, currentLevel);
            }
            if (e.isShiftDown() && (diagram = TimeSeriesToolView.this.getDiagram()) != null) {
                diagram.adjustAxes(true);
            }
        }

        public void pixelPosNotAvailable() {
            if (this.isActive()) {
                TimeSeriesToolView.this.diagramCanvas.repaint();
            }
        }

        private boolean isActive() {
            return TimeSeriesToolView.this.isVisible() && TimeSeriesToolView.this.isShowingCursor() && TimeSeriesToolView.this.getDiagram() != null;
        }
    }

    private class SpectrumIFL
    extends InternalFrameAdapter {
        private SpectrumIFL() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            if (contentPane instanceof ProductSceneView) {
                TimeSeriesToolView.this.handleViewActivated((ProductSceneView)contentPane);
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            if (contentPane instanceof ProductSceneView) {
                TimeSeriesToolView.this.handleViewDeactivated((ProductSceneView)contentPane);
            }
        }
    }
}

