/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.gpf.StackUtils;

public class TimeSeriesTimes {
    private final ProductData.UTC[] utcTimes;

    public TimeSeriesTimes(ProductData.UTC[] times) {
        this.utcTimes = TimeSeriesTimes.sortTimes(times);
    }

    public int length() {
        return this.utcTimes.length;
    }

    public ProductData.UTC getTimeAt(int index) {
        return this.utcTimes[index];
    }

    public int getIndex(Band band) {
        Product product = band.getProduct();
        if (StackUtils.isCoregisteredStack((Product)product)) {
            if (TimeSeriesTimes.foundInMaster(product, band)) {
                return this.getIndex(product.getStartTime());
            }
            return this.getIndex(TimeSeriesTimes.getSlaveTime(product, band));
        }
        return this.getIndex(product.getStartTime());
    }

    private static boolean foundInMaster(Product product, Band band) {
        String[] mstBandNames;
        String bandName = band.getName();
        boolean isIntensity = bandName.startsWith("Intensity");
        for (String mstBand : mstBandNames = StackUtils.getMasterBandNames((Product)product)) {
            if (bandName.startsWith(mstBand)) {
                return true;
            }
            if (!isIntensity || !mstBand.startsWith("i_") || !(mstBand = mstBand.replace("i_", "Intensity_")).equals(bandName)) continue;
            return true;
        }
        return false;
    }

    public static ProductData.UTC getSlaveTime(Product sourceProduct, Band slvBand) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            String slvBandName = slvBand.getName();
            boolean isIntensity = slvBandName.startsWith("Intensity");
            for (MetadataElement elem : slaveMetadataRoot.getElements()) {
                String iName;
                String slvBandNames = elem.getAttributeString("Slave_bands", "");
                if (slvBandName.contains(slvBandNames)) {
                    return elem.getAttributeUTC("first_line_time");
                }
                if (!isIntensity || !slvBandNames.contains(iName = slvBandName.replace("Intensity_", "i_"))) continue;
                return elem.getAttributeUTC("first_line_time");
            }
        }
        return null;
    }

    public int getIndex(ProductData.UTC time) {
        int i = 0;
        for (ProductData.UTC utc : this.utcTimes) {
            if (utc.getMJD() == time.getMJD()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ProductData.UTC[] getUTCTimes() {
        return this.utcTimes;
    }

    private static ProductData.UTC[] sortTimes(ProductData.UTC[] times) {
        ArrayList timesList = new ArrayList(100);
        Collections.addAll(timesList, times);
        Collections.sort(timesList, new Comparator<ProductData.UTC>(){

            @Override
            public int compare(ProductData.UTC t1, ProductData.UTC t2) {
                if (t1 == null || t2 == null) {
                    return 0;
                }
                return t1.getAsDate().compareTo(t2.getAsDate());
            }
        });
        return timesList.toArray(new ProductData.UTC[timesList.size()]);
    }
}

