/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.terrasarx;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.binary.ArrayCopy;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.s1tbx.io.terrasarx.TerraSarXProductDirectory;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class TerraSarXProductReader
extends SARReader {
    private TerraSarXProductDirectory dataDir = null;

    public TerraSarXProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public void close() throws IOException {
        if (this.dataDir != null) {
            this.dataDir.close();
            this.dataDir = null;
        }
        super.close();
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        Product product = null;
        try {
            File fileFromInput = ReaderUtils.getFileFromInput((Object)this.getInput());
            this.dataDir = new TerraSarXProductDirectory(fileFromInput);
            this.dataDir.readProductDirectory();
            product = this.dataDir.createProduct();
            product.setFileLocation(fileFromInput);
            product.setProductReader((ProductReader)this);
            TerraSarXProductReader.setQuicklookBandName(product);
            this.addQuicklooks(product);
            product.getGcpGroup();
            product.setModified(false);
        }
        catch (Throwable e) {
            this.handleReaderException(e);
        }
        return product;
    }

    private void addQuicklooks(Product product) {
        if (this.dataDir.isTanDEMX()) {
            this.addQuicklook(product, "Quicklook", this.getQuicklookFile("COMMON_PREVIEW/QL_SLT_ampl_composite.tif"));
            this.addQuicklook(product, "QL_SLT_coher", this.getQuicklookFile("COMMON_PREVIEW/QL_SLT_coher.tif"));
            this.addQuicklook(product, "QL_SLT_phase", this.getQuicklookFile("COMMON_PREVIEW/QL_SLT_phase.tif"));
            this.addQuicklook(product, "QL_GTC_amplitude", this.getQuicklookFile("COMMON_PREVIEW/QL_GTC_amplitude.tif"));
            this.addQuicklook(product, "QL_GTC_coherence", this.getQuicklookFile("COMMON_PREVIEW/QL_GTC_coherence.tif"));
            this.addQuicklook(product, "QL_GTC_DEM", this.getQuicklookFile("COMMON_PREVIEW/QL_GTC_DEM.tif"));
            this.addQuicklook(product, "QL_SLT_dinsar_phase", this.getQuicklookFile("COMMON_PREVIEW/QL_SLT_dinsar_phase.tif"));
            this.addQuicklook(product, "QL_SLT_dinsar_radargr", this.getQuicklookFile("COMMON_PREVIEW/QL_SLT_dinsar_radargr.tif"));
        } else {
            this.addQuicklook(product, "Quicklook", this.getQuicklookFile("PREVIEW/BROWSE.tif"));
        }
    }

    private File getQuicklookFile(String relativeFilePath) {
        try {
            if (this.dataDir.exists(this.dataDir.getRootFolder() + relativeFilePath)) {
                return this.dataDir.getFile(this.dataDir.getRootFolder() + relativeFilePath);
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to load quicklook " + this.dataDir.getProductName());
        }
        return null;
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        try {
            ImageIOFile.BandInfo bandInfo = this.dataDir.getBandInfo(destBand);
            if (bandInfo != null && bandInfo.img != null) {
                Product product = destBand.getProduct();
                if (this.dataDir.isMapProjected()) {
                    bandInfo.img.readImageIORasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, bandInfo.imageID, bandInfo.bandSampleOffset);
                } else {
                    MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
                    boolean isAscending = absRoot.getAttributeString("PASS").equals("ASCENDING");
                    if (isAscending) {
                        this.readAscendingRasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, 0, bandInfo.img, bandInfo.bandSampleOffset);
                    } else {
                        this.readDescendingRasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, 0, bandInfo.img, bandInfo.bandSampleOffset);
                    }
                }
            } else {
                ImageInputStream iiStream = this.dataDir.getCosarImageInputStream(destBand);
                boolean isImaginary = destBand.getUnit() != null && destBand.getUnit().equals("imaginary");
                TerraSarXProductReader.readBandRasterDataSLC16Bit(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, !isImaginary, iiStream, pm);
            }
        }
        catch (Exception e) {
            this.handleReaderException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAscendingRasterBand(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, ProductData destBuffer, int destOffsetX, int destOffsetY, int destWidth, int destHeight, int imageID, ImageIOFile img, int bandSampleOffset) throws IOException {
        Raster data;
        TerraSarXProductDirectory terraSarXProductDirectory = this.dataDir;
        synchronized (terraSarXProductDirectory) {
            ImageReader reader = img.getReader();
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceSubsampling(sourceStepX, sourceStepY, sourceOffsetX % sourceStepX, sourceOffsetY % sourceStepY);
            RenderedImage image = reader.readAsRenderedImage(0, param);
            Rectangle rect = new Rectangle(destOffsetX, Math.max(0, img.getSceneHeight() - destOffsetY - destHeight), destWidth, destHeight);
            data = image.getData(rect);
        }
        int w = data.getWidth();
        int h = data.getHeight();
        DataBuffer dataBuffer = data.getDataBuffer();
        SampleModel sampleModel = data.getSampleModel();
        int sampleOffset = imageID + bandSampleOffset;
        double[] dArray = new double[dataBuffer.getSize()];
        sampleModel.getSamples(0, 0, w, h, sampleOffset, dArray, dataBuffer);
        for (int r = 0; r < h; ++r) {
            for (int c = 0; c < w; ++c) {
                int is = r * w + c;
                int id = (h - r - 1) * w + c;
                destBuffer.setElemDoubleAt(id, dArray[is]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDescendingRasterBand(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, ProductData destBuffer, int destOffsetX, int destOffsetY, int destWidth, int destHeight, int imageID, ImageIOFile img, int bandSampleOffset) throws IOException {
        Raster data;
        TerraSarXProductDirectory terraSarXProductDirectory = this.dataDir;
        synchronized (terraSarXProductDirectory) {
            ImageReader reader = img.getReader();
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceSubsampling(sourceStepX, sourceStepY, sourceOffsetX % sourceStepX, sourceOffsetY % sourceStepY);
            RenderedImage image = reader.readAsRenderedImage(0, param);
            data = image.getData(new Rectangle(Math.max(0, img.getSceneWidth() - destOffsetX - destWidth), destOffsetY, destWidth, destHeight));
        }
        int w = data.getWidth();
        int h = data.getHeight();
        DataBuffer dataBuffer = data.getDataBuffer();
        SampleModel sampleModel = data.getSampleModel();
        int sampleOffset = imageID + bandSampleOffset;
        double[] dArray = new double[dataBuffer.getSize()];
        sampleModel.getSamples(0, 0, w, h, sampleOffset, dArray, dataBuffer);
        for (int r = 0; r < h; ++r) {
            for (int c = 0; c < w; ++c) {
                int is = r * w + c;
                int id = r * w + w - c - 1;
                destBuffer.setElemDoubleAt(id, dArray[is]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void readBandRasterDataSLC16Bit(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destWidth, ProductData destBuffer, boolean oneOf2, ImageInputStream iiStream, ProgressMonitor pm) throws IOException {
        iiStream.seek(0L);
        int bib = iiStream.readInt();
        int rsri = iiStream.readInt();
        int rs = iiStream.readInt();
        int as = iiStream.readInt();
        int bi = iiStream.readInt();
        int rtnb = iiStream.readInt();
        int tnl = iiStream.readInt();
        long imageRecordLength = rtnb;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int x = sourceOffsetX * 4;
        int filler = 2;
        int asri = rs;
        int asfv = rs;
        int aslv = rs;
        int csar = iiStream.readInt();
        int version = iiStream.readInt();
        if (version != 1 && version != 2) {
            throw new IOException("Unknown version = " + version);
        }
        boolean isSSC = version == 1;
        long xpos = rtnb + x + (2 + asri + 2 + asfv + 2 + aslv + 2) * 4;
        iiStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        pm.beginTask("Reading band...", sourceMaxY - sourceOffsetY);
        int y = 0;
        if (isSSC) {
            short[] destLine = new short[destWidth];
            try {
                short[] srcLine = new short[sourceWidth * 2];
                for (y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                    if (pm.isCanceled()) {
                    }
                    iiStream.seek(imageRecordLength * (long)y + xpos);
                    iiStream.readFully(srcLine, 0, srcLine.length);
                    int currentLineIndex = (y - sourceOffsetY) * destWidth;
                    if (oneOf2) {
                        ArrayCopy.copyLine1Of2(srcLine, destLine, sourceStepX);
                    } else {
                        ArrayCopy.copyLine2Of2(srcLine, destLine, sourceStepX);
                    }
                    System.arraycopy(destLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                    pm.worked(1);
                }
            }
            catch (Exception e) {
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                Arrays.fill(destLine, (short)0);
                System.arraycopy(destLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
            }
            finally {
                pm.done();
            }
        } else {
            char[] destLine = new char[destWidth];
            try {
                char[] srcLine = new char[sourceWidth * 2];
                for (y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    iiStream.seek(imageRecordLength * (long)y + xpos);
                    iiStream.readFully(srcLine, 0, srcLine.length);
                    int currentLineIndex = (y - sourceOffsetY) * destWidth;
                    if (oneOf2) {
                        ArrayCopy.copyLine1Of2(srcLine, destLine, sourceStepX);
                    } else {
                        ArrayCopy.copyLine2Of2(srcLine, destLine, sourceStepX);
                    }
                    for (int i = 0; i < destWidth; ++i) {
                        destBuffer.setElemFloatAt(i + currentLineIndex, ArrayCopy.convert16BitsTo32BitFloat(destLine[i]));
                    }
                    pm.worked(1);
                }
            }
            catch (Exception e) {
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                Arrays.fill(destLine, '\u0000');
                for (int i = 0; i < destWidth; ++i) {
                    destBuffer.setElemFloatAt(i + currentLineIndex, ArrayCopy.convert16BitsTo32BitFloat(destLine[i]));
                }
            }
            finally {
                pm.done();
            }
        }
    }
}

