/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.terrasarx;

import Jama.Matrix;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.FileImageInputStreamExtImpl;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.XMLProductDirectory;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.util.Maths;
import org.esa.snap.engine_utilities.util.ZipUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class TerraSarXProductDirectory
extends XMLProductDirectory {
    private static final String TERRA_SAR_X = "TerraSAR-X";
    private static final String TAN_DEM_X = "TanDEM-X";
    private final File headerFile;
    private String productName = null;
    private String productType = null;
    private String productDescription = "";
    private final double[] latCorners = new double[4];
    private final double[] lonCorners = new double[4];
    private final double[] slantRangeCorners = new double[4];
    private final double[] incidenceCorners = new double[4];
    private final List<File> cosarFileList = new ArrayList<File>(1);
    private final Map<String, ImageInputStream> cosarBandMap = new HashMap<String, ImageInputStream>(1);
    private static final DateFormat standardDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private String masterSatellite = null;
    private String slaveSatellite = null;
    private String masterProductName = null;
    private String slaveProductName = null;
    private int numMasterBands = 0;
    private boolean isTanDEMX = false;

    public TerraSarXProductDirectory(File inputFile) {
        super(inputFile);
        this.headerFile = inputFile;
    }

    @Override
    protected String getHeaderFileName() {
        if (ZipUtils.isZip((File)this.headerFile)) {
            return "";
        }
        return this.headerFile.getName();
    }

    @Override
    protected String getRelativePathToImageFolder() {
        return this.getRootFolder() + "IMAGEDATA" + '/';
    }

    private static void replaceAbstractedMetadataField(MetadataElement abstractedMetadata, String attrName, String newValue) {
        ProductData productData = abstractedMetadata.getAttribute(attrName).getData();
        productData.setElems((Object)newValue);
    }

    private MetadataElement addMetaDataForTanDemX() throws IOException {
        Element mainRootElement = this.xmlDoc.getRootElement();
        String inSARmasterID = mainRootElement.getChild("commonAcquisitionInfo").getChild("inSARmasterID").getText().toLowerCase();
        String inSARslaveID = inSARmasterID.endsWith("1") ? "sat2" : "sat1";
        this.masterSatellite = mainRootElement.getChild("commonAcquisitionInfo").getChild("satelliteID" + inSARmasterID).getText();
        this.slaveSatellite = mainRootElement.getChild("commonAcquisitionInfo").getChild("satelliteID" + inSARslaveID).getText();
        List componentList = mainRootElement.getChild("productComponents").getChildren("component");
        Element masterAnnotationComponent = null;
        Element slaveAnnotationComponent = null;
        for (Element component : componentList) {
            String satId = component.getChild("instrument").getChildText("satIDs");
            if (component.getChildText("name").startsWith("cossc_annotation")) {
                if (satId.equals(this.masterSatellite)) {
                    masterAnnotationComponent = component;
                }
                if (satId.equals(this.slaveSatellite)) {
                    slaveAnnotationComponent = component;
                }
            }
            if (masterAnnotationComponent == null || slaveAnnotationComponent == null) continue;
            break;
        }
        if (masterAnnotationComponent == null) {
            throw new IOException("Cannot locate primary annotation component (master product) in main annotation of TDM product");
        }
        if (slaveAnnotationComponent == null) {
            throw new IOException("Cannot locate secondary annotation component (slave product) in main annotation of TDM product");
        }
        String masterHeader = masterAnnotationComponent.getChild("file").getChild("location").getChildText("name");
        this.masterProductName = masterHeader.substring(0, masterHeader.indexOf(47));
        String slaveHeader = slaveAnnotationComponent.getChild("file").getChild("location").getChildText("name");
        this.slaveProductName = slaveHeader.substring(0, slaveHeader.indexOf(47));
        Document slaveDoc = XMLSupport.LoadXML((InputStream)this.getInputStream(slaveHeader));
        Element slaveRootElement = slaveDoc.getRootElement();
        MetadataElement slaveRoot = new MetadataElement("Slave_Metadata");
        AbstractMetadataIO.AddXMLMetadata((Element)slaveRootElement, (MetadataElement)AbstractMetadata.addOriginalProductMetadata((MetadataElement)slaveRoot));
        this.addAbstractedMetadataHeader(slaveRoot);
        MetadataElement slaveAbstractedMetadataElem = slaveRoot.getElement("Abstracted_Metadata");
        MetadataElement productInfo = new MetadataElement("Product_Information");
        MetadataElement inputProd = new MetadataElement("InputProducts");
        productInfo.addElement(inputProd);
        inputProd.setAttributeString("InputProduct", this.slaveProductName);
        slaveAbstractedMetadataElem.addElement(productInfo);
        slaveAbstractedMetadataElem.setName(this.slaveProductName);
        slaveRoot.removeElement(slaveRoot.getElement("Original_Product_Metadata"));
        MetadataElement metadataRoot = new MetadataElement("metadata");
        Document masterDoc = XMLSupport.LoadXML((InputStream)this.getInputStream(masterHeader));
        Element masterRootElement = masterDoc.getRootElement();
        AbstractMetadataIO.AddXMLMetadata((Element)masterRootElement, (MetadataElement)AbstractMetadata.addOriginalProductMetadata((MetadataElement)metadataRoot));
        this.addAbstractedMetadataHeader(metadataRoot);
        MetadataElement abstractedMetadata = metadataRoot.getElement("Abstracted_Metadata");
        abstractedMetadata.setAttributeInt("coregistered_stack", 1);
        this.productName = this.getHeaderFileName().substring(0, this.getHeaderFileName().length() - 4);
        TerraSarXProductDirectory.replaceAbstractedMetadataField(abstractedMetadata, "PRODUCT", this.productName);
        this.productType = mainRootElement.getChild("productInfo").getChildText("productType");
        TerraSarXProductDirectory.replaceAbstractedMetadataField(abstractedMetadata, "PRODUCT_TYPE", this.productType);
        TerraSarXProductDirectory.replaceAbstractedMetadataField(abstractedMetadata, "SPH_DESCRIPTOR", mainRootElement.getChild("generalHeader").getChildText("itemName"));
        TerraSarXProductDirectory.replaceAbstractedMetadataField(abstractedMetadata, "MISSION", "TDM");
        MetadataElement cosscMetadataElem = new MetadataElement("CoSSC_Metadata");
        AbstractMetadataIO.AddXMLMetadata((Element)mainRootElement, (MetadataElement)cosscMetadataElem);
        metadataRoot.addElement(cosscMetadataElem);
        abstractedMetadata.setAttributeInt("bistatic_stack", 1);
        metadataRoot.addElement(slaveRoot);
        return metadataRoot;
    }

    public boolean isTanDEMX() {
        return this.isTanDEMX;
    }

    @Override
    protected MetadataElement addMetaData() throws IOException {
        if (this.getHeaderFileName().startsWith("TSX") || this.getHeaderFileName().startsWith("TDX")) {
            this.productName = TERRA_SAR_X;
            this.productType = TERRA_SAR_X;
            return super.addMetaData();
        }
        if (this.getHeaderFileName().startsWith("TDM")) {
            this.productName = TAN_DEM_X;
            this.productType = TAN_DEM_X;
            this.isTanDEMX = true;
            return this.addMetaDataForTanDemX();
        }
        throw new IOException("Invalid header file: " + this.getHeaderFileName());
    }

    @Override
    protected void addAbstractedMetadataHeader(MetadataElement root) throws IOException {
        String antennaReceiveConfiguration;
        MetadataElement doppler;
        MetadataElement processingParameter;
        MetadataElement acquisitionInfo;
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        MetadataElement origProdRoot = AbstractMetadata.addOriginalProductMetadata((MetadataElement)root);
        String defStr = "-";
        int defInt = 99999;
        MetadataElement level1Elem = origProdRoot.getElementAt(0);
        MetadataElement generalHeader = level1Elem.getElement("generalHeader");
        MetadataElement productInfo = level1Elem.getElement("productInfo");
        MetadataElement productSpecific = level1Elem.getElement("productSpecific");
        MetadataElement missionInfo = productInfo.getElement("missionInfo");
        MetadataElement productVariantInfo = productInfo.getElement("productVariantInfo");
        MetadataElement imageDataInfo = productInfo.getElement("imageDataInfo");
        MetadataElement sceneInfo = productInfo.getElement("sceneInfo");
        MetadataElement processing = level1Elem.getElement("processing");
        MetadataElement instrument = level1Elem.getElement("instrument");
        MetadataElement platform = level1Elem.getElement("platform");
        MetadataElement complexImageInfo = productSpecific.getElement("complexImageInfo");
        MetadataElement geocodedImageInfo = productSpecific.getElement("geocodedImageInfo");
        MetadataAttribute attrib = generalHeader.getAttribute("fileName");
        if (attrib != null) {
            this.productName = attrib.getData().getElemString().replace("_____", "_").replace("__", "_");
        }
        if (this.productName.endsWith(".xml")) {
            this.productName = this.productName.substring(0, this.productName.length() - 4);
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)this.productName);
        this.productType = productVariantInfo.getAttributeString("productType", "-").replace("_____", "_").replace("__", "_");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)this.productType);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)generalHeader.getAttributeString("itemName", "-"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)"TSX");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PROC_TIME", (ProductData.UTC)ReaderUtils.getTime((MetadataElement)generalHeader, (String)"generationTime", (DateFormat)standardDateFormat));
        MetadataElement elem = generalHeader.getElement("generationSystem");
        if (elem != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)elem.getAttributeString("generationSystem", "-"));
        }
        if (missionInfo != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"orbit_cycle", (int)missionInfo.getAttributeInt("orbitCycle", 99999));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"REL_ORBIT", (int)missionInfo.getAttributeInt("relOrbit", 99999));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)missionInfo.getAttributeInt("absOrbit", 99999));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)missionInfo.getAttributeString("orbitDirection", "-"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)imageDataInfo.getAttributeString("imageDataType", "-"));
        }
        if ((acquisitionInfo = productInfo.getElement("acquisitionInfo")) != null) {
            String imagingMode = TerraSarXProductDirectory.getAcquisitionMode(acquisitionInfo.getAttributeString("imagingMode", "-"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ACQUISITION_MODE", (String)imagingMode);
            String lookDirection = acquisitionInfo.getAttributeString("lookDirection", "-");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"antenna_pointing", (String)lookDirection);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"BEAMS", (String)acquisitionInfo.getAttributeString("elevationBeamConfiguration", "-"));
            this.productDescription = this.productType + ' ' + imagingMode;
            if (missionInfo == null) {
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)acquisitionInfo.getAttributeString("orbitDirection", "-"));
            }
        }
        MetadataElement polarisationList = acquisitionInfo.getElement("polarisationList");
        MetadataAttribute[] polList = polarisationList.getAttributes();
        for (int i = 0; i < polList.length; ++i) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)AbstractMetadata.polarTags[i], (String)polList[i].getData().getElemString());
        }
        MetadataElement imageRaster = imageDataInfo.getElement("imageRaster");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (double)imageRaster.getAttributeDouble("azimuthLooks", 99999.0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (double)imageRaster.getAttributeDouble("rangeLooks", 99999.0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)imageRaster.getAttributeInt("numberOfColumns", 99999));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)imageRaster.getAttributeInt("numberOfRows", 99999));
        if (sceneInfo != null) {
            TerraSarXProductDirectory.setStartStopTime(absRoot, sceneInfo, imageRaster.getAttributeInt("numberOfRows", 99999));
            this.getCornerCoords(sceneInfo, geocodedImageInfo);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"avg_scene_height", (double)sceneInfo.getAttributeDouble("sceneAverageHeight", 99999.0));
        } else if (acquisitionInfo != null) {
            TerraSarXProductDirectory.setStartStopTime(absRoot, acquisitionInfo, imageRaster.getAttributeInt("numberOfRows", 99999));
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (double)this.latCorners[0]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (double)this.lonCorners[0]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (double)this.latCorners[1]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (double)this.lonCorners[1]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (double)this.latCorners[2]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (double)this.lonCorners[2]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (double)this.latCorners[3]);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (double)this.lonCorners[3]);
        String sampleType = absRoot.getAttributeString("SAMPLE_TYPE");
        if (sampleType.contains("COMPLEX") && complexImageInfo != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (double)complexImageInfo.getAttributeDouble("projectedSpacingAzimuth", 99999.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (double)complexImageInfo.getElement("projectedSpacingRange").getAttributeDouble("slantRange", 99999.0));
        } else {
            MetadataElement rowSpacing = imageDataInfo.getElement("imageRaster").getElement("rowSpacing");
            MetadataElement colSpacing = imageDataInfo.getElement("imageRaster").getElement("columnSpacing");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (double)rowSpacing.getAttributeDouble("rowSpacing", 99999.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (double)colSpacing.getAttributeDouble("columnSpacing", 99999.0));
        }
        if (instrument != null) {
            MetadataElement settings = instrument.getElement("settings");
            MetadataElement settingRecord = settings.getElement("settingRecord");
            MetadataElement PRF = settingRecord.getElement("PRF");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (double)PRF.getAttributeDouble("PRF", 99999.0));
            MetadataElement RSF = settings.getElement("RSF");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_sampling_rate", (double)(RSF.getAttributeDouble("RSF", 99999.0) / 1000000.0));
            MetadataElement radarParameters = instrument.getElement("radarParameters");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)(radarParameters.getAttributeDouble("centerFrequency", 99999.0) / 1000000.0));
        }
        int srgr = 1;
        if (productVariantInfo.getAttributeString("projection", " ").equalsIgnoreCase("SLANTRANGE")) {
            srgr = 0;
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)srgr);
        String mapProjection = productVariantInfo.getAttributeString("mapProjection", " ").trim();
        if (!mapProjection.isEmpty()) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"map_projection", (String)mapProjection);
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"abs_calibration_flag", (int)0);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)0);
        MetadataElement processingFlags = processing.getElement("processingFlags");
        if (processingFlags != null) {
            TerraSarXProductDirectory.setFlag(processingFlags, "rangeSpreadingLossCorrectedFlag", "true", absRoot, "range_spread_comp_flag");
            TerraSarXProductDirectory.setFlag(processingFlags, "elevationPatternCorrectedFlag", "true", absRoot, "ant_elev_corr_flag");
        }
        if ((processingParameter = processing.getElement("processingParameter")) != null) {
            double rangeBW = processingParameter.getAttributeDouble("totalProcessedRangeBandwidth");
            double azimuthBW = processingParameter.getAttributeDouble("totalProcessedAzimuthBandwidth");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_bandwidth", (double)(rangeBW / 1000000.0));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_bandwidth", (double)azimuthBW);
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"slant_range_to_first_pixel", (double)(Math.min(this.slantRangeCorners[0], this.slantRangeCorners[2]) / 1.0E9 * 1.49896229E8));
        MetadataElement calibration = level1Elem.getElement("calibration");
        if (calibration != null) {
            MetadataElement calibrationConstant = calibration.getElement("calibrationConstant");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"calibration_factor", (double)calibrationConstant.getAttributeDouble("calFactor", 99999.0));
        }
        if (platform != null) {
            MetadataElement orbit = platform.getElement("orbit");
            TerraSarXProductDirectory.addOrbitStateVectors(absRoot, orbit);
            TerraSarXProductDirectory.addSRGRCoefficients(absRoot, productSpecific, productInfo);
        }
        if ((doppler = processing.getElement("doppler")) != null) {
            MetadataElement dopplerCentroid = doppler.getElement("dopplerCentroid");
            TerraSarXProductDirectory.addDopplerCentroidCoefficients(absRoot, dopplerCentroid);
        }
        if ((antennaReceiveConfiguration = acquisitionInfo.getAttributeString("antennaReceiveConfiguration", "")).equals("DRA")) {
            MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata((MetadataElement)root);
            for (File cosFile : this.cosarFileList) {
                String fileName = cosFile.getName().toUpperCase();
                if (fileName.contains("_SRA_")) continue;
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)1);
                MetadataElement targetSlaveMetadata = new MetadataElement(fileName);
                targetSlaveMetadataRoot.addElement(targetSlaveMetadata);
                ProductUtils.copyMetadata((MetadataElement)absRoot, (MetadataElement)targetSlaveMetadata);
            }
        }
    }

    private void findImagesForTanDemX(MetadataElement newRoot) throws IOException {
        String parentPath = this.masterProductName + '/' + this.getRelativePathToImageFolder();
        this.findImages(parentPath, newRoot);
        this.numMasterBands = this.cosarFileList.size();
        parentPath = this.slaveProductName + '/' + this.getRelativePathToImageFolder();
        this.findImages(parentPath, newRoot);
    }

    @Override
    protected void findImages(MetadataElement newRoot) throws IOException {
        if (this.getHeaderFileName().startsWith("TSX") || this.getHeaderFileName().startsWith("TDX")) {
            super.findImages(newRoot);
        } else if (this.getHeaderFileName().startsWith("TDM")) {
            this.findImagesForTanDemX(newRoot);
        } else {
            throw new IOException("Invalid header file: " + this.getHeaderFileName());
        }
    }

    private static void setStartStopTime(MetadataElement absRoot, MetadataElement elem, int height) {
        ProductData.UTC startTime = ReaderUtils.getTime((MetadataElement)elem.getElement("start"), (String)"timeUTC", (DateFormat)standardDateFormat);
        ProductData.UTC stopTime = ReaderUtils.getTime((MetadataElement)elem.getElement("stop"), (String)"timeUTC", (DateFormat)standardDateFormat);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)startTime);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)stopTime);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)ReaderUtils.getLineTimeInterval((ProductData.UTC)startTime, (ProductData.UTC)stopTime, (int)height));
    }

    private static String getAcquisitionMode(String mode) {
        if (mode.equalsIgnoreCase("SM")) {
            return "Stripmap";
        }
        if (mode.equalsIgnoreCase("SL") || mode.equalsIgnoreCase("HS")) {
            return "Spotlight";
        }
        if (mode.equalsIgnoreCase("SC")) {
            return "ScanSAR";
        }
        return " ";
    }

    private static void setFlag(MetadataElement elem, String attribTag, String trueValue, MetadataElement absRoot, String absTag) {
        int val = 0;
        if (elem.getAttributeString(attribTag, " ").equalsIgnoreCase(trueValue)) {
            val = 1;
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)absTag, (int)val);
    }

    private void getCornerCoords(MetadataElement sceneInfo, MetadataElement geocodedImageInfo) {
        MetadataElement[] children;
        int maxRow = 0;
        int maxCol = 0;
        int minRow = Integer.MAX_VALUE;
        int minCol = Integer.MAX_VALUE;
        ArrayList<CornerCoord> coordList = new ArrayList<CornerCoord>();
        for (MetadataElement child : children = sceneInfo.getElements()) {
            if (!child.getName().equals("sceneCornerCoord")) continue;
            int refRow = child.getAttributeInt("refRow", 0);
            int refCol = child.getAttributeInt("refColumn", 0);
            coordList.add(new CornerCoord(refRow, refCol, child.getAttributeDouble("lat", 0.0), child.getAttributeDouble("lon", 0.0), child.getAttributeDouble("rangeTime", 0.0) * 1.0E9, child.getAttributeDouble("incidenceAngle", 0.0)));
            if (refRow > maxRow) {
                maxRow = refRow;
            }
            if (refCol > maxCol) {
                maxCol = refCol;
            }
            if (refRow < minRow) {
                minRow = refRow;
            }
            if (refCol >= minCol) continue;
            minCol = refCol;
        }
        int[] indexArray = new int[]{0, 1, 2, 3};
        if (minRow == maxRow && minCol == maxCol && geocodedImageInfo != null) {
            MetadataElement geoParameter = geocodedImageInfo.getElement("geoParameter");
            MetadataElement sceneCoordsGeographic = geoParameter.getElement("sceneCoordsGeographic");
            double latUL = sceneCoordsGeographic.getAttributeDouble("upperLeftLatitude", 0.0);
            double latUR = sceneCoordsGeographic.getAttributeDouble("upperRightLatitude", 0.0);
            double latLL = sceneCoordsGeographic.getAttributeDouble("lowerLeftLatitude", 0.0);
            double latLR = sceneCoordsGeographic.getAttributeDouble("lowerRightLatitude", 0.0);
            double lonUL = sceneCoordsGeographic.getAttributeDouble("upperLeftLongitude", 0.0);
            double lonUR = sceneCoordsGeographic.getAttributeDouble("upperRightLongitude", 0.0);
            double lonLL = sceneCoordsGeographic.getAttributeDouble("lowerLeftLongitude", 0.0);
            double lonLR = sceneCoordsGeographic.getAttributeDouble("lowerRightLongitude", 0.0);
            int k = 0;
            for (CornerCoord coord : coordList) {
                double d0 = Math.abs(coord.lat - latUL) + Math.abs(coord.lon - lonUL);
                double d1 = Math.abs(coord.lat - latUR) + Math.abs(coord.lon - lonUR);
                double d2 = Math.abs(coord.lat - latLL) + Math.abs(coord.lon - lonLL);
                double d3 = Math.abs(coord.lat - latLR) + Math.abs(coord.lon - lonLR);
                if (d0 <= d1 && d0 <= d2 && d0 <= d3) {
                    indexArray[k] = 0;
                } else if (d1 <= d0 && d1 <= d2 && d1 <= d3) {
                    indexArray[k] = 1;
                } else if (d2 <= d0 && d2 <= d1 && d2 <= d3) {
                    indexArray[k] = 2;
                } else if (d3 <= d0 && d3 <= d1 && d3 <= d2) {
                    indexArray[k] = 3;
                }
                ++k;
            }
        }
        int index = 0;
        for (CornerCoord coord : coordList) {
            if (minRow == maxRow && minCol == maxCol) {
                this.latCorners[indexArray[index]] = coord.lat;
                this.lonCorners[indexArray[index]] = coord.lon;
                this.slantRangeCorners[indexArray[index]] = coord.rangeTime;
                this.incidenceCorners[indexArray[index]] = coord.incidenceAngle;
                ++index;
                continue;
            }
            index = -1;
            if (coord.refRow == minRow) {
                index = Math.abs(coord.refCol - minCol) < Math.abs(coord.refCol - maxCol) ? 0 : 1;
            } else if (coord.refRow == maxRow) {
                index = Math.abs(coord.refCol - minCol) < Math.abs(coord.refCol - maxCol) ? 2 : 3;
            }
            if (index < 0) continue;
            this.latCorners[index] = coord.lat;
            this.lonCorners[index] = coord.lon;
            this.slantRangeCorners[index] = coord.rangeTime;
            this.incidenceCorners[index] = coord.incidenceAngle;
        }
    }

    @Override
    protected void addImageFile(String imgPath, MetadataElement newRoot) throws IOException {
        if (imgPath.toUpperCase().endsWith("COS")) {
            File file = new File(this.getBaseDir(), imgPath);
            this.cosarFileList.add(file);
            this.setSLC(true);
        } else {
            String name = TerraSarXProductDirectory.getBandFileNameFromImage(imgPath);
            if ((name.endsWith("tif") || name.endsWith("tiff")) && name.startsWith("image")) {
                Dimension bandDimensions = TerraSarXProductDirectory.getBandDimensions(newRoot, name);
                InputStream inStream = this.getInputStream(imgPath);
                ImageInputStream imgStream = ImageIOFile.createImageInputStream(inStream, bandDimensions);
                if (imgStream == null) {
                    throw new IOException("Unable to open " + imgPath);
                }
                ImageIOFile img = new ImageIOFile(name, imgStream, ImageIOFile.getTiffIIOReader(imgStream), 1, 1, 21, this.productInputFile);
                this.bandImageFileMap.put(img.getName(), img);
            }
        }
    }

    @Override
    protected void addGeoCoding(Product product) {
        File georefFile;
        File level1ProductDir = this.getBaseDir();
        if (this.getHeaderFileName().startsWith("TDM")) {
            level1ProductDir = new File(this.getBaseDir(), this.masterProductName);
        }
        if ((georefFile = new File(level1ProductDir, "ANNOTATION" + File.separator + "GEOREF.xml")).exists()) {
            try {
                TerraSarXProductDirectory.readGeoRef(product, georefFile);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        String sampleType = absRoot.getAttributeString("SAMPLE_TYPE");
        if (this.isMapProjected() || sampleType.contains("COMPLEX")) {
            ReaderUtils.addGeoCoding((Product)product, (double[])this.latCorners, (double[])this.lonCorners);
        } else {
            boolean isAscending = absRoot.getAttributeString("PASS").equals("ASCENDING");
            double[] flippedLatCorners = new double[4];
            double[] flippedLonCorners = new double[4];
            if (isAscending) {
                flippedLatCorners[0] = this.latCorners[2];
                flippedLatCorners[1] = this.latCorners[3];
                flippedLatCorners[2] = this.latCorners[0];
                flippedLatCorners[3] = this.latCorners[1];
                flippedLonCorners[0] = this.lonCorners[2];
                flippedLonCorners[1] = this.lonCorners[3];
                flippedLonCorners[2] = this.lonCorners[0];
                flippedLonCorners[3] = this.lonCorners[1];
            } else {
                flippedLatCorners[0] = this.latCorners[1];
                flippedLatCorners[1] = this.latCorners[0];
                flippedLatCorners[2] = this.latCorners[3];
                flippedLatCorners[3] = this.latCorners[2];
                flippedLonCorners[0] = this.lonCorners[1];
                flippedLonCorners[1] = this.lonCorners[0];
                flippedLonCorners[2] = this.lonCorners[3];
                flippedLonCorners[3] = this.lonCorners[2];
            }
            ReaderUtils.addGeoCoding((Product)product, (double[])flippedLatCorners, (double[])flippedLonCorners);
        }
    }

    private static void readGeoRef(Product product, File georefFile) throws IOException {
        Document xmlDoc = XMLSupport.LoadXML((String)georefFile.getAbsolutePath());
        Element root = xmlDoc.getRootElement();
        Element geoGrid = root.getChild("geolocationGrid");
        Element numGridPnt = geoGrid.getChild("numberOfGridPoints");
        Element numAzimuth = numGridPnt.getChild("azimuth");
        int numAz = Integer.parseInt(numAzimuth.getValue());
        Element numRange = numGridPnt.getChild("range");
        int numRg = Integer.parseInt(numRange.getValue());
        Element gridReferenceTime = geoGrid.getChild("gridReferenceTime");
        Element tReferenceTimeUTC = gridReferenceTime.getChild("tReferenceTimeUTC");
        int size = numAz * numRg;
        double[] latList = new double[size];
        double[] lonList = new double[size];
        double[] incList = new double[size];
        double[] timeList = new double[size];
        int[] row = new int[size];
        int[] col = new int[size];
        int i = 0;
        int r = numRg - 1;
        boolean c = false;
        boolean regridNeeded = false;
        List grdPntList = geoGrid.getChildren("gridPoint");
        for (Element pnt : grdPntList) {
            Element colElem;
            int index = i;
            Element tElem = pnt.getChild("tau");
            timeList[index] = Double.parseDouble(tElem.getValue());
            Element latElem = pnt.getChild("lat");
            latList[index] = Double.parseDouble(latElem.getValue());
            Element lonElem = pnt.getChild("lon");
            lonList[index] = Double.parseDouble(lonElem.getValue());
            Element rowElem = pnt.getChild("row");
            if (rowElem != null) {
                row[index] = Integer.parseInt(rowElem.getValue()) - 1;
                regridNeeded = true;
            }
            if ((colElem = pnt.getChild("col")) != null) {
                col[index] = Integer.parseInt(colElem.getValue()) - 1;
            }
            Element incElem = pnt.getChild("inc");
            incList[index] = Double.parseDouble(incElem.getValue());
            ++i;
        }
        int gridWidth = numRg;
        int gridHeight = numAz;
        int newGridWidth = gridWidth;
        int newGridHeight = gridHeight;
        float[] newLatList = new float[newGridWidth * newGridHeight];
        float[] newLonList = new float[newGridWidth * newGridHeight];
        float[] newIncList = new float[newGridWidth * newGridHeight];
        int sceneRasterWidth = product.getSceneRasterWidth();
        int sceneRasterHeight = product.getSceneRasterHeight();
        double subSamplingX = (double)sceneRasterWidth / (double)(newGridWidth - 1);
        double subSamplingY = (double)sceneRasterHeight / (double)(newGridHeight - 1);
        if (regridNeeded) {
            TerraSarXProductDirectory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, col, row, latList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newLatList);
            TerraSarXProductDirectory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, col, row, lonList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newLonList);
            TerraSarXProductDirectory.getListInEvenlySpacedGrid(sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, col, row, incList, newGridWidth, newGridHeight, subSamplingX, subSamplingY, newIncList);
        } else {
            for (int m = 0; m < newLatList.length; ++m) {
                newLatList[m] = (float)latList[m];
                newLonList[m] = (float)lonList[m];
                newIncList[m] = (float)incList[m];
            }
        }
        TiePointGrid latGrid = new TiePointGrid("latitude", newGridWidth, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newLatList);
        latGrid.setUnit("deg");
        product.addTiePointGrid(latGrid);
        TiePointGrid lonGrid = new TiePointGrid("longitude", newGridWidth, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newLonList, TiePointGrid.DISCONT_AT_180);
        lonGrid.setUnit("deg");
        product.addTiePointGrid(lonGrid);
        TiePointGrid incidentAngleGrid = new TiePointGrid("incident_angle", newGridWidth, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newIncList);
        incidentAngleGrid.setUnit("deg");
        product.addTiePointGrid(incidentAngleGrid);
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
    }

    private static void getListInEvenlySpacedGrid(int sceneRasterWidth, int sceneRasterHeight, int sourceGridWidth, int sourceGridHeight, int[] x, int[] y, double[] sourcePointList, int targetGridWidth, int targetGridHeight, double subSamplingX, double subSamplingY, float[] targetPointList) {
        if (sourcePointList.length != sourceGridWidth * sourceGridHeight) {
            throw new IllegalArgumentException("Original tie point array size does not match 'sourceGridWidth' x 'sourceGridHeight'");
        }
        if (targetPointList.length != targetGridWidth * targetGridHeight) {
            throw new IllegalArgumentException("Target tie point array size does not match 'targetGridWidth' x 'targetGridHeight'");
        }
        int k = 0;
        for (int r = 0; r < targetGridHeight; ++r) {
            double newY = (double)r * subSamplingY;
            if (newY > (double)(sceneRasterHeight - 1)) {
                newY = sceneRasterHeight - 1;
            }
            double oldY0 = 0.0;
            double oldY1 = 0.0;
            int j0 = 0;
            int j1 = 0;
            int rr = 1;
            while (rr < sourceGridHeight) {
                j0 = rr - 1;
                j1 = rr++;
                oldY0 = y[j0 * sourceGridWidth];
                oldY1 = y[j1 * sourceGridWidth];
                if (oldY1 > newY) break;
            }
            double wj = (newY - oldY0) / (oldY1 - oldY0);
            for (int c = 0; c < targetGridWidth; ++c) {
                double newX = (double)c * subSamplingX;
                if (newX > (double)(sceneRasterWidth - 1)) {
                    newX = sceneRasterWidth - 1;
                }
                double oldX0 = 0.0;
                double oldX1 = 0.0;
                int i0 = 0;
                int i1 = 0;
                int cc = 1;
                while (cc < sourceGridWidth) {
                    i0 = cc - 1;
                    i1 = cc++;
                    oldX0 = x[i0];
                    oldX1 = x[i1];
                    if (oldX1 > newX) break;
                }
                double wi = (newX - oldX0) / (oldX1 - oldX0);
                targetPointList[k++] = (float)MathUtils.interpolate2D((double)wi, (double)wj, (double)sourcePointList[i0 + j0 * sourceGridWidth], (double)sourcePointList[i1 + j0 * sourceGridWidth], (double)sourcePointList[i0 + j1 * sourceGridWidth], (double)sourcePointList[i1 + j1 * sourceGridWidth]);
            }
        }
    }

    @Override
    protected void addTiePointGrids(Product product) {
        int gridWidth = 4;
        int gridHeight = 4;
        double subSamplingX = (double)product.getSceneRasterWidth() / 3.0;
        double subSamplingY = (double)product.getSceneRasterHeight() / 3.0;
        if (subSamplingX == 0.0 || subSamplingY == 0.0) {
            return;
        }
        float[] flippedSlantRangeCorners = new float[4];
        float[] flippedIncidenceCorners = new float[4];
        this.getFlippedCorners(product, flippedSlantRangeCorners, flippedIncidenceCorners);
        if (product.getTiePointGrid("incident_angle") == null) {
            float[] fineAngles = new float[16];
            ReaderUtils.createFineTiePointGrid((int)2, (int)2, (int)4, (int)4, (float[])flippedIncidenceCorners, (float[])fineAngles);
            TiePointGrid incidentAngleGrid = new TiePointGrid("incident_angle", 4, 4, 0.0, 0.0, subSamplingX, subSamplingY, fineAngles);
            incidentAngleGrid.setUnit("deg");
            product.addTiePointGrid(incidentAngleGrid);
        }
        float[] fineSlantRange = new float[16];
        ReaderUtils.createFineTiePointGrid((int)2, (int)2, (int)4, (int)4, (float[])flippedSlantRangeCorners, (float[])fineSlantRange);
        TiePointGrid slantRangeGrid = new TiePointGrid("slant_range_time", 4, 4, 0.0, 0.0, subSamplingX, subSamplingY, fineSlantRange);
        slantRangeGrid.setUnit("ns");
        product.addTiePointGrid(slantRangeGrid);
    }

    private void getFlippedCorners(Product product, float[] flippedSlantRangeCorners, float[] flippedIncidenceCorners) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        String sampleType = absRoot.getAttributeString("SAMPLE_TYPE");
        if (this.isMapProjected() || sampleType.contains("COMPLEX")) {
            flippedSlantRangeCorners[0] = (float)this.slantRangeCorners[0];
            flippedSlantRangeCorners[1] = (float)this.slantRangeCorners[1];
            flippedSlantRangeCorners[2] = (float)this.slantRangeCorners[2];
            flippedSlantRangeCorners[3] = (float)this.slantRangeCorners[3];
            flippedIncidenceCorners[0] = (float)this.incidenceCorners[0];
            flippedIncidenceCorners[1] = (float)this.incidenceCorners[1];
            flippedIncidenceCorners[2] = (float)this.incidenceCorners[2];
            flippedIncidenceCorners[3] = (float)this.incidenceCorners[3];
        } else {
            boolean isAscending = absRoot.getAttributeString("PASS").equals("ASCENDING");
            if (isAscending) {
                flippedSlantRangeCorners[0] = (float)this.slantRangeCorners[2];
                flippedSlantRangeCorners[1] = (float)this.slantRangeCorners[3];
                flippedSlantRangeCorners[2] = (float)this.slantRangeCorners[0];
                flippedSlantRangeCorners[3] = (float)this.slantRangeCorners[1];
                flippedIncidenceCorners[0] = (float)this.incidenceCorners[2];
                flippedIncidenceCorners[1] = (float)this.incidenceCorners[3];
                flippedIncidenceCorners[2] = (float)this.incidenceCorners[0];
                flippedIncidenceCorners[3] = (float)this.incidenceCorners[1];
            } else {
                flippedSlantRangeCorners[0] = (float)this.slantRangeCorners[1];
                flippedSlantRangeCorners[1] = (float)this.slantRangeCorners[0];
                flippedSlantRangeCorners[2] = (float)this.slantRangeCorners[3];
                flippedSlantRangeCorners[3] = (float)this.slantRangeCorners[2];
                flippedIncidenceCorners[0] = (float)this.incidenceCorners[1];
                flippedIncidenceCorners[1] = (float)this.incidenceCorners[0];
                flippedIncidenceCorners[2] = (float)this.incidenceCorners[3];
                flippedIncidenceCorners[3] = (float)this.incidenceCorners[2];
            }
        }
    }

    private static String appendIfMatch(Band band, String key, String bands) {
        if (band.getName().contains(key)) {
            bands = bands + band.getName() + ' ';
        }
        return bands;
    }

    @Override
    protected void addBands(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        int width = absRoot.getAttributeInt("num_samples_per_line");
        int height = absRoot.getAttributeInt("num_output_lines");
        Set ImageKeys = this.bandImageFileMap.keySet();
        for (String key : ImageKeys) {
            ImageIOFile img = (ImageIOFile)this.bandImageFileMap.get(key);
            for (int i = 0; i < img.getNumImages(); ++i) {
                for (int b = 0; b < img.getNumBands(); ++b) {
                    String pol = SARReader.findPolarizationInBandName(img.getName());
                    Band band = new Band("Amplitude_" + (String)pol, img.getDataType(), width, height);
                    band.setUnit("amplitude");
                    product.addBand(band);
                    SARReader.createVirtualIntensityBand(product, band, '_' + (String)pol);
                    this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                }
            }
        }
        if (!this.cosarFileList.isEmpty()) {
            String masterBands = "";
            String slaveBands = "";
            boolean polsUnique = this.arePolarizationsUnique();
            String extraInfo = "";
            String mission = absRoot.getAttributeString("MISSION");
            for (File file : this.cosarFileList) {
                String fileName = file.getName().toUpperCase();
                String pol = SARReader.findPolarizationInBandName(fileName);
                if (mission.contains("TDM")) {
                    String level1ProductDirName = file.getParentFile().getParentFile().getName();
                    if (level1ProductDirName.equals(this.masterProductName)) {
                        extraInfo = "_mst";
                    } else if (level1ProductDirName.equals(this.slaveProductName)) {
                        extraInfo = "_slv1";
                    }
                    extraInfo = extraInfo + StackUtils.createBandTimeStamp((Product)product);
                } else if (!polsUnique) {
                    int polIndex = fileName.indexOf(pol);
                    extraInfo = fileName.substring(polIndex + 2, fileName.indexOf(46, polIndex + 3));
                }
                int bandDataType = mission.contains("TDM") ? 30 : 11;
                Band realBand = new Band("i_" + pol + extraInfo, bandDataType, width, height);
                realBand.setUnit("real");
                product.addBand(realBand);
                masterBands = TerraSarXProductDirectory.appendIfMatch(realBand, "mst", masterBands);
                slaveBands = TerraSarXProductDirectory.appendIfMatch(realBand, "slv", slaveBands);
                Band imaginaryBand = new Band("q_" + pol + extraInfo, bandDataType, width, height);
                imaginaryBand.setUnit("imaginary");
                product.addBand(imaginaryBand);
                masterBands = TerraSarXProductDirectory.appendIfMatch(imaginaryBand, "mst", masterBands);
                slaveBands = TerraSarXProductDirectory.appendIfMatch(imaginaryBand, "slv", slaveBands);
                ReaderUtils.createVirtualIntensityBand((Product)product, (Band)realBand, (Band)imaginaryBand, (String)"");
                try {
                    this.cosarBandMap.put(realBand.getName(), FileImageInputStreamExtImpl.createInputStream(file));
                    this.cosarBandMap.put(imaginaryBand.getName(), FileImageInputStreamExtImpl.createInputStream(file));
                }
                catch (Exception exception) {}
            }
            if (mission.contains("TDM")) {
                MetadataElement slaveMetadata = absRoot.getParentElement().getElement("Slave_Metadata");
                slaveMetadata.setAttributeString("Master_bands", masterBands);
                MetadataElement slaveProduct = slaveMetadata.getElement(this.slaveProductName);
                MetadataAttribute slaveBandsAttr = new MetadataAttribute("Slave_bands", 41);
                slaveProduct.addAttribute(slaveBandsAttr);
                slaveProduct.setAttributeString(slaveBandsAttr.getName(), slaveBands);
            }
        }
        absRoot.setAttributeInt("num_samples_per_line", width);
        absRoot.setAttributeInt("num_output_lines", height);
    }

    private boolean arePolarizationsUnique() {
        ArrayList<String> pols = new ArrayList<String>();
        for (File file : this.cosarFileList) {
            pols.add(SARReader.findPolarizationInBandName(file.getName()));
        }
        for (int i = 0; i < pols.size(); ++i) {
            for (int j = i + 1; j < pols.size(); ++j) {
                if (!((String)pols.get(i)).equals(pols.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private static void addOrbitStateVectors(MetadataElement absRoot, MetadataElement orbitInformation) {
        MetadataElement orbitVectorListElem = absRoot.getElement("Orbit_State_Vectors");
        MetadataElement[] stateVectorElems = orbitInformation.getElements();
        for (int i = 1; i < stateVectorElems.length; ++i) {
            TerraSarXProductDirectory.addVector("orbit_vector", orbitVectorListElem, stateVectorElems[i], i);
        }
        if (absRoot.getAttributeUTC("STATE_VECTOR_TIME", AbstractMetadata.NO_METADATA_UTC).equalElems((ProductData)AbstractMetadata.NO_METADATA_UTC)) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)ReaderUtils.getTime((MetadataElement)stateVectorElems[1], (String)"timeUTC", (DateFormat)standardDateFormat));
        }
    }

    private static void addVector(String name, MetadataElement orbitVectorListElem, MetadataElement srcElem, int num) {
        MetadataElement orbitVectorElem = new MetadataElement(name + num);
        orbitVectorElem.setAttributeUTC("time", ReaderUtils.getTime((MetadataElement)srcElem, (String)"timeUTC", (DateFormat)standardDateFormat));
        orbitVectorElem.setAttributeDouble("x_pos", srcElem.getAttributeDouble("posX", 0.0));
        orbitVectorElem.setAttributeDouble("y_pos", srcElem.getAttributeDouble("posY", 0.0));
        orbitVectorElem.setAttributeDouble("z_pos", srcElem.getAttributeDouble("posZ", 0.0));
        orbitVectorElem.setAttributeDouble("x_vel", srcElem.getAttributeDouble("velX", 0.0));
        orbitVectorElem.setAttributeDouble("y_vel", srcElem.getAttributeDouble("velY", 0.0));
        orbitVectorElem.setAttributeDouble("z_vel", srcElem.getAttributeDouble("velZ", 0.0));
        orbitVectorListElem.addElement(orbitVectorElem);
    }

    private static void addSRGRCoefficients(MetadataElement absRoot, MetadataElement productSpecific, MetadataElement productInfo) {
        MetadataElement sceneInfo = productInfo.getElement("sceneInfo");
        if (sceneInfo == null) {
            return;
        }
        MetadataElement rangeTime = sceneInfo.getElement("rangeTime");
        if (rangeTime == null) {
            return;
        }
        double firstPixelTime = rangeTime.getAttributeDouble("firstPixel");
        double lastPixelTime = rangeTime.getAttributeDouble("lastPixel");
        MetadataElement projectedImageInfo = productSpecific.getElement("projectedImageInfo");
        if (projectedImageInfo == null) {
            return;
        }
        MetadataElement slantToGroundRangeProjection = projectedImageInfo.getElement("slantToGroundRangeProjection");
        if (slantToGroundRangeProjection == null) {
            return;
        }
        double referencePoint = slantToGroundRangeProjection.getAttributeDouble("referencePoint");
        int polynomialDegree = slantToGroundRangeProjection.getAttributeInt("polynomialDegree");
        double[] s2gCoef = new double[polynomialDegree + 1];
        int cnt = 0;
        for (MetadataElement elem : slantToGroundRangeProjection.getElements()) {
            s2gCoef[cnt++] = elem.getAttributeDouble("coefficient", 0.0);
        }
        int m = 11;
        double[] sltRgTime = new double[12];
        double[] groundRange = new double[12];
        for (int i = 0; i <= 11; ++i) {
            sltRgTime[i] = firstPixelTime + (lastPixelTime - firstPixelTime) * (double)i / 11.0;
            groundRange[i] = Maths.computePolynomialValue((double)(sltRgTime[i] - referencePoint), (double[])s2gCoef);
        }
        double groundRangeRef = 0.0;
        double[] deltaGroundRange = new double[12];
        double deltaMax = groundRange[11] - 0.0;
        for (int i = 0; i <= 11; ++i) {
            deltaGroundRange[i] = (groundRange[i] - 0.0) / deltaMax;
        }
        Matrix G = Maths.createVandermondeMatrix((double[])deltaGroundRange, (int)11);
        Matrix tau = new Matrix(sltRgTime, 12);
        Matrix s = G.solve(tau);
        double[] g2sCoef = s.getColumnPackedCopy();
        double tmp = 1.0;
        int i = 0;
        while (i <= 11) {
            int n = i++;
            g2sCoef[n] = g2sCoef[n] * (1.49896229E8 / tmp);
            tmp *= deltaMax;
        }
        MetadataElement srgrCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
        MetadataElement srgrListElem = new MetadataElement("srgr_coef_list");
        srgrCoefficientsElem.addElement(srgrListElem);
        ProductData.UTC utcTime = absRoot.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
        srgrListElem.setAttributeUTC("zero_doppler_time", utcTime);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (int)31, (String)"m", (String)"Ground Range Origin");
        AbstractMetadata.setAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (double)0.0);
        for (int i2 = 0; i2 <= 11; ++i2) {
            MetadataElement coefElem = new MetadataElement("coefficient." + (i2 + 1));
            srgrListElem.addElement(coefElem);
            AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"srgr_coef", (int)31, (String)"", (String)"SRGR Coefficient");
            AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)g2sCoef[i2]);
        }
    }

    private static void addDopplerCentroidCoefficients(MetadataElement absRoot, MetadataElement dopplerCentroid) {
        MetadataElement[] dopplerElems = dopplerCentroid.getElements();
        MetadataElement dopplerCentroidCoefficientsElem = absRoot.getElement("Doppler_Centroid_Coefficients");
        int listCnt = 1;
        for (MetadataElement dopplerEstimate : dopplerElems) {
            if (!dopplerEstimate.getName().equalsIgnoreCase("dopplerEstimate")) continue;
            MetadataElement dopplerListElem = new MetadataElement("dop_coef_list." + listCnt);
            dopplerCentroidCoefficientsElem.addElement(dopplerListElem);
            ++listCnt;
            ProductData.UTC utcTime = ReaderUtils.getTime((MetadataElement)dopplerEstimate, (String)"timeUTC", (DateFormat)standardDateFormat);
            dopplerListElem.setAttributeUTC("zero_doppler_time", utcTime);
            MetadataElement combinedDoppler = dopplerEstimate.getElement("combinedDoppler");
            MetadataElement[] coefficients = combinedDoppler.getElements();
            int cnt = 1;
            for (MetadataElement coefficient : coefficients) {
                double coefValue = coefficient.getAttributeDouble("coefficient", 0.0);
                MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
                dopplerListElem.addElement(coefElem);
                ++cnt;
                AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"dop_coef", (int)31, (String)"", (String)"Doppler Centroid Coefficient");
                AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"dop_coef", (double)coefValue);
            }
        }
    }

    ImageInputStream getCosarImageInputStream(Band band) {
        return this.cosarBandMap.get(band.getName());
    }

    @Override
    public void close() throws IOException {
        super.close();
        Set<String> keys = this.cosarBandMap.keySet();
        for (String key : keys) {
            ImageInputStream img = this.cosarBandMap.get(key);
            img.close();
        }
    }

    @Override
    protected String getProductName() {
        return this.productName;
    }

    @Override
    protected String getProductDescription() {
        return this.productDescription;
    }

    @Override
    protected String getProductType() {
        return this.productType;
    }

    private static class CornerCoord {
        final int refRow;
        final int refCol;
        final double lat;
        final double lon;
        final double rangeTime;
        final double incidenceAngle;

        CornerCoord(int row, int col, double lt, double ln, double range, double angle) {
            this.refRow = row;
            this.refCol = col;
            this.lat = lt;
            this.lon = ln;
            this.rangeTime = range;
            this.incidenceAngle = angle;
        }
    }
}

