/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sentinel1;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s1tbx.io.FileImageInputStreamExtImpl;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Sentinel1Level0Reader {
    private final String SUPPORT_FOLDER_NAME = "support";
    private final String ANNOT_SCHEMA_FILENAME = "s1-level-0-annot.xsd";
    private final String INDEX_SCHEMA_FILENAME = "s1-level-0-index.xsd";
    private final String ANNOT_PREFIX = "-annot";
    private final String INDEX_PREFIX = "-index";
    private final String ANNOT_RECORD_NAME = "annotRecordType";
    private final String INDEX_RECORD_NAME = "block";
    private final String SIMPLE_TYPE_TAG_NAME = "xs:simpleType";
    private final String COMPLEX_TYPE_TAG_NAME = "xs:complexType";
    private final String SEQUENCE_TAG_NAME = "xs:sequence";
    private final String ELEMENT_TAG_NAME = "xs:element";
    private final String RESTRICTION_TAG_NAME = "xs:restriction";
    private final String ANNOTATION_TAG_NAME = "xs:annotation";
    private final String APPINFO_TAG_NAME = "xs:appinfo";
    private final String BLOCK_TAG_NAME = "sdf:block";
    private final String LENGTH_TAG_NAME = "sdf:length";
    private final String OCCURRENCE_TAG_NAME = "sdf:occurrence";
    private final String BOOLEAN_TAG_NAME = "xs:boolean";
    private final String UNSIGNED_BYTE_TAG_NAME = "xs:unsignedByte";
    private final String UNSIGNED_SHORT_TAG_NAME = "xs:unsignedShort";
    private final String UNSIGNED_INT_TAG_NAME = "xs:unsignedInt";
    private final String UNSIGNED_LONG_TAG_NAME = "xs:unsignedLong";
    private final String DOUBLE_TAG_NAME = "xs:double";
    private final List<String> baseTypeTagNameList = Arrays.asList("xs:boolean", "xs:unsignedByte", "xs:unsignedShort", "xs:unsignedInt", "xs:unsignedLong", "xs:double");
    private final String BIT_BASE_TYPE = "BIT_BASE_TYPE";
    private final String NAME_ATTRIBUTE = "name";
    private final String TYPE_ATTRIBUTE = "type";
    private final String BASE_ATTRIBUTE = "base";
    private final String UNIT_ATTRIBUTE = "unit";
    private ArrayList<DataElement> annotElemList = new ArrayList();
    private ArrayList<DataElement> indexElemList = new ArrayList();
    private ArrayList<DataComponent> dataComponents = new ArrayList();

    public Sentinel1Level0Reader(File baseDir, MetadataElement originalProductMetadata) {
        this.readXMLSchema(this.buildSchemaFilename(baseDir, "s1-level-0-annot.xsd"), "annotRecordType", this.annotElemList);
        this.readXMLSchema(this.buildSchemaFilename(baseDir, "s1-level-0-index.xsd"), "block", this.indexElemList);
        MetadataElement dataObjectSection = originalProductMetadata.getElement("XFDU").getElement("dataObjectSection");
        MetadataElement annotElem = new MetadataElement("Annotation Data Components");
        originalProductMetadata.addElement(annotElem);
        MetadataElement indexElem = new MetadataElement("Index Data Components");
        originalProductMetadata.addElement(indexElem);
        MetadataElement measurementDataElem = new MetadataElement("Measurement Data Components");
        originalProductMetadata.addElement(measurementDataElem);
        int numElem = dataObjectSection.getNumElements();
        for (int i = 0; i < numElem; ++i) {
            MetadataElement componentElem;
            MetadataElement recordElem;
            MetadataElement elem = dataObjectSection.getElementAt(i).getElement("byteStream");
            String dataFilename = elem.getElement("fileLocation").getAttributeString("href");
            MetadataElement metadataElement = recordElem = dataFilename.contains("-index") ? new MetadataElement("blocks") : new MetadataElement("records");
            if (dataFilename.contains("-annot")) {
                componentElem = new MetadataElement(Sentinel1Level0Reader.extractPolarization(dataFilename) + "annotation");
                annotElem.addElement(componentElem);
            } else if (dataFilename.contains("-index")) {
                componentElem = new MetadataElement(Sentinel1Level0Reader.extractPolarization(dataFilename) + "index");
                indexElem.addElement(componentElem);
            } else {
                componentElem = new MetadataElement(Sentinel1Level0Reader.extractPolarization(dataFilename) + "measurement_data");
                measurementDataElem.addElement(componentElem);
            }
            MetadataAttribute nameAttr = new MetadataAttribute("filename", 41);
            componentElem.addAttribute(nameAttr);
            nameAttr.getData().setElems((Object)dataFilename);
            MetadataAttribute numRecsAttr = new MetadataAttribute("number of " + recordElem.getName(), 22);
            componentElem.addAttribute(numRecsAttr);
            componentElem.addElement(recordElem);
            if (!dataFilename.contains("-annot") && !dataFilename.contains("-index")) continue;
            long numRecs = this.createBinaryReader(baseDir, dataFilename, recordElem);
            numRecsAttr.getData().setElemUInt(numRecs);
        }
    }

    private long createBinaryReader(File baseDir, String binDataFilename, MetadataElement metadataElement) {
        File binDataFile = new File(baseDir.getAbsolutePath() + binDataFilename);
        long numRecs = 0L;
        try {
            ImageInputStream imageInputStream = FileImageInputStreamExtImpl.createInputStream(binDataFile);
            BinaryFileReader binaryReader = new BinaryFileReader(imageInputStream);
            binaryReader.setByteOrder(ByteOrder.BIG_ENDIAN);
            DataComponent dataComponent = null;
            long filesize = binDataFile.length();
            if (binDataFilename.contains("-annot")) {
                numRecs = filesize / (long)this.getTotalNumberOfBytes(this.annotElemList);
                dataComponent = new DataComponent(binaryReader, this.annotElemList, metadataElement, numRecs);
            } else if (binDataFilename.contains("-index")) {
                numRecs = filesize / (long)this.getTotalNumberOfBytes(this.indexElemList);
                dataComponent = new DataComponent(binaryReader, this.indexElemList, metadataElement, numRecs);
            }
            this.dataComponents.add(dataComponent);
        }
        catch (IOException e) {
            System.out.println("Sentinel1Level0Reader.createBinaryReader: IOException " + e.getMessage());
        }
        return numRecs;
    }

    private String buildSchemaFilename(File baseDir, String schemaName) {
        return baseDir.getAbsolutePath() + File.separator + "support" + File.separator + schemaName;
    }

    private void readXMLSchema(String filename, String recordName, ArrayList<DataElement> elemList) {
        File xmlFile = new File(filename);
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(xmlFile);
            if (doc == null) {
                System.out.println("Sentinel1Level0Reader.readXMLSchema: ERROR failed to create Document for XML schema");
                return;
            }
            doc.getDocumentElement().normalize();
            Node recNode = this.getNodeFromDocument(doc, "xs:complexType", recordName);
            if (recNode == null) {
                System.out.println("Sentinel1Level0Reader.readXMLSchema: ERROR failed to find xs:complexType in schema");
                return;
            }
            Node sequenceNode = this.getNodeFromNode(recNode, "xs:sequence");
            if (sequenceNode == null) {
                System.out.println("Sentinel1Level0Reader.readXMLSchema: ERROR failed to find xs:sequence in schema");
                return;
            }
            this.getElementsInRecord(sequenceNode, elemList);
        }
        catch (IOException e) {
            System.out.println("Sentinel1Level0Reader.readXMLSchema: IOException " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            System.out.println("Sentinel1Level0Reader.readXMLSchema: ParserConfigurationException " + e.getMessage());
        }
        catch (SAXException e) {
            System.out.println("Sentinel1Level0Reader.readXMLSchema: SAXException " + e.getMessage());
        }
    }

    private Node getNodeFromDocument(Document doc, String nodeType, String nodeName) {
        NodeList nodeList = doc.getElementsByTagName(nodeType);
        Node recNode = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attr = node.getAttributes();
            for (int j = 0; j < attr.getLength(); ++j) {
                if (!attr.item(j).getNodeName().equals("name") || !attr.item(j).getTextContent().contains(nodeName)) continue;
                if (recNode == null) {
                    recNode = node;
                    continue;
                }
                System.out.println("Sentinel1Level0Reader.getNodeFromDocument: WARNING more than one " + nodeName + " of type " + nodeType + " in " + doc.getDocumentURI());
            }
        }
        return recNode;
    }

    private Node getNodeFromNode(Node parentNode, String nodeName) {
        Node node = null;
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(nodeName)) continue;
            if (node == null) {
                node = child;
                continue;
            }
            System.out.println("Sentinel1Level0Reader.getNodeFromNode: WARNING more than one " + nodeName + " in " + parentNode.getNodeName());
        }
        return node;
    }

    private Node getNodeFromNode(Node parentNode, String[] nodeNames) {
        Node node = parentNode;
        for (String n : nodeNames) {
            node = this.getNodeFromNode(node, n);
        }
        return node;
    }

    private Node getAttributeFromNode(Node node, String attrName) {
        NamedNodeMap attr = node.getAttributes();
        Node attrNode = null;
        for (int j = 0; j < attr.getLength(); ++j) {
            if (!attr.item(j).getNodeName().equals(attrName)) continue;
            if (attrNode == null) {
                attrNode = attr.item(j);
                continue;
            }
            System.out.println("Sentinel1Level0Reader.getAttributeFromNode: WARNING more than one " + attrName + " in " + node.getNodeName());
        }
        return attrNode;
    }

    private boolean isBaseType(Node node, String type, int[] numBytes, int[] numOccurrence) {
        if (this.baseTypeTagNameList.contains(type)) {
            numBytes[0] = -1;
            numOccurrence[0] = 1;
            String[] nodeNames = new String[]{"xs:annotation", "xs:appinfo", "sdf:block"};
            Node blockNode = this.getNodeFromNode(node, nodeNames);
            if (blockNode == null) {
                System.out.println("Sentinel1Level0Reader.getOccurrencesAndLength: no block in " + node.getNodeName());
                return true;
            }
            Node occurrenceNode = this.getNodeFromNode(blockNode, "sdf:occurrence");
            if (occurrenceNode != null) {
                numOccurrence[0] = Integer.parseInt(occurrenceNode.getTextContent());
            } else {
                System.out.println("Sentinel1Level0Reader.getOccurrencesAndLength: no occurrence in " + node.getNodeName());
            }
            Node lengthNode = this.getNodeFromNode(blockNode, "sdf:length");
            if (lengthNode != null) {
                numBytes[0] = Integer.parseInt(lengthNode.getTextContent());
            } else {
                System.out.println("Sentinel1Level0Reader.getOccurrencesAndLength: no length in " + node.getNodeName());
            }
            return true;
        }
        return false;
    }

    private String getBaseType(Document doc, String type, int[] numBytes) {
        String baseType = "";
        numBytes[0] = -1;
        Node typeNode = this.getNodeFromDocument(doc, "xs:simpleType", type);
        if (typeNode != null) {
            Node restrictionNode = this.getNodeFromNode(typeNode, "xs:restriction");
            if (restrictionNode == null) {
                System.out.println("Sentinel1Level0Reader.getBaseType: failed to find xs:restriction in " + typeNode.getNodeName());
                return baseType;
            }
            Node baseTypeNode = this.getAttributeFromNode(restrictionNode, "base");
            if (baseTypeNode == null) {
                System.out.println("Sentinel1Level0Reader.getBaseType: failed to find base in " + restrictionNode.getNodeName());
                return baseType;
            }
            baseType = baseTypeNode.getTextContent();
            String[] nodeNames = new String[]{"xs:annotation", "xs:appinfo", "sdf:block", "sdf:length"};
            Node lengthNode = this.getNodeFromNode(typeNode, nodeNames);
            if (lengthNode == null) {
                System.out.println("Sentinel1Level0Reader.getBaseType: failed to find sdf:length in branch of " + typeNode.getNodeName());
                return baseType;
            }
            numBytes[0] = Integer.parseInt(lengthNode.getTextContent());
            Node unitNode = this.getAttributeFromNode(lengthNode, "unit");
            if (unitNode != null && unitNode.getTextContent().equals("bit")) {
                baseType = "BIT_BASE_TYPE";
            }
        } else {
            System.out.println("Sentinel1Level0Reader.getBaseType: ERROR missing xs:simpleType in " + doc.getDocumentURI());
        }
        return baseType;
    }

    private void getElementsInRecord(Node sequenceNode, ArrayList<DataElement> elemList) {
        NodeList childNodes = sequenceNode.getChildNodes();
        DataElement prevDataElem = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals("xs:element")) continue;
            String elemName = "";
            String elemType = "";
            String elemBaseType = "";
            int[] elemNumOccurrences = new int[1];
            int[] elemNumBytes = new int[1];
            int startBit = -1;
            NamedNodeMap attr = child.getAttributes();
            for (int j = 0; j < attr.getLength(); ++j) {
                if (attr.item(j).getNodeName().equals("name")) {
                    elemName = attr.item(j).getTextContent();
                    continue;
                }
                if (!attr.item(j).getNodeName().equals("type")) continue;
                elemType = attr.item(j).getTextContent();
            }
            if (this.isBaseType(child, elemType, elemNumBytes, elemNumOccurrences)) {
                elemBaseType = elemType;
            } else {
                elemNumOccurrences[0] = 1;
                elemBaseType = this.getBaseType(sequenceNode.getOwnerDocument(), this.stripNamespace(elemType), elemNumBytes);
            }
            if (elemBaseType.equals("BIT_BASE_TYPE")) {
                int prevEndBit;
                startBit = prevDataElem == null ? 0 : (prevDataElem.baseType.equals("BIT_BASE_TYPE") ? ((prevEndBit = prevDataElem.startBit + prevDataElem.numBytes - 1) >= 7 ? 0 : prevEndBit + 1) : 0);
            }
            DataElement dataElement = new DataElement(elemName, elemType, elemBaseType, elemNumBytes[0], startBit, elemNumOccurrences[0]);
            elemList.add(dataElement);
            prevDataElem = dataElement;
        }
    }

    private String stripNamespace(String name) {
        return name.substring(name.lastIndexOf(":") + 1);
    }

    private void dumpElemList(String listName, ArrayList<DataElement> elemList) {
        System.out.println("Start of " + listName);
        for (DataElement dataElement : elemList) {
            dataElement.dump();
        }
        System.out.println("End of " + listName);
    }

    public void readData() {
        for (DataComponent d : this.dataComponents) {
            this.readBinaryData(d);
        }
    }

    private byte readOneBinaryElement(BinaryFileReader reader, DataElement elem, DataElement prevElem, byte prevByte, MetadataElement parentMetadataElem) {
        byte lastByteRead = 0;
        try {
            switch (elem.baseType) {
                case "xs:boolean": 
                case "xs:unsignedByte": {
                    int val = reader.readUB1();
                    MetadataAttribute attr = new MetadataAttribute(elem.name, 20);
                    ProductData productData = attr.getData();
                    productData.setElemInt(val);
                    parentMetadataElem.addAttribute(attr);
                    break;
                }
                case "xs:unsignedShort": {
                    int val = reader.readUB2();
                    MetadataAttribute attr = new MetadataAttribute(elem.name, 21);
                    ProductData productData = attr.getData();
                    productData.setElemInt(val);
                    parentMetadataElem.addAttribute(attr);
                    break;
                }
                case "xs:unsignedInt": {
                    long val = Sentinel1Level0Reader.getUnsignedInt(reader.readB4());
                    MetadataAttribute attr = new MetadataAttribute(elem.name, 22);
                    ProductData productData = attr.getData();
                    productData.setElemUInt(val);
                    parentMetadataElem.addAttribute(attr);
                    break;
                }
                case "xs:unsignedLong": {
                    byte[] bytes = new byte[8];
                    reader.read(bytes);
                    BigInteger val = new BigInteger(bytes);
                    String valStr = String.valueOf(val);
                    MetadataAttribute attr = new MetadataAttribute(elem.name, 41);
                    ProductData productData = attr.getData();
                    productData.setElems((Object)valStr);
                    parentMetadataElem.addAttribute(attr);
                    break;
                }
                case "xs:double": {
                    double val = reader.readB8();
                    MetadataAttribute attr = new MetadataAttribute(elem.name, 31);
                    ProductData productData = attr.getData();
                    productData.setElemDouble(val);
                    parentMetadataElem.addAttribute(attr);
                    break;
                }
                case "BIT_BASE_TYPE": {
                    if (prevElem == null || elem.startBit == 0) {
                        byte[] oneByte = new byte[1];
                        reader.read(oneByte);
                        lastByteRead = oneByte[0];
                    } else {
                        lastByteRead = prevByte;
                    }
                    byte val = Sentinel1Level0Reader.extract(lastByteRead, elem.startBit, elem.numBytes);
                    MetadataAttribute attr = new MetadataAttribute(elem.name, 20);
                    ProductData productData = attr.getData();
                    productData.setElemInt(Sentinel1Level0Reader.getInteger(val));
                    parentMetadataElem.addAttribute(attr);
                    break;
                }
                default: {
                    System.out.println("Sentinel1Level0Reader.readOneBinaryElement: ERROR Unknown baseType = " + elem.baseType);
                    break;
                }
            }
        }
        catch (IOException e) {
            System.out.println("Sentinel1Level0Reader.readOneBinaryElement: IOException " + e.getMessage());
        }
        catch (IllegalBinaryFormatException e) {
            System.out.println("Sentinel1Level0Reader.readOneBinaryElement: IllegalBinaryFormatException " + e.getMessage());
        }
        return lastByteRead;
    }

    private void readBinaryData(DataComponent dataComponent) {
        BinaryFileReader reader = dataComponent.reader;
        ArrayList elemList = dataComponent.elemList;
        MetadataElement parentMetadataElem = dataComponent.parentMetadataElem;
        for (long i = 0L; i < dataComponent.numRecords; ++i) {
            String parentName = parentMetadataElem.getName();
            MetadataElement recMetaElem = new MetadataElement(parentName.substring(0, parentName.length() - 1) + i);
            parentMetadataElem.addElement(recMetaElem);
            DataElement prevDataElem = null;
            byte prevByte = 0;
            for (DataElement elem : elemList) {
                for (int j = 0; j < elem.numOccurrences; ++j) {
                    prevByte = this.readOneBinaryElement(reader, elem, prevDataElem, prevByte, recMetaElem);
                    prevDataElem = elem;
                }
            }
        }
    }

    private static long getUnsignedInt(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    private static int getInteger(byte b) {
        return b & 0xFF;
    }

    private static byte extract(byte b, int startBit, int numBits) {
        int result = Sentinel1Level0Reader.getInteger(b) << startBit + 24;
        return (byte)(result >>>= 32 - numBits);
    }

    private static String extractPolarization(String filename) {
        int idx = filename.lastIndexOf("raw") + 6;
        String pp = filename.substring(idx, idx + 2);
        if (pp.equals("hh") || pp.equals("hv") || pp.equals("vv") || pp.equals("vh")) {
            return pp + "_";
        }
        return "";
    }

    private int getTotalNumberOfBytes(ArrayList<DataElement> elemList) {
        int total = 0;
        for (DataElement elem : elemList) {
            if (!elem.baseType.equals("BIT_BASE_TYPE")) {
                total += elem.numBytes * elem.numOccurrences;
                continue;
            }
            if (elem.startBit != 0) continue;
            ++total;
        }
        return total;
    }

    private class DataComponent {
        private final BinaryFileReader reader;
        private final ArrayList<DataElement> elemList;
        private final MetadataElement parentMetadataElem;
        private final long numRecords;

        DataComponent(BinaryFileReader reader, ArrayList<DataElement> elemList, MetadataElement parentMetadataElem, long numRecords) {
            this.reader = reader;
            this.elemList = elemList;
            this.parentMetadataElem = parentMetadataElem;
            this.numRecords = numRecords;
        }
    }

    private final class DataElement {
        private final String name;
        private final String type;
        private final String baseType;
        private final int numBytes;
        private final int startBit;
        private final int numOccurrences;

        DataElement(String name, String type, String baseType, int numBytes, int startBit, int numOccurrences) {
            this.name = name;
            this.type = type;
            this.baseType = baseType;
            this.numBytes = numBytes;
            this.startBit = startBit;
            this.numOccurrences = numOccurrences;
        }

        private void dump() {
            System.out.println(" name = " + this.name + "; type = " + this.type + "; baseType = " + this.baseType + "; numBytes = " + this.numBytes + "; startBit = " + this.startBit + "; numOccurrences = " + this.numOccurrences);
        }
    }
}

