/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.sentinel1;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.Rectangle;
import java.util.concurrent.TimeUnit;
import org.esa.s1tbx.io.imageio.ImageIOFile;

public class DataCache {
    private final LoadingCache<DataKey, Data> cache = CacheBuilder.newBuilder().maximumSize(500L).initialCapacity(500).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<DataKey, Data>(){

        public Data load(DataKey key) throws Exception {
            return new Data();
        }
    });

    public long size() {
        return this.cache.size();
    }

    public String stats() {
        return this.cache.stats().toString();
    }

    public Data get(DataKey key) {
        return (Data)this.cache.getUnchecked((Object)key);
    }

    public synchronized void put(DataKey key, Data value) {
        this.cache.put((Object)key, (Object)value);
    }

    public static class Data {
        public final boolean valid;
        public int[] intArray;

        public Data() {
            this.valid = false;
        }

        public Data(int[] srcArray) {
            this.intArray = srcArray;
            this.valid = true;
        }
    }

    public static class DataKey {
        private final ImageIOFile img;
        private final Rectangle rect;

        DataKey(ImageIOFile img, Rectangle rect) {
            this.img = img;
            this.rect = rect;
        }

        public boolean equals(Object obj) {
            DataKey key = (DataKey)obj;
            return this.rect.x == key.rect.x && this.rect.y == key.rect.y && this.rect.width == key.rect.width && this.rect.height == key.rect.height && this.img == key.img;
        }

        public int hashCode() {
            return this.img.hashCode();
        }

        public String toString() {
            return this.rect.toString();
        }
    }
}

