/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.radarsat2;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.s1tbx.io.radarsat2.Radarsat2ProductDirectory;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class Radarsat2ProductReader
extends SARReader {
    protected Radarsat2ProductDirectory dataDir = null;
    private static final String lutsigma = "lutSigma";
    private static final String lutgamma = "lutGamma";
    private static final String lutbeta = "lutBeta";
    private boolean isAscending;
    private boolean isAntennaPointingRight;
    private static final boolean flipToSARGeometry = System.getProperty(SystemUtils.getApplicationContextId() + ".flip.to.sar.geometry", "false").equals("true");

    public Radarsat2ProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public void close() throws IOException {
        if (this.dataDir != null) {
            this.dataDir.close();
            this.dataDir = null;
        }
        super.close();
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        try {
            File fileFromInput = ReaderUtils.getFileFromInput((Object)this.getInput());
            this.dataDir = this.createDirectory(fileFromInput);
            this.dataDir.readProductDirectory();
            Product product = this.dataDir.createProduct();
            MetadataElement absMeta = AbstractMetadata.getAbstractedMetadata((Product)product);
            this.isAscending = absMeta.getAttributeString("PASS").equals("ASCENDING");
            this.isAntennaPointingRight = absMeta.getAttributeString("antenna_pointing").equals("right");
            this.addCalibrationLUT(product);
            product.getGcpGroup();
            product.setFileLocation(fileFromInput);
            product.setProductReader((ProductReader)this);
            Radarsat2ProductReader.setQuicklookBandName(product);
            this.addQuicklook(product, "Quicklook", this.getQuicklookFile());
            Radarsat2ProductReader.addPauliQuicklooks(product);
            return product;
        }
        catch (Exception e) {
            this.handleReaderException(e);
            return null;
        }
    }

    protected Radarsat2ProductDirectory createDirectory(File fileFromInput) {
        return new Radarsat2ProductDirectory(fileFromInput);
    }

    private File getQuicklookFile() {
        try {
            if (this.dataDir.exists(this.dataDir.getRootFolder() + "BrowseImage.tif")) {
                return this.dataDir.getFile(this.dataDir.getRootFolder() + "BrowseImage.tif");
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to load quicklook " + this.dataDir.getProductName());
        }
        return null;
    }

    private static void addPauliQuicklooks(Product product) {
        InputProductValidator validator = new InputProductValidator(product);
        if (validator.isFullPolSLC()) {
            Band[] pauliBands = Radarsat2ProductReader.pauliVirtualBands(product);
            product.getQuicklookGroup().add((ProductNode)new Quicklook(product, "Pauli", pauliBands));
        }
    }

    public static Band[] pauliVirtualBands(Product product) {
        VirtualBand r = new VirtualBand("pauli_r", 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), "((i_HH-i_VV)*(i_HH-i_VV)+(q_HH-q_VV)*(q_HH-q_VV))/2");
        VirtualBand g = new VirtualBand("pauli_g", 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), "((i_HV+i_VH)*(i_HV+i_VH)+(q_HV+q_VH)*(q_HV+q_VH))/2");
        VirtualBand b = new VirtualBand("pauli_b", 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), "((i_HH+i_VV)*(i_HH+i_VV)+(q_HH+q_VV)*(q_HH+q_VV))/2");
        return new Band[]{r, g, b};
    }

    private void addCalibrationLUT(Product product) throws IOException {
        boolean flipLUT = flipToSARGeometry && (this.isAscending && !this.isAntennaPointingRight || !this.isAscending && this.isAntennaPointingRight);
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        this.readCalibrationLUT(lutsigma, origProdRoot, flipLUT);
        this.readCalibrationLUT(lutgamma, origProdRoot, flipLUT);
        this.readCalibrationLUT(lutbeta, origProdRoot, flipLUT);
    }

    private void readCalibrationLUT(String lutName, MetadataElement root, boolean flipLUT) throws IOException {
        InputStream is;
        if (this.dataDir.exists(this.dataDir.getRootFolder() + lutName + ".xml")) {
            is = this.dataDir.getInputStream(this.dataDir.getRootFolder() + lutsigma + ".xml");
        } else if (this.dataDir.exists(this.dataDir.getRootFolder() + lutName.toLowerCase() + ".xml")) {
            is = this.dataDir.getInputStream(this.dataDir.getRootFolder() + lutsigma.toLowerCase() + ".xml");
        } else {
            return;
        }
        Document xmlDoc = XMLSupport.LoadXML((InputStream)is);
        Element rootElement = xmlDoc.getRootElement();
        Element offsetElem = rootElement.getChild("offset");
        double offset = Double.parseDouble(offsetElem.getValue());
        Element gainsElem = rootElement.getChild("gains");
        String gainsValue = gainsElem.getValue().trim().replace("  ", " ");
        double[] gainsArray = Radarsat2ProductReader.toDoubleArray(gainsValue, " ");
        if (flipLUT) {
            for (int i = 0; i < gainsArray.length / 2; ++i) {
                double tmp = gainsArray[i];
                gainsArray[i] = gainsArray[gainsArray.length - i - 1];
                gainsArray[gainsArray.length - i - 1] = tmp;
            }
        }
        MetadataElement lut = new MetadataElement(lutName);
        root.addElement(lut);
        MetadataAttribute offsetAttrib = new MetadataAttribute("offset", 31);
        offsetAttrib.getData().setElemDouble(offset);
        lut.addAttribute(offsetAttrib);
        MetadataAttribute gainsAttrib = new MetadataAttribute("gains", 31, gainsArray.length);
        gainsAttrib.getData().setElems((Object)gainsArray);
        lut.addAttribute(gainsAttrib);
    }

    public static double[] toDoubleArray(String text, String delim) {
        StringTokenizer st = new StringTokenizer(text, delim);
        double[] numbers = new double[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            try {
                numbers[i++] = Double.parseDouble(st.nextToken());
            }
            catch (Exception e) {
                break;
            }
        }
        return numbers;
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        ImageIOFile.BandInfo bandInfo = this.dataDir.getBandInfo(destBand);
        if (bandInfo != null && bandInfo.img != null) {
            if (this.isAscending) {
                this.readAscendingRasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, 0, bandInfo.img, bandInfo.bandSampleOffset, this.isAntennaPointingRight);
            } else {
                this.readDescendingRasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, 0, bandInfo.img, bandInfo.bandSampleOffset, this.isAntennaPointingRight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAscendingRasterBand(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, ProductData destBuffer, int destOffsetX, int destOffsetY, int destWidth, int destHeight, int imageID, ImageIOFile img, int bandSampleOffset, boolean isAntennaPointingRight) throws IOException {
        Raster data;
        Radarsat2ProductDirectory radarsat2ProductDirectory = this.dataDir;
        synchronized (radarsat2ProductDirectory) {
            ImageReader reader = img.getReader();
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceSubsampling(sourceStepX, sourceStepY, sourceOffsetX % sourceStepX, sourceOffsetY % sourceStepY);
            RenderedImage image = reader.readAsRenderedImage(0, param);
            data = flipToSARGeometry ? (isAntennaPointingRight ? image.getData(new Rectangle(destOffsetX, Math.max(0, img.getSceneHeight() - destOffsetY - destHeight), destWidth, destHeight)) : image.getData(new Rectangle(Math.max(0, img.getSceneWidth() - destOffsetX - destWidth), Math.max(0, img.getSceneHeight() - destOffsetY - destHeight), destWidth, destHeight))) : image.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
        }
        int w = data.getWidth();
        int h = data.getHeight();
        DataBuffer dataBuffer = data.getDataBuffer();
        SampleModel sampleModel = data.getSampleModel();
        int sampleOffset = imageID + bandSampleOffset;
        if (flipToSARGeometry) {
            int[] dArray = new int[dataBuffer.getSize()];
            sampleModel.getSamples(0, 0, w, h, imageID + bandSampleOffset, dArray, dataBuffer);
            if (isAntennaPointingRight) {
                for (int r = 0; r < h; ++r) {
                    int srcStride = r * w;
                    int destStride = (h - r - 1) * w;
                    for (int c = 0; c < w; ++c) {
                        destBuffer.setElemIntAt(destStride + c, dArray[srcStride + c]);
                    }
                }
            } else {
                for (int r = 0; r < h; ++r) {
                    int srcStride = r * w;
                    int destStride = (h - r) * w;
                    for (int c = 0; c < w; ++c) {
                        destBuffer.setElemIntAt(destStride - c - 1, dArray[srcStride + c]);
                    }
                }
            }
        } else {
            sampleModel.getSamples(0, 0, w, h, sampleOffset, (int[])destBuffer.getElems(), dataBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDescendingRasterBand(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, ProductData destBuffer, int destOffsetX, int destOffsetY, int destWidth, int destHeight, int imageID, ImageIOFile img, int bandSampleOffset, boolean isAntennaPointingRight) throws IOException {
        try {
            Raster data;
            Radarsat2ProductDirectory radarsat2ProductDirectory = this.dataDir;
            synchronized (radarsat2ProductDirectory) {
                ImageReader reader = img.getReader();
                ImageReadParam param = reader.getDefaultReadParam();
                param.setSourceSubsampling(sourceStepX, sourceStepY, sourceOffsetX % sourceStepX, sourceOffsetY % sourceStepY);
                RenderedImage image = reader.readAsRenderedImage(0, param);
                data = flipToSARGeometry && isAntennaPointingRight ? image.getData(new Rectangle(Math.max(0, img.getSceneWidth() - destOffsetX - destWidth), destOffsetY, destWidth, destHeight)) : image.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
            }
            int w = data.getWidth();
            int h = data.getHeight();
            DataBuffer dataBuffer = data.getDataBuffer();
            SampleModel sampleModel = data.getSampleModel();
            int sampleOffset = imageID + bandSampleOffset;
            if (destBuffer.getType() == 30) {
                if (flipToSARGeometry && isAntennaPointingRight) {
                    float[] dArray = new float[dataBuffer.getSize()];
                    sampleModel.getSamples(0, 0, w, h, sampleOffset, dArray, dataBuffer);
                    for (int r = 0; r < h; ++r) {
                        int srcStride = r * w;
                        int destStride = r * w + w;
                        for (int c = 0; c < w; ++c) {
                            destBuffer.setElemFloatAt(destStride - c - 1, dArray[srcStride + c]);
                        }
                    }
                } else {
                    sampleModel.getSamples(0, 0, w, h, sampleOffset, (float[])destBuffer.getElems(), dataBuffer);
                }
            } else if (flipToSARGeometry && isAntennaPointingRight) {
                int[] dArray = new int[dataBuffer.getSize()];
                sampleModel.getSamples(0, 0, w, h, sampleOffset, dArray, dataBuffer);
                for (int r = 0; r < h; ++r) {
                    int srcStride = r * w;
                    int destStride = r * w + w;
                    for (int c = 0; c < w; ++c) {
                        destBuffer.setElemIntAt(destStride - c - 1, dArray[srcStride + c]);
                    }
                }
            } else {
                sampleModel.getSamples(0, 0, w, h, sampleOffset, (int[])destBuffer.getElems(), dataBuffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

