/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.radarsat2;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.XMLProductDirectory;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class Radarsat2ProductDirectory
extends XMLProductDirectory {
    private String productName = "Radarsat2";
    private String productType = "Radarsat2";
    private final String productDescription = "";
    private boolean compactPolMode = false;
    private static final DateFormat standardDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private static final boolean flipToSARGeometry = System.getProperty(SystemUtils.getApplicationContextId() + ".flip.to.sar.geometry", "false").equals("true");
    private final transient Map<String, String> polarizationMap = new HashMap<String, String>(4);

    public Radarsat2ProductDirectory(File headerFile) {
        super(headerFile);
    }

    @Override
    protected String getHeaderFileName() {
        return "product.xml";
    }

    @Override
    protected void addImageFile(String imgPath, MetadataElement newRoot) throws IOException {
        String name = Radarsat2ProductDirectory.getBandFileNameFromImage(imgPath);
        if (name.endsWith("tif") || name.endsWith("tiff")) {
            boolean valid = false;
            int dataType = 12;
            if (name.startsWith("image")) {
                valid = true;
            } else if (name.startsWith("rh") || name.startsWith("rv")) {
                valid = true;
                dataType = 30;
            }
            if (valid) {
                Dimension bandDimensions = Radarsat2ProductDirectory.getBandDimensions(newRoot, name);
                InputStream inStream = this.getInputStream(imgPath);
                ImageInputStream imgStream = ImageIOFile.createImageInputStream(inStream, bandDimensions);
                if (imgStream == null) {
                    throw new IOException("Unable to open " + imgPath);
                }
                ImageIOFile img = this.isSLC() ? new ImageIOFile(name, imgStream, ImageIOFile.getTiffIIOReader(imgStream), 1, 2, dataType, this.productInputFile) : new ImageIOFile(name, imgStream, ImageIOFile.getTiffIIOReader(imgStream), this.productInputFile);
                this.bandImageFileMap.put(img.getName(), img);
            }
        }
    }

    private String getPol(String imgName) {
        String pol = this.polarizationMap.get(imgName);
        if (pol == null) {
            if (imgName.contains("rh")) {
                this.compactPolMode = true;
                return "RH";
            }
            if (imgName.contains("rv")) {
                this.compactPolMode = true;
                return "RV";
            }
        }
        return pol;
    }

    @Override
    protected void addBands(Product product) {
        boolean real = true;
        Band lastRealBand = null;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        int width = absRoot.getAttributeInt("num_samples_per_line");
        int height = absRoot.getAttributeInt("num_output_lines");
        Set keys = this.bandImageFileMap.keySet();
        for (String key : keys) {
            ImageIOFile img = (ImageIOFile)this.bandImageFileMap.get(key);
            for (int i = 0; i < img.getNumImages(); ++i) {
                Band band;
                String bandName;
                String imgName;
                int b;
                if (this.isSLC()) {
                    for (b = 0; b < img.getNumBands(); ++b) {
                        String unit;
                        imgName = img.getName().toLowerCase();
                        if (real) {
                            bandName = "i_" + this.getPol(imgName);
                            unit = "real";
                        } else {
                            bandName = "q_" + this.getPol(imgName);
                            unit = "imaginary";
                        }
                        band = new Band(bandName, img.getDataType(), width, height);
                        band.setUnit(unit);
                        product.addBand(band);
                        this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                        if (real) {
                            lastRealBand = band;
                        } else {
                            ReaderUtils.createVirtualIntensityBand((Product)product, (Band)lastRealBand, (Band)band, (String)('_' + this.getPol(imgName)));
                        }
                        real = !real;
                    }
                    continue;
                }
                for (b = 0; b < img.getNumBands(); ++b) {
                    imgName = img.getName().toLowerCase();
                    bandName = "Amplitude_" + this.getPol(imgName);
                    band = new Band(bandName, 22, width, height);
                    band.setUnit("amplitude");
                    product.addBand(band);
                    this.bandMap.put(band, new ImageIOFile.BandInfo(band, img, i, b));
                    SARReader.createVirtualIntensityBand(product, band, '_' + this.getPol(imgName));
                }
            }
        }
        if (this.compactPolMode) {
            absRoot.setAttributeInt("polsar_data", 1);
            absRoot.setAttributeString("compact_mode", "Right Circular Hybrid Mode");
        }
    }

    @Override
    protected void addAbstractedMetadataHeader(MetadataElement root) throws IOException {
        MetadataElement geodeticTerrainHeight;
        MetadataElement referenceEllipsoidParameters;
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        MetadataElement origProdRoot = AbstractMetadata.addOriginalProductMetadata((MetadataElement)root);
        String defStr = "-";
        int defInt = 99999;
        MetadataElement productElem = origProdRoot.getElement("product");
        MetadataElement sourceAttributes = productElem.getElement("sourceAttributes");
        MetadataElement radarParameters = sourceAttributes.getElement("radarParameters");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)radarParameters.getAttributeString("acquisitionType", "-"));
        String aquisitionMode = radarParameters.getAttributeString("acquisitionType", "-");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ACQUISITION_MODE", (String)aquisitionMode);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"antenna_pointing", (String)radarParameters.getAttributeString("antennaPointing", "-").toLowerCase());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"BEAMS", (String)radarParameters.getAttributeString("beams", "-"));
        MetadataElement radarCenterFrequency = radarParameters.getElement("radarCenterFrequency");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)(radarCenterFrequency.getAttributeDouble("radarCenterFrequency", 99999.0) / 1000000.0));
        MetadataElement orbitAndAttitude = sourceAttributes.getElement("orbitAndAttitude");
        MetadataElement orbitInformation = orbitAndAttitude.getElement("orbitInformation");
        String pass = orbitInformation.getAttributeString("passDirection", "-").toUpperCase();
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)pass);
        String orbitFile = orbitInformation.getAttributeString("orbitDataFile", "-");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"orbit_state_vector_file", (String)orbitFile);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)Integer.parseInt(orbitFile.substring(0, orbitFile.indexOf(95)).trim()));
        MetadataElement imageGenerationParameters = productElem.getElement("imageGenerationParameters");
        MetadataElement generalProcessingInformation = imageGenerationParameters.getElement("generalProcessingInformation");
        MetadataElement sarProcessingInformation = imageGenerationParameters.getElement("sarProcessingInformation");
        this.productType = generalProcessingInformation.getAttributeString("productType", "-");
        if (this.productType.contains("SLC")) {
            this.setSLC(true);
        }
        String productId = productElem.getAttributeString("productId", "-");
        String beamMode = sourceAttributes.getAttributeString("beamModeMnemonic", "-");
        String passStr = "DES";
        if (pass.equals("ASCENDING")) {
            passStr = "ASC";
        }
        ProductData.UTC startTime = null;
        ProductData.UTC stopTime = null;
        if (flipToSARGeometry && pass.equals("ASCENDING")) {
            stopTime = ReaderUtils.getTime((MetadataElement)sarProcessingInformation, (String)"zeroDopplerTimeFirstLine", (DateFormat)standardDateFormat);
            startTime = ReaderUtils.getTime((MetadataElement)sarProcessingInformation, (String)"zeroDopplerTimeLastLine", (DateFormat)standardDateFormat);
        } else {
            startTime = ReaderUtils.getTime((MetadataElement)sarProcessingInformation, (String)"zeroDopplerTimeFirstLine", (DateFormat)standardDateFormat);
            stopTime = ReaderUtils.getTime((MetadataElement)sarProcessingInformation, (String)"zeroDopplerTimeLastLine", (DateFormat)standardDateFormat);
        }
        DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"dd-MMM-yyyy_HH.mm");
        Date date = startTime.getAsDate();
        String dateString = dateFormat.format(date);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)this.productType);
        this.productName = Radarsat2ProductDirectory.getMission() + '-' + this.productType + '-' + beamMode + '-' + passStr + '-' + dateString + '-' + productId;
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)this.productName);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)Radarsat2ProductDirectory.getMission());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)(generalProcessingInformation.getAttributeString("processingFacility", "-") + '-' + generalProcessingInformation.getAttributeString("softwareVersion", "-")));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PROC_TIME", (ProductData.UTC)ReaderUtils.getTime((MetadataElement)generalProcessingInformation, (String)"processingTime", (DateFormat)standardDateFormat));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ant_elev_corr_flag", (int)Radarsat2ProductDirectory.getFlag(sarProcessingInformation, "elevationPatternCorrection"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spread_comp_flag", (int)Radarsat2ProductDirectory.getFlag(sarProcessingInformation, "rangeSpreadingLossCorrection"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)(this.isSLC() ? 0 : 1));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)startTime);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)stopTime);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (int)sarProcessingInformation.getAttributeInt("numberOfRangeLooks", 99999));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (int)sarProcessingInformation.getAttributeInt("numberOfAzimuthLooks", 99999));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"slant_range_to_first_pixel", (double)sarProcessingInformation.getElement("slantRangeNearEdge").getAttributeDouble("slantRangeNearEdge"));
        MetadataElement totalProcessedRangeBandwidth = sarProcessingInformation.getElement("totalProcessedRangeBandwidth");
        MetadataElement totalProcessedAzimuthBandwidth = sarProcessingInformation.getElement("totalProcessedAzimuthBandwidth");
        double rangeBW = totalProcessedRangeBandwidth.getAttributeDouble("totalProcessedRangeBandwidth");
        double azimuthBW = totalProcessedAzimuthBandwidth.getAttributeDouble("totalProcessedAzimuthBandwidth");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_bandwidth", (double)(rangeBW / 1000000.0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_bandwidth", (double)azimuthBW);
        MetadataElement imageAttributes = productElem.getElement("imageAttributes");
        MetadataElement rasterAttributes = imageAttributes.getElement("rasterAttributes");
        this.verifyProductFormat(imageAttributes);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)Radarsat2ProductDirectory.getDataType(rasterAttributes));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)rasterAttributes.getAttributeInt("numberOfLines", 99999));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)rasterAttributes.getAttributeInt("numberOfSamplesPerLine", 99999));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)ReaderUtils.getLineTimeInterval((ProductData.UTC)startTime, (ProductData.UTC)stopTime, (int)absRoot.getAttributeInt("num_output_lines")));
        MetadataElement sampledPixelSpacing = rasterAttributes.getElement("sampledPixelSpacing");
        double rangeSpacing = sampledPixelSpacing.getAttributeDouble("sampledPixelSpacing", 99999.0);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (double)rangeSpacing);
        MetadataElement sampledLineSpacing = rasterAttributes.getElement("sampledLineSpacing");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (double)sampledLineSpacing.getAttributeDouble("sampledLineSpacing", 99999.0));
        MetadataElement pulseRepetitionFrequency = radarParameters.getElement("pulseRepetitionFrequency");
        double prf = pulseRepetitionFrequency.getAttributeDouble("pulseRepetitionFrequency", 99999.0);
        MetadataElement adcSamplingRate = radarParameters.getElement("adcSamplingRate");
        double rangeSamplingRate = adcSamplingRate.getAttributeDouble("adcSamplingRate", 99999.0) / 1000000.0;
        if (aquisitionMode.equalsIgnoreCase("UltraFine")) {
            prf *= 2.0;
            rangeSamplingRate *= 2.0;
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (double)prf);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_sampling_rate", (double)rangeSamplingRate);
        MetadataElement geographicInformation = imageAttributes.getElement("geographicInformation");
        if (geographicInformation != null && (referenceEllipsoidParameters = geographicInformation.getElement("referenceEllipsoidParameters")) != null && (geodeticTerrainHeight = referenceEllipsoidParameters.getElement("geodeticTerrainHeight")) != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"avg_scene_height", (double)geodeticTerrainHeight.getAttributeDouble("geodeticTerrainHeight", 99999.0));
        }
        this.getPolarizations(absRoot, imageAttributes);
        Radarsat2ProductDirectory.addOrbitStateVectors(absRoot, orbitInformation);
        Radarsat2ProductDirectory.addSRGRCoefficients(absRoot, imageGenerationParameters);
        Radarsat2ProductDirectory.addDopplerCentroidCoefficients(absRoot, imageGenerationParameters);
    }

    protected void verifyProductFormat(MetadataElement imageAttributes) throws IOException {
        String imageProductFormat = imageAttributes.getAttributeString("productFormat");
        if (!imageProductFormat.equalsIgnoreCase("GeoTIFF")) {
            throw new IOException("Radarsat2 " + imageProductFormat + " format is not supported by this reader\n Contact nest_pr@array.ca");
        }
    }

    private static int getFlag(MetadataElement elem, String tag) {
        String valStr = elem.getAttributeString(tag, " ").toUpperCase();
        if (valStr.equals("FALSE") || valStr.equals("0")) {
            return 0;
        }
        if (valStr.equals("TRUE") || valStr.equals("1")) {
            return 1;
        }
        return -1;
    }

    private void getPolarizations(MetadataElement absRoot, MetadataElement imageAttributes) {
        MetadataElement[] imageAttribElems = imageAttributes.getElements();
        int i = 0;
        for (MetadataElement elem : imageAttribElems) {
            if (!elem.getName().equals("fullResolutionImageData")) continue;
            String pol = elem.getAttributeString("pole", "").toUpperCase();
            this.polarizationMap.put(elem.getAttributeString("fullResolutionImageData", "").toLowerCase(), pol);
            absRoot.setAttributeString(AbstractMetadata.polarTags[i], pol);
            ++i;
        }
    }

    private static String getDataType(MetadataElement rasterAttributes) {
        String dataType = rasterAttributes.getAttributeString("dataType", "-").toUpperCase();
        if (dataType.contains("COMPLEX")) {
            return "COMPLEX";
        }
        return "DETECTED";
    }

    private static void addOrbitStateVectors(MetadataElement absRoot, MetadataElement orbitInformation) {
        MetadataElement orbitVectorListElem = absRoot.getElement("Orbit_State_Vectors");
        MetadataElement[] stateVectorElems = orbitInformation.getElements();
        for (int i = 1; i <= stateVectorElems.length; ++i) {
            Radarsat2ProductDirectory.addVector("orbit_vector", orbitVectorListElem, stateVectorElems[i - 1], i);
        }
        if (absRoot.getAttributeUTC("STATE_VECTOR_TIME", AbstractMetadata.NO_METADATA_UTC).equalElems((ProductData)AbstractMetadata.NO_METADATA_UTC)) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)ReaderUtils.getTime((MetadataElement)stateVectorElems[0], (String)"timeStamp", (DateFormat)standardDateFormat));
        }
    }

    private static void addVector(String name, MetadataElement orbitVectorListElem, MetadataElement srcElem, int num) {
        MetadataElement orbitVectorElem = new MetadataElement(name + num);
        orbitVectorElem.setAttributeUTC("time", ReaderUtils.getTime((MetadataElement)srcElem, (String)"timeStamp", (DateFormat)standardDateFormat));
        MetadataElement xpos = srcElem.getElement("xPosition");
        orbitVectorElem.setAttributeDouble("x_pos", xpos.getAttributeDouble("xPosition", 0.0));
        MetadataElement ypos = srcElem.getElement("yPosition");
        orbitVectorElem.setAttributeDouble("y_pos", ypos.getAttributeDouble("yPosition", 0.0));
        MetadataElement zpos = srcElem.getElement("zPosition");
        orbitVectorElem.setAttributeDouble("z_pos", zpos.getAttributeDouble("zPosition", 0.0));
        MetadataElement xvel = srcElem.getElement("xVelocity");
        orbitVectorElem.setAttributeDouble("x_vel", xvel.getAttributeDouble("xVelocity", 0.0));
        MetadataElement yvel = srcElem.getElement("yVelocity");
        orbitVectorElem.setAttributeDouble("y_vel", yvel.getAttributeDouble("yVelocity", 0.0));
        MetadataElement zvel = srcElem.getElement("zVelocity");
        orbitVectorElem.setAttributeDouble("z_vel", zvel.getAttributeDouble("zVelocity", 0.0));
        orbitVectorListElem.addElement(orbitVectorElem);
    }

    private static void addSRGRCoefficients(MetadataElement absRoot, MetadataElement imageGenerationParameters) {
        MetadataElement srgrCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
        int listCnt = 1;
        for (MetadataElement elem : imageGenerationParameters.getElements()) {
            if (!elem.getName().equalsIgnoreCase("slantRangeToGroundRange")) continue;
            MetadataElement srgrListElem = new MetadataElement("srgr_coef_list." + listCnt);
            srgrCoefficientsElem.addElement(srgrListElem);
            ++listCnt;
            ProductData.UTC utcTime = ReaderUtils.getTime((MetadataElement)elem, (String)"zeroDopplerAzimuthTime", (DateFormat)standardDateFormat);
            srgrListElem.setAttributeUTC("zero_doppler_time", utcTime);
            double grOrigin = elem.getElement("groundRangeOrigin").getAttributeDouble("groundRangeOrigin", 0.0);
            AbstractMetadata.addAbstractedAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (int)31, (String)"m", (String)"Ground Range Origin");
            AbstractMetadata.setAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (double)grOrigin);
            String coeffStr = elem.getAttributeString("groundToSlantRangeCoefficients", "");
            if (coeffStr.isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(coeffStr);
            int cnt = 1;
            while (st.hasMoreTokens()) {
                double coefValue = Double.parseDouble(st.nextToken());
                MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
                srgrListElem.addElement(coefElem);
                ++cnt;
                AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"srgr_coef", (int)31, (String)"", (String)"SRGR Coefficient");
                AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)coefValue);
            }
        }
    }

    private static void addDopplerCentroidCoefficients(MetadataElement absRoot, MetadataElement imageGenerationParameters) {
        MetadataElement dopplerCentroidCoefficientsElem = absRoot.getElement("Doppler_Centroid_Coefficients");
        int listCnt = 1;
        for (MetadataElement elem : imageGenerationParameters.getElements()) {
            if (!elem.getName().equalsIgnoreCase("dopplerCentroid")) continue;
            MetadataElement dopplerListElem = new MetadataElement("dop_coef_list." + listCnt);
            dopplerCentroidCoefficientsElem.addElement(dopplerListElem);
            ++listCnt;
            ProductData.UTC utcTime = ReaderUtils.getTime((MetadataElement)elem, (String)"timeOfDopplerCentroidEstimate", (DateFormat)standardDateFormat);
            dopplerListElem.setAttributeUTC("zero_doppler_time", utcTime);
            double refTime = elem.getElement("dopplerCentroidReferenceTime").getAttributeDouble("dopplerCentroidReferenceTime", 0.0) * 1.0E9;
            AbstractMetadata.addAbstractedAttribute((MetadataElement)dopplerListElem, (String)"slant_range_time", (int)31, (String)"ns", (String)"Slant Range Time");
            AbstractMetadata.setAttribute((MetadataElement)dopplerListElem, (String)"slant_range_time", (double)refTime);
            String coeffStr = elem.getAttributeString("dopplerCentroidCoefficients", "");
            if (coeffStr.isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(coeffStr);
            int cnt = 1;
            while (st.hasMoreTokens()) {
                double coefValue = Double.parseDouble(st.nextToken());
                MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
                dopplerListElem.addElement(coefElem);
                ++cnt;
                AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"dop_coef", (int)31, (String)"", (String)"Doppler Centroid Coefficient");
                AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"dop_coef", (double)coefValue);
            }
        }
    }

    @Override
    protected void addGeoCoding(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        boolean isAscending = absRoot.getAttributeString("PASS").equals("ASCENDING");
        boolean isAntennaPointingRight = absRoot.getAttributeString("antenna_pointing").equals("right");
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement productElem = origProdRoot.getElement("product");
        MetadataElement imageAttributes = productElem.getElement("imageAttributes");
        MetadataElement geographicInformation = imageAttributes.getElement("geographicInformation");
        MetadataElement geolocationGrid = geographicInformation.getElement("geolocationGrid");
        MetadataElement[] geoGrid = geolocationGrid.getElements();
        float[] latList = new float[geoGrid.length];
        float[] lngList = new float[geoGrid.length];
        int gridWidth = 0;
        int gridHeight = 0;
        int i = 0;
        for (MetadataElement imageTiePoint : geoGrid) {
            MetadataElement geodeticCoordinate = imageTiePoint.getElement("geodeticCoordinate");
            MetadataElement latitude = geodeticCoordinate.getElement("latitude");
            MetadataElement longitude = geodeticCoordinate.getElement("longitude");
            latList[i] = (float)latitude.getAttributeDouble("latitude", 0.0);
            lngList[i] = (float)longitude.getAttributeDouble("longitude", 0.0);
            MetadataElement imageCoordinate = imageTiePoint.getElement("imageCoordinate");
            double pix = imageCoordinate.getAttributeDouble("pixel", 0.0);
            if (pix == 0.0) {
                if (gridWidth == 0) {
                    gridWidth = i;
                }
                ++gridHeight;
            }
            ++i;
        }
        if (flipToSARGeometry) {
            int is;
            float[] flippedLatList = new float[geoGrid.length];
            float[] flippedLonList = new float[geoGrid.length];
            if (isAscending) {
                if (isAntennaPointingRight) {
                    for (int r = 0; r < gridHeight; ++r) {
                        is = r * gridWidth;
                        int id = (gridHeight - r - 1) * gridWidth;
                        for (int c = 0; c < gridWidth; ++c) {
                            flippedLatList[id + c] = latList[is + c];
                            flippedLonList[id + c] = lngList[is + c];
                        }
                    }
                } else {
                    for (int r = 0; r < gridHeight; ++r) {
                        is = r * gridWidth;
                        int id = (gridHeight - r) * gridWidth;
                        for (int c = 0; c < gridWidth; ++c) {
                            flippedLatList[id - c - 1] = latList[is + c];
                            flippedLonList[id - c - 1] = lngList[is + c];
                        }
                    }
                }
            } else if (isAntennaPointingRight) {
                for (int r = 0; r < gridHeight; ++r) {
                    is = r * gridWidth;
                    int id = r * gridWidth + gridWidth;
                    for (int c = 0; c < gridWidth; ++c) {
                        flippedLatList[id - c - 1] = latList[is + c];
                        flippedLonList[id - c - 1] = lngList[is + c];
                    }
                }
            } else {
                flippedLatList = latList;
                flippedLonList = lngList;
            }
            latList = flippedLatList;
            lngList = flippedLonList;
        }
        double subSamplingX = (double)(product.getSceneRasterWidth() - 1) / (double)(gridWidth - 1);
        double subSamplingY = (double)(product.getSceneRasterHeight() - 1) / (double)(gridHeight - 1);
        TiePointGrid latGrid = new TiePointGrid("latitude", gridWidth, gridHeight, 0.5, 0.5, subSamplingX, subSamplingY, latList);
        latGrid.setUnit("deg");
        TiePointGrid lonGrid = new TiePointGrid("longitude", gridWidth, gridHeight, 0.5, 0.5, subSamplingX, subSamplingY, lngList, TiePointGrid.DISCONT_AT_180);
        lonGrid.setUnit("deg");
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
        Radarsat2ProductDirectory.setLatLongMetadata(product, latGrid, lonGrid);
    }

    private static void setLatLongMetadata(Product product, TiePointGrid latGrid, TiePointGrid lonGrid) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (double)latGrid.getPixelDouble(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (double)lonGrid.getPixelDouble(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (double)latGrid.getPixelDouble(w - 1, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (double)lonGrid.getPixelDouble(w - 1, 0));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (double)latGrid.getPixelDouble(0, h - 1));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (double)lonGrid.getPixelDouble(0, h - 1));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (double)latGrid.getPixelDouble(w - 1, h - 1));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (double)lonGrid.getPixelDouble(w - 1, h - 1));
    }

    @Override
    protected void addTiePointGrids(Product product) {
        double psi1;
        int sourceImageWidth = product.getSceneRasterWidth();
        int sourceImageHeight = product.getSceneRasterHeight();
        int gridWidth = 11;
        int gridHeight = 11;
        int subSamplingX = (int)((float)sourceImageWidth / 10.0f);
        int subSamplingY = (int)((float)sourceImageHeight / 10.0f);
        double a = 6378137.0;
        double b = 6356752.314245179;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        double slantRangeToFirstPixel = absRoot.getAttributeDouble("slant_range_to_first_pixel", 0.0);
        double rangeSpacing = absRoot.getAttributeDouble("range_spacing", 0.0);
        boolean srgrFlag = absRoot.getAttributeInt("srgr_flag") != 0;
        boolean isDescending = absRoot.getAttributeString("PASS").equals("DESCENDING");
        boolean isAntennaPointingRight = absRoot.getAttributeString("antenna_pointing").equals("right");
        GeoPos sceneCenterPos = product.getSceneGeoCoding().getGeoPos(new PixelPos((double)((float)sourceImageWidth / 2.0f), (double)((float)sourceImageHeight / 2.0f)), null);
        double sceneCenterLatitude = sceneCenterPos.lat;
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement productElem = origProdRoot.getElement("product");
        MetadataElement imageGenerationParameters = productElem.getElement("imageGenerationParameters");
        MetadataElement sarProcessingInformation = imageGenerationParameters.getElement("sarProcessingInformation");
        MetadataElement incidenceAngleNearRangeElem = sarProcessingInformation.getElement("incidenceAngleNearRange");
        double nearRangeIncidenceAngle = (float)incidenceAngleNearRangeElem.getAttributeDouble("incidenceAngleNearRange", 0.0);
        double alpha1 = nearRangeIncidenceAngle * (Math.PI / 180);
        double lambda = sceneCenterLatitude * (Math.PI / 180);
        double cos2 = FastMath.cos((double)lambda) * FastMath.cos((double)lambda);
        double sin2 = FastMath.sin((double)lambda) * FastMath.sin((double)lambda);
        double e2 = b * b / (a * a);
        double rt = a * Math.sqrt((cos2 + e2 * e2 * sin2) / (cos2 + e2 * sin2));
        double rt2 = rt * rt;
        double groundRangeSpacing = srgrFlag ? rangeSpacing : rangeSpacing / FastMath.sin((double)alpha1);
        double deltaPsi = groundRangeSpacing / rt;
        double r1 = slantRangeToFirstPixel;
        double rtPlusH = Math.sqrt(rt2 + r1 * r1 + 2.0 * rt * r1 * FastMath.cos((double)alpha1));
        double rtPlusH2 = rtPlusH * rtPlusH;
        double theta1 = FastMath.acos((double)((r1 + rt * FastMath.cos((double)alpha1)) / rtPlusH));
        double psi = psi1 = alpha1 - theta1;
        float[] incidenceAngles = new float[11];
        int n = 11 * subSamplingX;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            double ri = Math.sqrt(rt2 + rtPlusH2 - 2.0 * rt * rtPlusH * FastMath.cos((double)psi));
            double alpha = FastMath.acos((double)((rtPlusH2 - ri * ri - rt2) / (2.0 * ri * rt)));
            if (i % subSamplingX == 0) {
                int index = k++;
                if (!flipToSARGeometry && (isDescending && isAntennaPointingRight || !isDescending && !isAntennaPointingRight)) {
                    index = 10 - index;
                }
                incidenceAngles[index] = (float)(alpha * 57.29577951308232);
            }
            if (!srgrFlag) {
                groundRangeSpacing = rangeSpacing / FastMath.sin((double)alpha);
                deltaPsi = groundRangeSpacing / rt;
            }
            psi += deltaPsi;
        }
        float[] incidenceAngleList = new float[121];
        for (int j = 0; j < 11; ++j) {
            System.arraycopy(incidenceAngles, 0, incidenceAngleList, j * 11, 11);
        }
        TiePointGrid incidentAngleGrid = new TiePointGrid("incident_angle", 11, 11, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, incidenceAngleList);
        incidentAngleGrid.setUnit("deg");
        product.addTiePointGrid(incidentAngleGrid);
        Radarsat2ProductDirectory.addSlantRangeTime(product, imageGenerationParameters);
    }

    private static void addSlantRangeTime(Product product, MetadataElement imageGenerationParameters) {
        class CoefList {
            double utcSeconds = 0.0;
            double grOrigin = 0.0;
            final List<Double> coefficients = new ArrayList<Double>();

            CoefList() {
            }
        }
        ArrayList<CoefList> segmentsArray = new ArrayList<CoefList>();
        for (MetadataElement elem : imageGenerationParameters.getElements()) {
            if (!elem.getName().equalsIgnoreCase("slantRangeToGroundRange")) continue;
            CoefList coef = new CoefList();
            segmentsArray.add(coef);
            coef.utcSeconds = ReaderUtils.getTime((MetadataElement)elem, (String)"zeroDopplerAzimuthTime", (DateFormat)standardDateFormat).getMJD() * 24.0 * 3600.0;
            coef.grOrigin = elem.getElement("groundRangeOrigin").getAttributeDouble("groundRangeOrigin", 0.0);
            String coeffStr = elem.getAttributeString("groundToSlantRangeCoefficients", "");
            if (coeffStr.isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(coeffStr);
            while (st.hasMoreTokens()) {
                coef.coefficients.add(Double.parseDouble(st.nextToken()));
            }
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        double lineTimeInterval = absRoot.getAttributeDouble("line_time_interval", 0.0);
        ProductData.UTC startTime = absRoot.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
        double startSeconds = startTime.getMJD() * 24.0 * 3600.0;
        double pixelSpacing = absRoot.getAttributeDouble("range_spacing", 0.0);
        boolean isDescending = absRoot.getAttributeString("PASS").equals("DESCENDING");
        boolean isAntennaPointingRight = absRoot.getAttributeString("antenna_pointing").equals("right");
        int gridWidth = 11;
        int gridHeight = 11;
        int sceneWidth = product.getSceneRasterWidth();
        int sceneHeight = product.getSceneRasterHeight();
        int subSamplingX = sceneWidth / 10;
        int subSamplingY = sceneHeight / 10;
        float[] rangeDist = new float[121];
        float[] rangeTime = new float[121];
        CoefList[] segments = segmentsArray.toArray(new CoefList[segmentsArray.size()]);
        int k = 0;
        int c = 0;
        for (int j = 0; j < 11; ++j) {
            double time = startSeconds + (double)j * lineTimeInterval;
            while (c < segments.length && segments[c].utcSeconds < time) {
                ++c;
            }
            if (c >= segments.length) {
                c = segments.length - 1;
            }
            CoefList coef = segments[c];
            double GR0 = coef.grOrigin;
            double s0 = coef.coefficients.get(0);
            double s1 = coef.coefficients.get(1);
            double s2 = coef.coefficients.get(2);
            double s3 = coef.coefficients.get(3);
            double s4 = coef.coefficients.get(4);
            for (int i = 0; i < 11; ++i) {
                int x = i * subSamplingX;
                double GR = (double)x * pixelSpacing;
                double g = GR - GR0;
                double g2 = g * g;
                rangeDist[k++] = (float)(s0 + s1 * g + s2 * g2 + s3 * g2 * g + s4 * g2 * g2);
            }
        }
        for (int i = 0; i < rangeDist.length; ++i) {
            int index = i;
            if (!flipToSARGeometry && (isDescending && isAntennaPointingRight || !isDescending && !isAntennaPointingRight)) {
                index = rangeDist.length - 1 - i;
            }
            rangeTime[index] = (float)((double)rangeDist[i] / 1.49896229E8 * 1.0E9);
        }
        TiePointGrid slantRangeGrid = new TiePointGrid("slant_range_time", 11, 11, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, rangeTime);
        product.addTiePointGrid(slantRangeGrid);
        slantRangeGrid.setUnit("ns");
    }

    private static String getMission() {
        return "RS2";
    }

    @Override
    protected String getProductName() {
        return this.productName;
    }

    @Override
    protected String getProductDescription() {
        return "";
    }

    @Override
    protected String getProductType() {
        return this.productType;
    }
}

