/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.polsarpro;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.envi.EnviProductReader;
import org.esa.snap.dataio.envi.Header;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ResourceUtils;

public class PolsarProProductReader
extends EnviProductReader {
    PolsarProProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Product readProductNodesImpl() throws IOException {
        String productName;
        File inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        File folder = inputFile.getParentFile();
        File[] fileList = folder.listFiles();
        if (fileList == null) {
            throw new IOException("no files found in " + folder.toString());
        }
        ArrayList<Header> headerList = new ArrayList<Header>(fileList.length);
        HashMap<Header, File> headerFileMap = new HashMap<Header, File>(fileList.length);
        Header mainHeader = null;
        File mainHeaderFile = null;
        ResourceUtils.sortFileList((File[])fileList);
        for (File file : fileList) {
            File imgFile;
            if (file.isDirectory() || !file.getName().toLowerCase().endsWith("hdr") || !(imgFile = PolsarProProductReader.getEnviImageFile((File)file)).exists()) continue;
            try (BufferedReader headerReader = this.getHeaderReader(file);){
                BufferedReader bufferedReader = headerReader;
                synchronized (bufferedReader) {
                    Header header = new Header(headerReader);
                    headerList.add(header);
                    headerFileMap.put(header, file);
                    if (header.getNumBands() > 0 && header.getBandNames() != null) {
                        mainHeader = header;
                        mainHeaderFile = file;
                    }
                }
            }
        }
        if (mainHeader == null) {
            throw new IOException("Unable to read files");
        }
        if (inputFile.isDirectory()) {
            productName = inputFile.getName();
            if (productName.equalsIgnoreCase("T3") || productName.equalsIgnoreCase("C3") || productName.equalsIgnoreCase("T4") || productName.equalsIgnoreCase("C4")) {
                productName = inputFile.getParentFile().getName() + "_" + productName;
            }
        } else {
            String headerFileName = mainHeaderFile.getName();
            productName = headerFileName.substring(0, headerFileName.indexOf(46));
        }
        Product product = new Product(productName, mainHeader.getSensorType(), mainHeader.getNumSamples(), mainHeader.getNumLines());
        product.setProductReader((ProductReader)this);
        product.setDescription(mainHeader.getDescription());
        this.initGeoCoding(product, mainHeader);
        for (Header header : headerList) {
            this.initBands((File)headerFileMap.get(header), product, header);
        }
        PolsarProProductReader.applyBeamProperties((Product)product, (Header.BeamProperties)mainHeader.getBeamProperties());
        product.setFileLocation(mainHeaderFile);
        this.addMetadata(product, inputFile);
        return product;
    }

    private void addMetadata(Product product, File inputFile) throws IOException {
        if (!AbstractMetadata.hasAbstractedMetadata((Product)product)) {
            MetadataElement root = product.getMetadataRoot();
            MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)product.getName());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)product.getProductType());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)product.getSceneRasterWidth());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)product.getSceneRasterHeight());
            AbstractMetadataIO.loadExternalMetadata((Product)product, (MetadataElement)absRoot, (File)inputFile);
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        absRoot.setAttributeInt("polsar_data", 1);
    }
}

