/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits;

import Jama.Matrix;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.esa.s1tbx.io.orbits.BaseOrbitFile;
import org.esa.s1tbx.io.orbits.OrbitFile;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.engine_utilities.datamodel.DownloadableArchive;
import org.esa.snap.engine_utilities.datamodel.Orbits;
import org.esa.snap.engine_utilities.util.Maths;
import org.esa.snap.engine_utilities.util.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SentinelPODOrbitFile
extends BaseOrbitFile
implements OrbitFile {
    public static final String RESTITUTED = "Sentinel Restituted";
    public static final String PRECISE = "Sentinel Precise";
    private final int polyDegree;
    private static final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyyMMdd-HHmmss");
    private static final DateFormat orbitDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private FixedHeader fixedHeader = null;
    private final List<Orbits.OrbitVector> osvList = new ArrayList<Orbits.OrbitVector>();

    public SentinelPODOrbitFile(MetadataElement absRoot, int polyDegree) throws Exception {
        super(absRoot);
        this.polyDegree = polyDegree;
    }

    @Override
    public String[] getAvailableOrbitTypes() {
        return new String[]{PRECISE, RESTITUTED};
    }

    @Override
    public File retrieveOrbitFile(String orbitType) throws Exception {
        double stateVectorTime = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").getMJD();
        Calendar calendar = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").getAsCalendar();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        this.orbitFile = this.findOrbitFile(orbitType, stateVectorTime, year);
        if (this.orbitFile == null) {
            this.getRemoteFiles(orbitType, year, month);
            this.orbitFile = this.findOrbitFile(orbitType, stateVectorTime, year);
            if (this.orbitFile == null) {
                if (day < 15) {
                    this.getRemoteFiles(orbitType, year, month - 1);
                } else {
                    this.getRemoteFiles(orbitType, year, month + 1);
                }
                this.orbitFile = this.findOrbitFile(orbitType, stateVectorTime, year);
                if (this.orbitFile == null) {
                    String timeStr = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").format();
                    File destFolder = this.getDestFolder(orbitType, year);
                    throw new OperatorException("No valid orbit file found for " + timeStr + "\nOrbit files may be downloaded from https://qc.sentinel1.eo.esa.int/" + "\nand placed in " + destFolder.getAbsolutePath());
                }
            }
        }
        if (!this.orbitFile.exists()) {
            throw new IOException("SentinelPODOrbitFile: Unable to find POD orbit file");
        }
        this.readOrbitFile();
        this.checkOrbitFileValidity();
        return this.orbitFile;
    }

    private File getDestFolder(String orbitType, int year) {
        File orbitFileFolder = orbitType.startsWith(RESTITUTED) ? new File(Settings.getPath((String)"OrbitFiles.sentinel1RESOrbitPath") + File.separator + year) : new File(Settings.getPath((String)"OrbitFiles.sentinel1POEOrbitPath") + File.separator + year);
        return orbitFileFolder;
    }

    private File findOrbitFile(String orbitType, double stateVectorTime, int year) {
        File orbitFileFolder;
        String prefix;
        if (orbitType.startsWith(RESTITUTED)) {
            prefix = "S1A_OPER_AUX_RESORB_OPOD_";
            orbitFileFolder = new File(Settings.getPath((String)"OrbitFiles.sentinel1RESOrbitPath") + File.separator + year);
        } else {
            prefix = "S1A_OPER_AUX_POEORB_OPOD_";
            orbitFileFolder = new File(Settings.getPath((String)"OrbitFiles.sentinel1POEOrbitPath") + File.separator + year);
        }
        File[] files = orbitFileFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return ((name = name.toUpperCase()).endsWith(".ZIP") || name.endsWith(".EOF")) && name.startsWith(prefix);
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        for (File file : files) {
            try {
                String filename = file.getName();
                ProductData.UTC utcStart = SentinelPODOrbitFile.getValidityStartFromFilenameUTC(filename);
                ProductData.UTC utcEnd = SentinelPODOrbitFile.getValidityStopFromFilenameUTC(filename);
                if (utcStart == null || utcEnd == null || !(stateVectorTime >= utcStart.getMJD()) || !(stateVectorTime < utcEnd.getMJD())) continue;
                return file;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private void getRemoteFiles(String orbitType, int year, int month) throws Exception {
        block4: {
            URL remotePath;
            File localFolder;
            if (orbitType.startsWith(RESTITUTED)) {
                localFolder = new File(Settings.getPath((String)"OrbitFiles.sentinel1RESOrbitPath"), String.valueOf(year));
                Settings.instance();
                remotePath = new URL(Settings.getPath((String)"OrbitFiles.sentinel1RESOrbit_remotePath"));
            } else {
                localFolder = new File(Settings.getPath((String)"OrbitFiles.sentinel1POEOrbitPath"), String.valueOf(year));
                Settings.instance();
                remotePath = new URL(Settings.getPath((String)"OrbitFiles.sentinel1POEOrbit_remotePath"));
            }
            File localFile = new File(localFolder, year + "-" + month + ".zip");
            try {
                DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
                archive.getContentFiles();
            }
            catch (Exception e) {
                if (!localFile.exists()) break block4;
                localFile.delete();
                DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
                archive.getContentFiles();
            }
        }
    }

    private void checkOrbitFileValidity() throws Exception {
        double stateVectorTime = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").getMJD();
        String validityStartTimeStr = this.getValidityStartFromHeader();
        String validityStopTimeStr = this.getValidityStopFromHeader();
        double validityStartTimeMJD = SentinelPODOrbitFile.toUTC(validityStartTimeStr).getMJD();
        double validityStopTimeMJD = SentinelPODOrbitFile.toUTC(validityStopTimeStr).getMJD();
        if (stateVectorTime < validityStartTimeMJD || stateVectorTime > validityStopTimeMJD) {
            throw new OperatorException("Product acquisition time is not within the validity period of the orbit");
        }
    }

    public Orbits.OrbitVector[] getOrbitData(double startUTC, double endUTC) throws Exception {
        Orbits.OrbitVector endOSV;
        int endIdx;
        Orbits.OrbitVector startOSV = new Orbits.OrbitVector(startUTC);
        int startIdx = Collections.binarySearch(this.osvList, startOSV, new Orbits.OrbitComparator());
        if (startIdx < 0) {
            int insertionPt = -(startIdx + 1);
            startIdx = insertionPt == this.osvList.size() ? insertionPt - 1 : (insertionPt <= 0 ? 0 : insertionPt - 1);
        }
        if ((endIdx = Collections.binarySearch(this.osvList, endOSV = new Orbits.OrbitVector(endUTC), new Orbits.OrbitComparator())) < 0) {
            int insertionPt = -(endIdx + 1);
            endIdx = insertionPt == this.osvList.size() ? insertionPt - 1 : (insertionPt == 0 ? 0 : insertionPt);
        }
        int numOSV = (endIdx += 3) - (startIdx -= 3) + 1;
        Orbits.OrbitVector[] orbitDataList = new Orbits.OrbitVector[numOSV];
        int idx = startIdx;
        for (int i = 0; i < numOSV; ++i) {
            orbitDataList[i] = this.osvList.get(idx);
            ++idx;
        }
        return orbitDataList;
    }

    @Override
    public Orbits.OrbitVector getOrbitData(double utc) throws Exception {
        int i;
        int numVectors = this.osvList.size();
        double t0 = this.osvList.get((int)0).utcMJD;
        double tN = this.osvList.get((int)(numVectors - 1)).utcMJD;
        int numVecPolyFit = 4;
        int[] vectorIndices = new int[4];
        int vecIdx = (int)((utc - t0) / (tN - t0) * (double)(numVectors - 1));
        if (vecIdx <= 0) {
            for (i = 0; i < 4; ++i) {
                vectorIndices[i] = i;
            }
        } else if (vecIdx >= numVectors - 2) {
            for (i = 0; i < 4; ++i) {
                vectorIndices[i] = numVectors - 4 + i;
            }
        } else {
            for (i = 0; i < 4; ++i) {
                vectorIndices[i] = vecIdx - 1 + i;
            }
        }
        double[] timeArray = new double[4];
        double[] xPosArray = new double[4];
        double[] yPosArray = new double[4];
        double[] zPosArray = new double[4];
        double[] xVelArray = new double[4];
        double[] yVelArray = new double[4];
        double[] zVelArray = new double[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            timeArray[i2] = this.osvList.get((int)vectorIndices[i2]).utcMJD - t0;
            xPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).xPos;
            yPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).yPos;
            zPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).zPos;
            xVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).xVel;
            yVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).yVel;
            zVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).zVel;
        }
        Matrix A = Maths.createVandermondeMatrix((double[])timeArray, (int)this.polyDegree);
        double[] xPosCoeff = Maths.polyFit((Matrix)A, (double[])xPosArray);
        double[] yPosCoeff = Maths.polyFit((Matrix)A, (double[])yPosArray);
        double[] zPosCoeff = Maths.polyFit((Matrix)A, (double[])zPosArray);
        double[] xVelCoeff = Maths.polyFit((Matrix)A, (double[])xVelArray);
        double[] yVelCoeff = Maths.polyFit((Matrix)A, (double[])yVelArray);
        double[] zVelCoeff = Maths.polyFit((Matrix)A, (double[])zVelArray);
        double normalizedTime = utc - t0;
        return new Orbits.OrbitVector(utc, Maths.polyVal((double)normalizedTime, (double[])xPosCoeff), Maths.polyVal((double)normalizedTime, (double[])yPosCoeff), Maths.polyVal((double)normalizedTime, (double[])zPosCoeff), Maths.polyVal((double)normalizedTime, (double[])xVelCoeff), Maths.polyVal((double)normalizedTime, (double[])yVelCoeff), Maths.polyVal((double)normalizedTime, (double[])zVelCoeff));
    }

    private void readOrbitFile() throws Exception {
        Document doc;
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        if (this.orbitFile.getName().toLowerCase().endsWith(".zip")) {
            ZipFile productZip = new ZipFile(this.orbitFile, 1);
            Enumeration<? extends ZipEntry> entries = productZip.entries();
            ZipEntry zipEntry = entries.nextElement();
            doc = documentBuilder.parse(productZip.getInputStream(zipEntry));
        } else {
            doc = documentBuilder.parse(this.orbitFile);
        }
        doc.getDocumentElement().normalize();
        NodeList nodeList = doc.getElementsByTagName("Earth_Explorer_File");
        if (nodeList.getLength() != 1) {
            throw new Exception("SentinelPODOrbitFile.readOrbitFile: ERROR found too many Earth_Explorer_File " + nodeList.getLength());
        }
        Node fixedHeaderNode = null;
        Node variableHeaderNode = null;
        Node listOfOSVsNode = null;
        NodeList fileChildNodes = nodeList.item(0).getChildNodes();
        for (int i = 0; i < fileChildNodes.getLength(); ++i) {
            int j;
            Node fileChildNode = fileChildNodes.item(i);
            if (fileChildNode.getNodeName().equals("Earth_Explorer_Header")) {
                NodeList headerChildNodes = fileChildNode.getChildNodes();
                for (j = 0; j < headerChildNodes.getLength(); ++j) {
                    Node headerChildNode = headerChildNodes.item(j);
                    if (headerChildNode.getNodeName().equals("Fixed_Header")) {
                        fixedHeaderNode = headerChildNode;
                        continue;
                    }
                    if (!headerChildNode.getNodeName().equals("Variable_Header")) continue;
                    variableHeaderNode = headerChildNode;
                }
            } else if (fileChildNode.getNodeName().equals("Data_Block")) {
                NodeList dataBlockChildNodes = fileChildNode.getChildNodes();
                for (j = 0; j < dataBlockChildNodes.getLength(); ++j) {
                    Node dataBlockChildNode = dataBlockChildNodes.item(j);
                    if (!dataBlockChildNode.getNodeName().equals("List_of_OSVs")) continue;
                    listOfOSVsNode = dataBlockChildNode;
                }
            }
            if (fixedHeaderNode != null && variableHeaderNode != null && listOfOSVsNode != null) break;
        }
        if (fixedHeaderNode != null) {
            this.readFixedHeader(fixedHeaderNode);
        }
        if (listOfOSVsNode != null) {
            this.readOSVList(listOfOSVsNode);
        }
    }

    private void readFixedHeader(Node fixedHeaderNode) {
        NodeList fixedHeaderChildNodes = fixedHeaderNode.getChildNodes();
        String mission = null;
        String fileType = null;
        String validityStart = null;
        String validityStop = null;
        for (int i = 0; i < fixedHeaderChildNodes.getLength(); ++i) {
            Node fixedHeaderChildNode = fixedHeaderChildNodes.item(i);
            if (fixedHeaderChildNode.getNodeName().equals("Mission")) {
                mission = fixedHeaderChildNode.getTextContent();
            } else if (fixedHeaderChildNode.getNodeName().equals("File_Type")) {
                fileType = fixedHeaderChildNode.getTextContent();
            } else if (fixedHeaderChildNode.getNodeName().equals("Validity_Period")) {
                NodeList validityPeriodChildNodes = fixedHeaderChildNode.getChildNodes();
                for (int j = 0; j < validityPeriodChildNodes.getLength(); ++j) {
                    Node validityPeriodChildNode = validityPeriodChildNodes.item(j);
                    if (validityPeriodChildNode.getNodeName().equals("Validity_Start")) {
                        validityStart = validityPeriodChildNode.getTextContent();
                        continue;
                    }
                    if (!validityPeriodChildNode.getNodeName().equals("Validity_Stop")) continue;
                    validityStop = validityPeriodChildNode.getTextContent();
                }
            }
            if (mission == null || fileType == null || validityStart == null || validityStop == null) continue;
            this.fixedHeader = new FixedHeader(mission, fileType, validityStart, validityStop);
            break;
        }
    }

    private void readOSVList(Node listOfOSVsNode) throws Exception {
        Node attrCount = this.getAttributeFromNode(listOfOSVsNode, "count");
        if (attrCount == null) {
            return;
        }
        int count = Integer.parseInt(attrCount.getTextContent());
        int osvCnt = 0;
        for (Node childNode = listOfOSVsNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!childNode.getNodeName().equals("OSV")) continue;
            ++osvCnt;
            this.readOneOSV(childNode);
        }
        Collections.sort(this.osvList, new Orbits.OrbitComparator());
        if (count != osvCnt) {
            System.out.println("SentinelPODOrbitFile.readOSVList: WARNING List_of_OSVs count = " + count + " but found only " + osvCnt + " OSV");
        }
    }

    private void readOneOSV(Node osvNode) throws Exception {
        String utc = "";
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        block18: for (Node childNode = osvNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            switch (childNode.getNodeName()) {
                case "UTC": {
                    utc = childNode.getTextContent();
                    continue block18;
                }
                case "X": {
                    x = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "Y": {
                    y = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "Z": {
                    z = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "VX": {
                    vx = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "VY": {
                    vy = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "VZ": {
                    vz = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
            }
        }
        double utcTime = SentinelPODOrbitFile.toUTC(utc).getMJD();
        this.osvList.add(new Orbits.OrbitVector(utcTime, x, y, z, vx, vy, vz));
    }

    private Node getAttributeFromNode(Node node, String attrName) {
        NamedNodeMap attr = node.getAttributes();
        Node attrNode = null;
        for (int j = 0; j < attr.getLength(); ++j) {
            if (!attr.item(j).getNodeName().equals(attrName)) continue;
            if (attrNode == null) {
                attrNode = attr.item(j);
                continue;
            }
            System.out.println("SentinelPODOrbitFile.getAttributeFromNode: WARNING more than one " + attrName + " in " + node.getNodeName());
        }
        if (attrNode == null) {
            System.out.println("SentinelPODOrbitFile.getAttributeFromNode: Failed to find " + attrName + " in " + node.getNodeName());
        }
        return attrNode;
    }

    private static String convertUTC(String utc) {
        return utc.replace("UTC=", "").replace("T", " ");
    }

    public static String getMissionIDFromFilename(String filename) {
        return filename.substring(0, 3);
    }

    public static String getFileTypeFromFilename(String filename) {
        return filename.substring(9, 19);
    }

    private static String extractUTCTimeFromFilename(String filename, int offset) {
        String yyyy = filename.substring(offset, offset + 4);
        String mmDate = filename.substring(offset + 4, offset + 6);
        String dd = filename.substring(offset + 6, offset + 8);
        String hh = filename.substring(offset + 9, offset + 11);
        String mmTime = filename.substring(offset + 11, offset + 13);
        String ss = filename.substring(offset + 13, offset + 15);
        return "UTC=" + yyyy + "-" + mmDate + "-" + dd + "T" + hh + ":" + mmTime + ":" + ss;
    }

    private static String extractTimeFromFilename(String filename, int offset) {
        return filename.substring(offset, offset + 15).replace("T", "-");
    }

    public static ProductData.UTC getValidityStartFromFilenameUTC(String filename) throws ParseException {
        if (filename.substring(41, 42).equals("V")) {
            String val = SentinelPODOrbitFile.extractTimeFromFilename(filename, 42);
            return ProductData.UTC.parse((String)val, (DateFormat)dateFormat);
        }
        return null;
    }

    public static ProductData.UTC getValidityStopFromFilenameUTC(String filename) throws ParseException {
        if (filename.substring(41, 42).equals("V")) {
            String val = SentinelPODOrbitFile.extractTimeFromFilename(filename, 58);
            return ProductData.UTC.parse((String)val, (DateFormat)dateFormat);
        }
        return null;
    }

    public static String getValidityStartFromFilename(String filename) {
        if (filename.substring(41, 42).equals("V")) {
            return SentinelPODOrbitFile.extractUTCTimeFromFilename(filename, 42);
        }
        return null;
    }

    public static String getValidityStopFromFilename(String filename) {
        if (filename.substring(41, 42).equals("V")) {
            return SentinelPODOrbitFile.extractUTCTimeFromFilename(filename, 58);
        }
        return null;
    }

    public String getMissionFromHeader() {
        if (this.fixedHeader != null) {
            return this.fixedHeader.mission;
        }
        return null;
    }

    public String getFileTypeFromHeader() {
        if (this.fixedHeader != null) {
            return this.fixedHeader.fileType;
        }
        return null;
    }

    public String getValidityStartFromHeader() {
        if (this.fixedHeader != null) {
            return this.fixedHeader.validityStart;
        }
        return null;
    }

    public String getValidityStopFromHeader() {
        if (this.fixedHeader != null) {
            return this.fixedHeader.validityStop;
        }
        return null;
    }

    public static ProductData.UTC toUTC(String str) throws ParseException {
        return ProductData.UTC.parse((String)SentinelPODOrbitFile.convertUTC(str), (DateFormat)orbitDateFormat);
    }

    private final class FixedHeader {
        private final String mission;
        private final String fileType;
        private final String validityStart;
        private final String validityStop;

        FixedHeader(String mission, String fileType, String validityStart, String validityStop) {
            this.mission = mission;
            this.fileType = fileType;
            this.validityStart = validityStart;
            this.validityStop = validityStop;
        }
    }
}

