/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.datamodel.Orbits;
import org.esa.snap.engine_utilities.util.Maths;
import org.esa.snap.engine_utilities.util.ZipUtils;

public final class PrareOrbitReader {
    private DataInputStream in = null;
    private DataSetIdentificationRecord dataSetIdentificationRecord = null;
    private DataHeaderRecord dataHeaderRecord = null;
    private QualityParameterRecord[] qualityParameterRecords = null;
    private Orbits.OrbitVector[] orbitVectors = null;
    private double[] recordTimes = null;
    private int numOfTrajectoryRecords;
    private int numOfQualityParameterRecords;
    private static final int sizeOfDataSetIdentificationRecord = 130;
    private static final int sizeOfDataHeaderRecord = 130;
    private static final int sizeOfTrajectoryRecord = 130;
    private static final int sizeOfQualityParameterRecord = 130;
    private static final int maxNumOfQualityParameterRecords = 20;
    private static final double millimeterToMeter = 0.001;
    private static final double microMeterToMeter = 1.0E-6;
    private static final double microSecondToSecond = 1.0E-6;
    private static final double secondToDay = 1.1574074074074073E-5;
    private static final int interpolationOrder = 8;

    public void readOrbitHeader(File file) throws IOException {
        BufferedReader reader = PrareOrbitReader.getBufferedReader(file);
        this.readDataSetIdentificationRecord(reader);
        this.readDataHeaderRecord(reader);
        reader.close();
    }

    private static BufferedReader getBufferedReader(File file) throws IOException {
        FileInputStream stream;
        String filePath = file.getAbsolutePath();
        if (ZipUtils.isZipped((File)file)) {
            try {
                File tempFolder = SystemUtils.getCacheDir();
                File prevFile = new File(tempFolder, FileUtils.getFilenameWithoutExtension((File)file));
                if (prevFile.exists()) {
                    filePath = prevFile.getAbsolutePath();
                } else {
                    File[] files = ZipUtils.unzipToFolder((File)file, (File)tempFolder);
                    filePath = files[0].getAbsolutePath();
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage() + ": " + file.getAbsolutePath());
            }
        }
        try {
            stream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new OperatorException("File not found: " + filePath);
        }
        return new BufferedReader(new InputStreamReader(stream));
    }

    private void readDataSetIdentificationRecord(BufferedReader reader) throws IOException {
        char[] recKey = new char[6];
        char[] prodID = new char[15];
        char[] datTyp = new char[6];
        reader.read(recKey, 0, 6);
        reader.read(prodID, 0, 15);
        reader.read(datTyp, 0, 6);
        reader.skip(103L);
        this.dataSetIdentificationRecord = new DataSetIdentificationRecord();
        this.dataSetIdentificationRecord.recKey = new String(recKey);
        this.dataSetIdentificationRecord.prodID = new String(prodID);
        this.dataSetIdentificationRecord.datTyp = new String(datTyp);
    }

    private void readDataHeaderRecord(BufferedReader reader) throws IOException {
        char[] recKey = new char[6];
        char[] start = new char[6];
        char[] end = new char[6];
        char[] obsTyp = new char[6];
        char[] obsLev = new char[6];
        char[] modID = new char[2];
        char[] relID = new char[2];
        char[] rmsFit = new char[4];
        char[] sigPos = new char[4];
        char[] sigVel = new char[4];
        char[] qualit = new char[1];
        char[] tdtUtc = new char[5];
        char[] cmmnt = new char[78];
        reader.read(recKey, 0, 6);
        reader.read(start, 0, 6);
        reader.read(end, 0, 6);
        reader.read(obsTyp, 0, 6);
        reader.read(obsLev, 0, 6);
        reader.read(modID, 0, 2);
        reader.read(relID, 0, 2);
        reader.read(rmsFit, 0, 4);
        reader.read(sigPos, 0, 4);
        reader.read(sigVel, 0, 4);
        reader.read(qualit, 0, 1);
        reader.read(tdtUtc, 0, 5);
        reader.read(cmmnt, 0, 78);
        this.dataHeaderRecord = new DataHeaderRecord();
        this.dataHeaderRecord.recKey = new String(recKey);
        this.dataHeaderRecord.start = Float.parseFloat(new String(start).trim());
        this.dataHeaderRecord.end = Float.parseFloat(new String(end).trim());
        this.dataHeaderRecord.obsTyp = new String(obsTyp);
        this.dataHeaderRecord.obsLev = new String(obsLev);
        this.dataHeaderRecord.modID = Integer.parseInt(new String(modID).trim());
        this.dataHeaderRecord.relID = Integer.parseInt(new String(relID).trim());
        this.dataHeaderRecord.rmsFit = Integer.parseInt(new String(rmsFit).trim());
        this.dataHeaderRecord.sigPos = Integer.parseInt(new String(sigPos).trim());
        this.dataHeaderRecord.sigVel = Integer.parseInt(new String(sigVel).trim());
        String qualitStr = new String(qualit).trim();
        this.dataHeaderRecord.qualit = qualitStr.isEmpty() ? 0 : Integer.parseInt(qualitStr);
        this.dataHeaderRecord.tdtUtc = Float.parseFloat(new String(tdtUtc).trim());
        this.dataHeaderRecord.cmmnt = new String(cmmnt);
    }

    public void readOrbitData(File file) throws IOException {
        this.computeNumberOfRecords(file);
        this.orbitVectors = new Orbits.OrbitVector[this.numOfTrajectoryRecords];
        this.recordTimes = new double[this.numOfTrajectoryRecords];
        int numCharactersSkip = 260 + this.numOfTrajectoryRecords * 130;
        BufferedReader reader = PrareOrbitReader.getBufferedReader(file);
        reader.skip(numCharactersSkip);
        for (int i = 0; i < this.numOfTrajectoryRecords; ++i) {
            TrajectoryRecord dataRecord = PrareOrbitReader.readTrajectoryRecord(reader);
            double utcTime = PrareOrbitReader.TDT2UTC((double)dataRecord.tTagD * 0.1 + 0.5 + (double)dataRecord.tTagMs * 1.0E-6 * 1.1574074074074073E-5);
            this.orbitVectors[i] = new Orbits.OrbitVector(utcTime, (double)dataRecord.xSat * 0.001, (double)dataRecord.ySat * 0.001, (double)dataRecord.zSat * 0.001, (double)dataRecord.xDSat * 1.0E-6, (double)dataRecord.yDSat * 1.0E-6, (double)dataRecord.zDSat * 1.0E-6);
            this.recordTimes[i] = utcTime;
        }
        if (this.numOfQualityParameterRecords > 0) {
            this.qualityParameterRecords = new QualityParameterRecord[this.numOfQualityParameterRecords];
            for (int j = 0; j < this.numOfQualityParameterRecords; ++j) {
                this.qualityParameterRecords[j] = PrareOrbitReader.readQualityParameterRecord(reader);
            }
        }
        reader.close();
    }

    private void computeNumberOfRecords(File file) throws IOException {
        int fileSize = (int)file.length();
        int numRecordsApprox = (fileSize - 130 - 130 - 2600) / 260;
        int numCharactersSkip = 260 + numRecordsApprox * 130;
        BufferedReader reader = PrareOrbitReader.getBufferedReader(file);
        reader.skip(numCharactersSkip);
        char[] dataRecord = new char[130];
        int k = 0;
        while (true) {
            reader.read(dataRecord, 0, 130);
            if (dataRecord[0] == 'S' && dataRecord[1] == 'T' && dataRecord[2] == 'T' && dataRecord[3] == 'E' && dataRecord[4] == 'R' && dataRecord[5] == 'R') break;
            ++k;
        }
        reader.close();
        this.numOfTrajectoryRecords = numRecordsApprox + k;
        this.numOfQualityParameterRecords = 20 - 2 * k;
    }

    private static TrajectoryRecord readTrajectoryRecord(BufferedReader reader) throws IOException {
        char[] recKey = new char[6];
        char[] satID = new char[7];
        char[] orbTyp = new char[1];
        char[] tTagD = new char[6];
        char[] tTagMs = new char[11];
        char[] xSat = new char[12];
        char[] ySat = new char[12];
        char[] zSat = new char[12];
        char[] xDSat = new char[11];
        char[] yDSat = new char[11];
        char[] zDSat = new char[11];
        char[] roll = new char[6];
        char[] pitch = new char[6];
        char[] yaw = new char[6];
        char[] ascArc = new char[2];
        char[] check = new char[3];
        char[] quali = new char[1];
        char[] radCor = new char[4];
        reader.read(recKey, 0, 6);
        reader.read(satID, 0, 7);
        reader.read(orbTyp, 0, 1);
        reader.read(tTagD, 0, 6);
        reader.read(tTagMs, 0, 11);
        reader.read(xSat, 0, 12);
        reader.read(ySat, 0, 12);
        reader.read(zSat, 0, 12);
        reader.read(xDSat, 0, 11);
        reader.read(yDSat, 0, 11);
        reader.read(zDSat, 0, 11);
        reader.read(roll, 0, 6);
        reader.read(pitch, 0, 6);
        reader.read(yaw, 0, 6);
        reader.read(ascArc, 0, 2);
        reader.read(check, 0, 3);
        reader.read(quali, 0, 1);
        reader.read(radCor, 0, 4);
        reader.skip(2L);
        TrajectoryRecord trajectoryRecord = new TrajectoryRecord();
        trajectoryRecord.recKey = new String(recKey);
        trajectoryRecord.satID = Integer.parseInt(new String(satID).trim());
        trajectoryRecord.orbTyp = new String(orbTyp);
        trajectoryRecord.tTagD = Float.parseFloat(new String(tTagD).trim());
        trajectoryRecord.tTagMs = Long.parseLong(new String(tTagMs).trim());
        trajectoryRecord.xSat = Long.parseLong(new String(xSat).trim());
        trajectoryRecord.ySat = Long.parseLong(new String(ySat).trim());
        trajectoryRecord.zSat = Long.parseLong(new String(zSat).trim());
        trajectoryRecord.xDSat = Long.parseLong(new String(xDSat).trim());
        trajectoryRecord.yDSat = Long.parseLong(new String(yDSat).trim());
        trajectoryRecord.zDSat = Long.parseLong(new String(zDSat).trim());
        trajectoryRecord.roll = Float.parseFloat(new String(roll).trim());
        trajectoryRecord.pitch = Float.parseFloat(new String(pitch).trim());
        trajectoryRecord.yaw = Float.parseFloat(new String(yaw).trim());
        trajectoryRecord.ascArc = Integer.parseInt(new String(ascArc).trim());
        trajectoryRecord.check = Integer.parseInt(new String(check).trim());
        trajectoryRecord.quali = Integer.parseInt(new String(quali).trim());
        trajectoryRecord.radCor = Integer.parseInt(new String(radCor).trim());
        return trajectoryRecord;
    }

    private static QualityParameterRecord readQualityParameterRecord(BufferedReader reader) throws IOException {
        char[] recKey = new char[6];
        char[] qPName = new char[25];
        char[] qPValue = new char[10];
        char[] qPUnit = new char[26];
        char[] qPRefVal = new char[10];
        reader.read(recKey, 0, 6);
        reader.read(qPName, 0, 25);
        reader.skip(3L);
        reader.read(qPValue, 0, 10);
        reader.read(qPUnit, 0, 26);
        reader.read(qPRefVal, 0, 10);
        reader.skip(50L);
        QualityParameterRecord qualityParameterRecord = new QualityParameterRecord();
        qualityParameterRecord.recKey = new String(recKey);
        qualityParameterRecord.qPName = new String(qPName);
        qualityParameterRecord.qPValue = new String(qPValue);
        qualityParameterRecord.qPUnit = new String(qPUnit);
        qualityParameterRecord.qPRefVal = new String(qPRefVal);
        return qualityParameterRecord;
    }

    public float getSensingStart() throws IOException {
        return (float)PrareOrbitReader.TDT2UTC(this.dataHeaderRecord.start * 0.1f + 0.5f);
    }

    public float getSensingStop() throws IOException {
        return (float)PrareOrbitReader.TDT2UTC(this.dataHeaderRecord.end * 0.1f + 0.5f);
    }

    private static double TDT2UTC(double tdt) throws IOException {
        double tai = tdt - 3.7249999999999995E-4;
        Date date = new Date(109, 1, 1);
        if (tai >= ProductData.UTC.create((Date)date, (long)0L).getMJD()) {
            return tai - 3.935185185185185E-4;
        }
        Date date2 = new Date(106, 1, 1);
        if (tai >= ProductData.UTC.create((Date)date2, (long)0L).getMJD()) {
            return tai - 3.819444444444444E-4;
        }
        Date date3 = new Date(99, 1, 1);
        if (tai >= ProductData.UTC.create((Date)date3, (long)0L).getMJD()) {
            return tai - 3.7037037037037035E-4;
        }
        Date date4 = new Date(97, 7, 1);
        if (tai >= ProductData.UTC.create((Date)date4, (long)0L).getMJD()) {
            return tai - 3.587962962962963E-4;
        }
        Date date5 = new Date(96, 1, 1);
        if (tai >= ProductData.UTC.create((Date)date5, (long)0L).getMJD()) {
            return tai - 3.472222222222222E-4;
        }
        Date date6 = new Date(94, 7, 1);
        if (tai >= ProductData.UTC.create((Date)date6, (long)0L).getMJD()) {
            return tai - 3.356481481481481E-4;
        }
        Date date7 = new Date(93, 7, 1);
        if (tai >= ProductData.UTC.create((Date)date7, (long)0L).getMJD()) {
            return tai - 3.2407407407407406E-4;
        }
        Date date8 = new Date(92, 7, 1);
        if (tai >= ProductData.UTC.create((Date)date8, (long)0L).getMJD()) {
            return tai - 3.125E-4;
        }
        Date date9 = new Date(91, 1, 1);
        if (tai >= ProductData.UTC.create((Date)date9, (long)0L).getMJD()) {
            return tai - 3.009259259259259E-4;
        }
        throw new IOException("Incorrect UTC time");
    }

    public DataSetIdentificationRecord getDataSetIdentificationRecord() {
        return this.dataSetIdentificationRecord;
    }

    public DataHeaderRecord getDataHeaderRecord() {
        return this.dataHeaderRecord;
    }

    public QualityParameterRecord getQualityParameterRecord(int n) {
        return this.qualityParameterRecords[n];
    }

    public Orbits.OrbitVector getOrbitVector(int n) {
        return this.orbitVectors[n];
    }

    public Orbits.OrbitVector getOrbitVector(double utc) throws Exception {
        int itRel;
        int order = 8;
        int nRecords = this.recordTimes.length;
        double t0 = this.recordTimes[0];
        double tN = this.recordTimes[nRecords - 1];
        double tRel = (utc - t0) / (tN - t0) * (double)(nRecords - 1);
        int n0 = itRel = (int)Math.max(1L, Math.min(Math.round(tRel) - 4L, (long)(nRecords - 1 - 8)));
        int n1 = itRel + 1;
        int n2 = itRel + 2;
        int n3 = itRel + 3;
        int n4 = itRel + 4;
        int n5 = itRel + 5;
        int n6 = itRel + 6;
        int n7 = itRel + 7;
        int n8 = itRel + 8;
        if (n0 < 0 || n1 < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n5 > nRecords || n6 > nRecords || n7 > nRecords || n8 > nRecords) {
            throw new Exception("Incorrect UTC time");
        }
        double[] xPosArray = new double[]{this.orbitVectors[n0].xPos, this.orbitVectors[n1].xPos, this.orbitVectors[n2].xPos, this.orbitVectors[n3].xPos, this.orbitVectors[n4].xPos, this.orbitVectors[n5].xPos, this.orbitVectors[n6].xPos, this.orbitVectors[n7].xPos, this.orbitVectors[n8].xPos};
        double[] yPosArray = new double[]{this.orbitVectors[n0].yPos, this.orbitVectors[n1].yPos, this.orbitVectors[n2].yPos, this.orbitVectors[n3].yPos, this.orbitVectors[n4].yPos, this.orbitVectors[n5].yPos, this.orbitVectors[n6].yPos, this.orbitVectors[n7].yPos, this.orbitVectors[n8].yPos};
        double[] zPosArray = new double[]{this.orbitVectors[n0].zPos, this.orbitVectors[n1].zPos, this.orbitVectors[n2].zPos, this.orbitVectors[n3].zPos, this.orbitVectors[n4].zPos, this.orbitVectors[n5].zPos, this.orbitVectors[n6].zPos, this.orbitVectors[n7].zPos, this.orbitVectors[n8].zPos};
        double[] xVelArray = new double[]{this.orbitVectors[n0].xVel, this.orbitVectors[n1].xVel, this.orbitVectors[n2].xVel, this.orbitVectors[n3].xVel, this.orbitVectors[n4].xVel, this.orbitVectors[n5].xVel, this.orbitVectors[n6].xVel, this.orbitVectors[n7].xVel, this.orbitVectors[n8].xVel};
        double[] yVelArray = new double[]{this.orbitVectors[n0].yVel, this.orbitVectors[n1].yVel, this.orbitVectors[n2].yVel, this.orbitVectors[n3].yVel, this.orbitVectors[n4].yVel, this.orbitVectors[n5].yVel, this.orbitVectors[n6].yVel, this.orbitVectors[n7].yVel, this.orbitVectors[n8].yVel};
        double[] zVelArray = new double[]{this.orbitVectors[n0].zVel, this.orbitVectors[n1].zVel, this.orbitVectors[n2].zVel, this.orbitVectors[n3].zVel, this.orbitVectors[n4].zVel, this.orbitVectors[n5].zVel, this.orbitVectors[n6].zVel, this.orbitVectors[n7].zVel, this.orbitVectors[n8].zVel};
        double ref = tRel - (double)itRel;
        return new Orbits.OrbitVector(utc, Maths.lagrangeEightOrderInterpolation((double[])xPosArray, (double)ref), Maths.lagrangeEightOrderInterpolation((double[])yPosArray, (double)ref), Maths.lagrangeEightOrderInterpolation((double[])zPosArray, (double)ref), Maths.lagrangeEightOrderInterpolation((double[])xVelArray, (double)ref), Maths.lagrangeEightOrderInterpolation((double[])yVelArray, (double)ref), Maths.lagrangeEightOrderInterpolation((double[])zVelArray, (double)ref));
    }

    public static PrareOrbitReader getInstance() {
        return Holder.instance;
    }

    private static class Holder {
        private static final PrareOrbitReader instance = new PrareOrbitReader();

        private Holder() {
        }
    }

    public static final class QualityParameterRecord {
        String recKey;
        String qPName;
        String qPValue;
        String qPUnit;
        String qPRefVal;
    }

    public static final class TrajectoryRecord {
        String recKey;
        int satID;
        String orbTyp;
        float tTagD;
        long tTagMs;
        long xSat;
        long ySat;
        long zSat;
        long xDSat;
        long yDSat;
        long zDSat;
        float roll;
        float pitch;
        float yaw;
        int ascArc;
        int check;
        int quali;
        int radCor;
    }

    public static final class DataHeaderRecord {
        String recKey;
        float start;
        float end;
        String obsTyp;
        String obsLev;
        int modID;
        int relID;
        int rmsFit;
        int sigPos;
        int sigVel;
        int qualit;
        float tdtUtc;
        String cmmnt;
    }

    public static final class DataSetIdentificationRecord {
        String recKey;
        String prodID;
        String datTyp;
    }
}

