/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits;

import com.bc.ceres.core.NullProgressMonitor;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.esa.s1tbx.io.orbits.BaseOrbitFile;
import org.esa.s1tbx.io.orbits.PrareOrbitReader;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.downloadable.FtpDownloader;
import org.esa.snap.engine_utilities.datamodel.DownloadableArchive;
import org.esa.snap.engine_utilities.datamodel.Orbits;
import org.esa.snap.engine_utilities.util.Settings;

public class PrareOrbitFile
extends BaseOrbitFile {
    public static final String PRARE_PRECISE = "PRARE Precise";
    private PrareOrbitReader prareReader = null;
    private final Product sourceProduct;

    public PrareOrbitFile(MetadataElement absRoot, Product sourceProduct) throws Exception {
        super(absRoot);
        this.sourceProduct = sourceProduct;
    }

    @Override
    public String[] getAvailableOrbitTypes() {
        return new String[]{PRARE_PRECISE};
    }

    @Override
    public File retrieveOrbitFile(String orbitType) throws Exception {
        String remoteHTTPFolder;
        String remoteBaseFolder;
        String orbitPath;
        this.prareReader = PrareOrbitReader.getInstance();
        String mission = this.absRoot.getAttributeString("MISSION");
        if (mission.equals("ERS1")) {
            orbitPath = Settings.getPath((String)"OrbitFiles.prareERS1OrbitPath");
            remoteBaseFolder = Settings.getPath((String)"OrbitFiles.prareFTP_ERS1_remotePath");
            remoteHTTPFolder = Settings.getPath((String)"OrbitFiles.prareHTTP_ERS1_remotePath");
        } else {
            orbitPath = Settings.getPath((String)"OrbitFiles.prareERS2OrbitPath");
            remoteBaseFolder = Settings.getPath((String)"OrbitFiles.prareFTP_ERS2_remotePath");
            remoteHTTPFolder = Settings.getPath((String)"OrbitFiles.prareHTTP_ERS2_remotePath");
        }
        double startMJD = this.sourceProduct.getStartTime().getMJD();
        Calendar startDate = this.sourceProduct.getStartTime().getAsCalendar();
        int year = startDate.get(1);
        int month = startDate.get(2) + 1;
        String folder = String.valueOf(year);
        File localPath = new File(orbitPath + File.separator + folder);
        this.orbitFile = PrareOrbitFile.FindPrareOrbitFile(this.prareReader, localPath, startMJD);
        if (this.orbitFile == null) {
            this.getRemoteFiles(new File(orbitPath), remoteHTTPFolder, year);
            this.orbitFile = PrareOrbitFile.FindPrareOrbitFile(this.prareReader, localPath, startMJD);
            if (this.orbitFile == null) {
                String remotePath = remoteBaseFolder + '/' + folder;
                this.getRemotePrareFiles(remotePath, localPath, PrareOrbitFile.getPrefix(year, month));
                this.orbitFile = PrareOrbitFile.FindPrareOrbitFile(this.prareReader, localPath, startMJD);
                if (this.orbitFile == null) {
                    this.getRemotePrareFiles(remotePath, localPath, PrareOrbitFile.getPrefix(year, month + 1));
                    this.orbitFile = PrareOrbitFile.FindPrareOrbitFile(this.prareReader, localPath, startMJD);
                }
            }
        }
        if (this.orbitFile == null) {
            throw new IOException("Unable to find suitable orbit file \n" + orbitPath + "\nPlease check your firewall settings");
        }
        this.prareReader.readOrbitData(this.orbitFile);
        return this.orbitFile;
    }

    @Override
    public Orbits.OrbitVector getOrbitData(double utc) throws Exception {
        return this.prareReader.getOrbitVector(utc);
    }

    private void getRemoteFiles(File localFolder, String remoteHTTPFolder, int year) throws Exception {
        URL remotePath = new URL(remoteHTTPFolder);
        File localFile = new File(localFolder, year + ".zip");
        DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
        archive.getContentFiles();
    }

    private static String getPrefix(int year, int month) {
        year = year >= 2000 ? (year -= 2000) : (year -= 1900);
        String monthStr = String.valueOf(month);
        if (month < 10) {
            monthStr = '0' + monthStr;
        }
        return "PRC_" + year + monthStr;
    }

    private void getRemotePrareFiles(String remotePath, File localPath, String prefix) {
        String prareFTP = Settings.instance().get("OrbitFiles.prareFTP");
        try {
            if (this.ftp == null) {
                String user = Settings.instance().get("OrbitFiles.prareFTP_user");
                String pass = Settings.instance().get("OrbitFiles.prareFTP_pass");
                this.ftp = new FtpDownloader(prareFTP, user, pass);
                Map allfileSizeMap = FtpDownloader.readRemoteFileList((FtpDownloader)this.ftp, (String)prareFTP, (String)remotePath);
                this.fileSizeMap = new HashMap(10);
                Set remoteFileNames = allfileSizeMap.keySet();
                for (String fileName : remoteFileNames) {
                    if (!fileName.startsWith(prefix)) continue;
                    this.fileSizeMap.put(fileName, allfileSizeMap.get(fileName));
                }
            }
            if (!localPath.exists() && !localPath.mkdirs()) {
                throw new IOException("Failed to create directory '" + localPath + "'.");
            }
            PrareOrbitFile.getRemoteFiles(this.ftp, this.fileSizeMap, remotePath, localPath, (ProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static File FindPrareOrbitFile(PrareOrbitReader prareReader, File path, double startMJD) throws IOException {
        File[] list = path.listFiles();
        if (list == null) {
            return null;
        }
        for (File f : list) {
            if (f.isDirectory()) continue;
            prareReader.readOrbitHeader(f);
            float startDateInMJD = prareReader.getSensingStart();
            float stopDateInMJD = prareReader.getSensingStop();
            if (!((double)startDateInMJD <= startMJD) || !(startMJD < (double)stopDateInMJD)) continue;
            try {
                return f;
            }
            catch (Exception e) {
                throw new IOException("Unable to parse file: " + e.toString());
            }
        }
        return null;
    }
}

