/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.esa.s1tbx.io.orbits.OrbitFile;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.dataop.downloadable.FtpDownloader;
import org.esa.snap.engine_utilities.datamodel.Orbits;

public abstract class BaseOrbitFile
implements OrbitFile {
    protected final MetadataElement absRoot;
    protected File orbitFile = null;
    protected FtpDownloader ftp = null;
    protected Map<String, Long> fileSizeMap = null;

    protected BaseOrbitFile(MetadataElement absRoot) {
        this.absRoot = absRoot;
    }

    @Override
    public abstract File retrieveOrbitFile(String var1) throws Exception;

    @Override
    public abstract Orbits.OrbitVector getOrbitData(double var1) throws Exception;

    @Override
    public File getOrbitFile() {
        return this.orbitFile;
    }

    protected static void getRemoteFiles(FtpDownloader ftp, Map<String, Long> fileSizeMap, String remotePath, File localPath, ProgressMonitor pm) {
        Set<String> remoteFileNames = fileSizeMap.keySet();
        pm.beginTask("Downloading Orbit files from " + remotePath, remoteFileNames.size());
        for (String fileName : remoteFileNames) {
            if (pm.isCanceled()) break;
            long fileSize = fileSizeMap.get(fileName);
            File localFile = new File(localPath, fileName);
            if (localFile.exists() && localFile.length() == fileSize) continue;
            try {
                FtpDownloader.FTPError result;
                for (int attempts = 0; attempts < 3 && (result = ftp.retrieveFile(remotePath + '/' + fileName, localFile, Long.valueOf(fileSize))) != FtpDownloader.FTPError.OK; ++attempts) {
                    localFile.delete();
                }
            }
            catch (Exception e) {
                localFile.delete();
                System.out.println(e.getMessage());
            }
            pm.worked(1);
        }
        pm.done();
    }

    protected boolean getRemoteFile(String remoteFTP, String remotePath, File localFile) {
        try {
            if (this.ftp == null) {
                this.ftp = new FtpDownloader(remoteFTP);
                this.fileSizeMap = FtpDownloader.readRemoteFileList((FtpDownloader)this.ftp, (String)remoteFTP, (String)remotePath);
            }
            String remoteFileName = localFile.getName();
            Long fileSize = this.fileSizeMap.get(remoteFileName);
            FtpDownloader.FTPError result = this.ftp.retrieveFile(remotePath + remoteFileName, localFile, fileSize);
            if (result == FtpDownloader.FTPError.OK) {
                return true;
            }
            localFile.delete();
            return false;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }
}

