/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.netcdf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.esa.s1tbx.io.netcdf.NcAttributeMap;
import org.esa.s1tbx.io.netcdf.NcRasterDim;
import org.esa.s1tbx.io.netcdf.NcVariableMap;
import org.esa.s1tbx.io.netcdf.NetCDFUtils;
import org.esa.s1tbx.io.netcdf.NetcdfConstants;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelGeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetCDFReader
extends AbstractProductReader {
    private NetcdfFile netcdfFile = null;
    private Product product = null;
    private NcVariableMap variableMap = null;
    private boolean yFlipped = false;
    private final ProductReaderPlugIn readerPlugIn;

    public NetCDFReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
        this.readerPlugIn = readerPlugIn;
    }

    private void initReader() {
        this.product = null;
        this.netcdfFile = null;
        this.variableMap = null;
    }

    protected Product readProductNodesImpl() throws IOException {
        MetadataElement absRoot;
        String type;
        File inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        this.initReader();
        this.netcdfFile = NetcdfFile.open((String)inputFile.getPath());
        if (this.netcdfFile == null) {
            this.close();
            throw new IllegalFileFormatException(inputFile.getName() + " Could not be interpretted by the reader.");
        }
        Map<NcRasterDim, List<Variable>> variableListMap = NetCDFUtils.getVariableListMap(this.netcdfFile.getRootGroup());
        if (variableListMap.isEmpty()) {
            this.close();
            throw new IllegalFileFormatException("No netCDF variables found which could\nbe interpreted as remote sensing bands.");
        }
        NcRasterDim rasterDim = NetCDFUtils.getBestRasterDim(variableListMap);
        Variable[] rasterVariables = NetCDFUtils.getRasterVariables(variableListMap, rasterDim);
        Variable[] tiePointGridVariables = NetCDFUtils.getTiePointGridVariables(variableListMap, rasterVariables);
        this.variableMap = new NcVariableMap(rasterVariables);
        this.yFlipped = false;
        NcAttributeMap globalAttributes = NcAttributeMap.create(this.netcdfFile);
        this.product = new Product(inputFile.getName(), NetCDFUtils.getProductType(globalAttributes, this.readerPlugIn.getFormatNames()[0]), rasterDim.getDimX().getLength(), rasterDim.getDimY().getLength(), (ProductReader)this);
        this.product.setFileLocation(inputFile);
        this.product.setDescription(NetCDFUtils.getProductDescription(globalAttributes));
        this.product.setStartTime(NetCDFUtils.getSceneRasterStartTime(globalAttributes));
        this.product.setEndTime(NetCDFUtils.getSceneRasterStopTime(globalAttributes));
        this.addMetadataToProduct();
        this.addBandsToProduct(rasterVariables);
        this.addTiePointGridsToProduct(tiePointGridVariables);
        this.addGeoCodingToProduct(rasterDim);
        this.product.getGcpGroup();
        this.product.setModified(false);
        if (this.product.getProductType().equalsIgnoreCase(this.readerPlugIn.getFormatNames()[0]) && !(type = (absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.product)).getAttributeString("PRODUCT_TYPE")).isEmpty()) {
            this.product.setProductType(type);
        }
        return this.product;
    }

    public void close() throws IOException {
        if (this.product != null) {
            this.product = null;
            this.variableMap.clear();
            this.variableMap = null;
            this.netcdfFile.close();
            this.netcdfFile = null;
        }
        super.close();
    }

    private void addMetadataToProduct() {
        Group rootGroup = this.netcdfFile.getRootGroup();
        NetCDFUtils.addGroups(this.product.getMetadataRoot(), rootGroup);
        AbstractMetadata.getAbstractedMetadata((Product)this.product);
    }

    private void addBandsToProduct(Variable[] variables) {
        for (Variable variable : variables) {
            int rank = variable.getRank();
            int width = variable.getDimension(rank - 1).getLength();
            int height = variable.getDimension(rank - 2).getLength();
            Band band = NetCDFUtils.createBand(variable, width, height);
            this.product.addBand(band);
        }
    }

    private void addTiePointGridsToProduct(Variable[] variables) throws IOException {
        for (Variable variable : variables) {
            int rank = variable.getRank();
            int gridWidth = variable.getDimension(rank - 1).getLength();
            int gridHeight = variable.getDimension(rank - 2).getLength();
            if (rank >= 3 && gridHeight <= 1) {
                gridHeight = variable.getDimension(rank - 3).getLength();
            }
            TiePointGrid tpg = NetCDFUtils.createTiePointGrid(variable, gridWidth, gridHeight, this.product.getSceneRasterWidth(), this.product.getSceneRasterHeight());
            this.product.addTiePointGrid(tpg);
        }
    }

    private void addGeoCodingToProduct(NcRasterDim rasterDim) throws IOException {
        NetCDFReader.setTiePointGeoCoding(this.product);
        if (this.product.getSceneGeoCoding() == null) {
            NetCDFReader.setPixelGeoCoding(this.product);
        }
        if (this.product.getSceneGeoCoding() == null) {
            this.yFlipped = NetCDFReader.setMapGeoCoding(rasterDim, this.product, this.netcdfFile, this.yFlipped);
        }
    }

    public static boolean setMapGeoCoding(NcRasterDim rasterDim, Product product, NetcdfFile netcdfFile, boolean yFlipped) {
        String latStr;
        String lonStr;
        int n;
        NcVariableMap varMap = NcVariableMap.create(netcdfFile);
        Variable lonVar = null;
        Variable latVar = null;
        String[] stringArray = NetcdfConstants.LON_VAR_NAMES;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (lonVar = varMap.get(lonStr = stringArray[n])) == null; ++n) {
        }
        stringArray = NetcdfConstants.LAT_VAR_NAMES;
        n2 = stringArray.length;
        for (n = 0; n < n2 && (latVar = varMap.get(latStr = stringArray[n])) == null; ++n) {
        }
        if (lonVar != null && latVar != null && rasterDim.fitsTo(lonVar, latVar)) {
            try {
                NetCDFUtils.MapInfoX mapInfoX = NetCDFUtils.createMapInfoX(lonVar, latVar, product.getSceneRasterWidth(), product.getSceneRasterHeight());
                if (mapInfoX != null) {
                    yFlipped = mapInfoX.isYFlipped();
                    product.setSceneGeoCoding((GeoCoding)new MapGeoCoding(mapInfoX.getMapInfo()));
                }
            }
            catch (IOException e) {
                SystemUtils.LOG.warning("Failed to create NetCDF geo-coding");
            }
        }
        return yFlipped;
    }

    public static void setTiePointGeoCoding(Product product) {
        String latStr;
        String lonStr;
        int n;
        TiePointGrid lonGrid = null;
        TiePointGrid latGrid = null;
        String[] stringArray = NetcdfConstants.LON_VAR_NAMES;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (lonGrid = product.getTiePointGrid(lonStr = stringArray[n])) == null; ++n) {
        }
        stringArray = NetcdfConstants.LAT_VAR_NAMES;
        n2 = stringArray.length;
        for (n = 0; n < n2 && (latGrid = product.getTiePointGrid(latStr = stringArray[n])) == null; ++n) {
        }
        if (latGrid != null && lonGrid != null) {
            TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
            product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
        }
    }

    public static void setPixelGeoCoding(Product product) throws IOException {
        String latStr;
        String lonStr;
        int n;
        Band lonBand = null;
        Band latBand = null;
        String[] stringArray = NetcdfConstants.LON_VAR_NAMES;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (lonBand = product.getBand(lonStr = stringArray[n])) == null; ++n) {
        }
        stringArray = NetcdfConstants.LAT_VAR_NAMES;
        n2 = stringArray.length;
        for (n = 0; n < n2 && (latBand = product.getBand(latStr = stringArray[n])) == null; ++n) {
        }
        if (latBand != null && lonBand != null) {
            product.setSceneGeoCoding((GeoCoding)new PixelGeoCoding(latBand, lonBand, latBand.getValidPixelExpression(), 5, ProgressMonitor.NULL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Guardian.assertTrue((String)"sourceStepX == 1 && sourceStepY == 1", (sourceStepX == 1 && sourceStepY == 1 ? 1 : 0) != 0);
        Guardian.assertTrue((String)"sourceWidth == destWidth", (sourceWidth == destWidth ? 1 : 0) != 0);
        Guardian.assertTrue((String)"sourceHeight == destHeight", (sourceHeight == destHeight ? 1 : 0) != 0);
        int sceneHeight = this.product.getSceneRasterHeight();
        int y0 = this.yFlipped ? sceneHeight - 1 - sourceOffsetY : sourceOffsetY;
        Variable[] variables = this.variableMap.getAll();
        Variable variable = null;
        for (Variable var : variables) {
            if (!destBand.getName().equalsIgnoreCase(var.getName()) && !destBand.getName().equalsIgnoreCase(var.getShortName())) continue;
            variable = var;
            break;
        }
        if (variable == null) {
            throw new IOException("Band " + destBand.getName() + " not found");
        }
        int rank = variable.getRank();
        int[] origin = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < rank; ++i) {
            shape[i] = 1;
            origin[i] = 0;
        }
        shape[rank - 2] = 1;
        shape[rank - 1] = destWidth;
        origin[rank - 1] = sourceOffsetX;
        pm.beginTask("Reading data from band " + destBand.getName(), destHeight);
        try {
            for (int y = 0; y < destHeight; ++y) {
                Array array;
                origin[rank - 2] = this.yFlipped ? y0 - y : y0 + y;
                NetcdfFile netcdfFile = this.netcdfFile;
                synchronized (netcdfFile) {
                    array = variable.read(origin, shape);
                }
                System.arraycopy(array.getStorage(), 0, destBuffer.getElems(), y * destWidth, destWidth);
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                throw new IOException("Process terminated by user.");
            }
        }
        catch (InvalidRangeException e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
        finally {
            pm.done();
        }
    }
}

