/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.netcdf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NcVariableMap {
    private final Map<String, Variable> map;

    private NcVariableMap(int initialCapacity) {
        this.map = new HashMap<String, Variable>(initialCapacity);
    }

    public NcVariableMap(Variable[] variables) {
        this(3 * variables.length / 2 + 1);
        for (Variable variable : variables) {
            this.put(variable);
        }
    }

    private NcVariableMap(List<Variable> variables) {
        this(variables.toArray(new Variable[variables.size()]));
    }

    public static NcVariableMap create(NetcdfFile file) {
        return new NcVariableMap(file.getVariables());
    }

    public static NcVariableMap create(Group group) {
        return new NcVariableMap(group.getVariables());
    }

    public Variable get(String name) {
        return this.map.get(name);
    }

    void put(Variable variable) {
        this.map.put(variable.getName(), variable);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Variable[] getAll() {
        Set<String> keySet = this.map.keySet();
        Variable[] variables = new Variable[keySet.size()];
        int i = 0;
        for (String key : keySet) {
            variables[i++] = this.map.get(key);
        }
        return variables;
    }

    public static String getAbsoluteName(Variable variable) {
        StringBuilder sb = new StringBuilder(variable.getName());
        for (Group group = variable.getParentGroup(); group != null; group = group.getParentGroup()) {
            String groupName = group.getName();
            if (groupName.length() <= 0) continue;
            sb.insert(0, '.');
            sb.insert(0, groupName);
        }
        return sb.toString();
    }
}

