/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.netcdf;

import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class NcRasterDim {
    private final Dimension dimX;
    private final Dimension dimY;

    public NcRasterDim(Dimension dimX, Dimension dimY) {
        this.dimX = dimX;
        this.dimY = dimY;
    }

    public Dimension getDimX() {
        return this.dimX;
    }

    public Dimension getDimY() {
        return this.dimY;
    }

    public boolean isTypicalRasterDim() {
        if (this.dimX.getName() == null || this.dimY.getName() == null) {
            return false;
        }
        return this.dimX.getName().equalsIgnoreCase("lon") && this.dimY.getName().equalsIgnoreCase("lat") || this.dimX.getName().equalsIgnoreCase("longitude") && this.dimY.getName().equalsIgnoreCase("latitude") || this.dimX.getName().equalsIgnoreCase("ni") && this.dimY.getName().equalsIgnoreCase("nj") || this.dimX.getName().equalsIgnoreCase("x") && this.dimY.getName().equalsIgnoreCase("y");
    }

    public boolean fitsTo(Variable varX, Variable varY) {
        return varX.getRank() == 1 && varY.getRank() == 1 && varX.getDimension(0).getLength() == this.dimX.getLength() && varY.getDimension(0).getLength() == this.dimY.getLength();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NcRasterDim) {
            NcRasterDim other = (NcRasterDim)obj;
            return this.dimX.equals((Object)other.dimX) && this.dimY.equals((Object)other.dimY);
        }
        return false;
    }

    public int hashCode() {
        return this.dimX.hashCode() + this.dimY.hashCode();
    }
}

