/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.imageio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.esa.s1tbx.io.imageio.ImageIOWriter;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.SnapFileFilter;

public class ImageIOWriterPlugIn
implements ProductWriterPlugIn {
    private static final String[] FORMAT_NAMES = new String[]{"JP2", "JPG", "PNG", "BMP", "GIF"};

    public EncodeQualification getEncodeQualification(Product product) {
        return new EncodeQualification(EncodeQualification.Preservation.PARTIAL);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        String[] exclude;
        ArrayList<String> extList = new ArrayList<String>(20);
        extList.addAll(Arrays.asList(ImageIO.getWriterFileSuffixes()));
        for (String ext : exclude = new String[]{"pbm", "jpeg", "wbmp", "pgm", "ppm", "tiff", "tif", "tf8", "btf", "gz"}) {
            extList.remove(ext);
            extList.remove(ext.toUpperCase());
        }
        return extList.toArray(new String[extList.size()]);
    }

    public Class[] getOutputTypes() {
        return new Class[]{String.class, File.class};
    }

    public String getDescription(Locale name) {
        return "ImageIO writer";
    }

    public ProductWriter createWriterInstance() {
        return new ImageIOWriter(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

