/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.imageio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.esa.s1tbx.io.imageio.ImageIOReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class ImageIOReaderPlugIn
implements ProductReaderPlugIn {
    private static final String[] FORMAT_NAMES = ImageIOReaderPlugIn.getFormatNamesList();
    private static final String[] FORMAT_FILE_EXTENSIONS = ImageIOReaderPlugIn.getFormatFileExtensions();
    private static final String[] IMAGEIO_FILE_EXTENSIONS = ImageIOReaderPlugIn.getPrunedImageIOExtensions();
    private static final String PLUGIN_DESCRIPTION = "ImageIO Products";
    private final Class[] VALID_INPUT_TYPES = new Class[]{File.class, String.class};

    private static String[] getFormatNamesList() {
        ArrayList<String> names = new ArrayList<String>(40);
        names.add("ImageIO");
        names.addAll(Arrays.asList(ImageIO.getReaderFormatNames()));
        names.remove("geotiff");
        return names.toArray(new String[names.size()]);
    }

    private static String[] getFormatFileExtensions() {
        ArrayList<String> extList = new ArrayList<String>(20);
        extList.addAll(Arrays.asList(ImageIO.getReaderFileSuffixes()));
        ImageIOReaderPlugIn.exludeExtensions(extList);
        return extList.toArray(new String[extList.size()]);
    }

    private static void addAllBestExtensions(List<String> extList) {
        ImageIOReaderPlugIn.addBESTExt(extList, "XT");
        ImageIOReaderPlugIn.addBESTExt(extList, "AP");
        ImageIOReaderPlugIn.addBESTExt(extList, "PA");
        ImageIOReaderPlugIn.addBESTExt(extList, "CA");
        ImageIOReaderPlugIn.addBESTExt(extList, "IF");
        ImageIOReaderPlugIn.addBESTExt(extList, "FI");
        ImageIOReaderPlugIn.addBESTExt(extList, "DB");
        ImageIOReaderPlugIn.addBESTExt(extList, "SG");
        ImageIOReaderPlugIn.addBESTExt(extList, "OP");
        ImageIOReaderPlugIn.addBESTExt(extList, "GC");
        ImageIOReaderPlugIn.addBESTExt(extList, "OV");
        ImageIOReaderPlugIn.addBESTExt(extList, "UN");
        ImageIOReaderPlugIn.addBESTExt(extList, "CR");
        ImageIOReaderPlugIn.addBESTExt(extList, "SF");
        ImageIOReaderPlugIn.addBESTExt(extList, "BS");
        ImageIOReaderPlugIn.addBESTExt(extList, "GA");
    }

    private static void addBESTExt(List<String> extList, String ext) {
        extList.add(ext + 'i');
        extList.add(ext + 'f');
        extList.add(ext + 'c');
        extList.add(ext + 's');
        extList.add(ext + 't');
        extList.add(ext + 'r');
    }

    private static void exludeExtensions(List<String> extList) {
        extList.remove("jpeg");
        extList.remove("jls");
        extList.remove("jfif");
        extList.remove("tiff");
        extList.remove("tif");
        extList.remove("n1");
    }

    private static String[] getPrunedImageIOExtensions() {
        ArrayList<String> extList = new ArrayList<String>(20);
        extList.add("bmp");
        extList.add("gif");
        extList.add("jpg");
        extList.add("png");
        return extList.toArray(new String[extList.size()]);
    }

    public DecodeQualification getDecodeQualification(Object input) {
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file == null) {
            return DecodeQualification.UNABLE;
        }
        File parentDir = file.getParentFile();
        if (file.isFile() && parentDir != null && parentDir.isDirectory()) {
            return ImageIOReaderPlugIn.checkProductQualification(file);
        }
        return DecodeQualification.UNABLE;
    }

    private static DecodeQualification checkProductQualification(File file) {
        String fileExt = file.getName().toLowerCase();
        for (String ext : FORMAT_FILE_EXTENSIONS) {
            if (ext.isEmpty() || !fileExt.endsWith(ext.toLowerCase())) continue;
            if (ext.equalsIgnoreCase("tif") || ext.equalsIgnoreCase("tiff")) {
                return DecodeQualification.SUITABLE;
            }
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return this.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new ImageIOReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter();
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return FORMAT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return PLUGIN_DESCRIPTION;
    }

    public static class FileFilter
    extends SnapFileFilter {
        public FileFilter() {
            super(FORMAT_NAMES[0], IMAGEIO_FILE_EXTENSIONS, ImageIOReaderPlugIn.PLUGIN_DESCRIPTION);
        }

        public boolean accept(File file) {
            return super.accept(file) && (file.isDirectory() || this.checkExtension(file));
        }
    }
}

