/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.imageio;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class ImageIOReader
extends AbstractProductReader {
    private ImageIOFile imgIOFile = null;
    private String productType = "productType";
    private final transient Map<Band, ImageIOFile.BandInfo> bandMap = new HashMap<Band, ImageIOFile.BandInfo>(3);

    public ImageIOReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        File inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        this.imgIOFile = new ImageIOFile(inputFile, ImageIOFile.getIIOReader(inputFile), inputFile);
        this.productType = this.imgIOFile.getReader().getFormatName();
        Product product = new Product(inputFile.getName(), this.productType, this.imgIOFile.getSceneWidth(), this.imgIOFile.getSceneHeight());
        product.setFileLocation(inputFile);
        int bandCnt = 1;
        for (int i = 0; i < this.imgIOFile.getNumImages(); ++i) {
            for (int b = 0; b < this.imgIOFile.getNumBands(); ++b) {
                Band band = new Band("band" + bandCnt++, this.imgIOFile.getDataType(), this.imgIOFile.getSceneWidth(), this.imgIOFile.getSceneHeight());
                product.addBand(band);
                this.bandMap.put(band, new ImageIOFile.BandInfo(band, this.imgIOFile, i, b));
                if (!this.imgIOFile.isIndexed()) continue;
                band.setImageInfo(this.imgIOFile.getImageInfo());
                band.setSampleCoding((SampleCoding)this.imgIOFile.getIndexCoding());
                product.getIndexCodingGroup().add((ProductNode)this.imgIOFile.getIndexCoding());
            }
        }
        this.addMetaData(product, inputFile);
        product.getGcpGroup();
        product.setProductReader((ProductReader)this);
        product.setModified(false);
        product.setFileLocation(inputFile);
        return product;
    }

    public void close() throws IOException {
        super.close();
        this.imgIOFile.close();
    }

    private void addMetaData(Product product, File inputFile) throws IOException {
        MetadataElement root = product.getMetadataRoot();
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)inputFile.getName());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)this.productType);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)this.imgIOFile.getSceneWidth());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)this.imgIOFile.getSceneHeight());
        AbstractMetadataIO.loadExternalMetadata((Product)product, (MetadataElement)absRoot, (File)inputFile);
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        ImageIOFile.BandInfo bandInfo = this.bandMap.get(destBand);
        this.imgIOFile.readImageIORasterBand(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destBuffer, destOffsetX, destOffsetY, destWidth, destHeight, bandInfo.imageID, bandInfo.bandSampleOffset);
    }
}

