/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.gamma;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.esa.s1tbx.io.gamma.GammaProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public class HeaderWriter {
    private final File outputFile;
    private final Product srcProduct;
    private final MetadataElement absRoot;
    private String baseFileName;
    private boolean isComplex;
    private boolean isCoregistered;
    private final GammaProductWriter writer;
    private static final String sep = ":\t";

    public HeaderWriter(GammaProductWriter writer, Product srcProduct, File userOutputFile) {
        this.writer = writer;
        this.srcProduct = srcProduct;
        this.isComplex = false;
        this.isCoregistered = false;
        this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        if (this.absRoot != null) {
            try {
                this.isComplex = this.absRoot.getAttributeString("SAMPLE_TYPE").equals("COMPLEX");
                this.isCoregistered = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"coregistered_stack");
            }
            catch (Exception e) {
                SystemUtils.LOG.severe("Unable to read metadata " + e.getMessage());
            }
        }
        this.outputFile = this.createParFile(userOutputFile);
        this.baseFileName = FileUtils.getFilenameWithoutExtension((File)this.outputFile);
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public void writeParFile() throws IOException {
        FileOutputStream out = new FileOutputStream(this.outputFile);
        try (PrintStream p = new PrintStream(out);){
            p.println("title:\t" + this.srcProduct.getName());
            p.println("sensor:\t" + this.absRoot.getAttributeString("MISSION"));
            p.println("range_samples:\t" + this.srcProduct.getSceneRasterWidth());
            p.println("azimuth_lines:\t" + this.srcProduct.getSceneRasterHeight());
            p.println("image_format:\t" + this.getDataType());
            p.println("azimuth_line_time:\t" + this.absRoot.getAttributeString("line_time_interval"));
            p.println("range_looks:\t" + this.absRoot.getAttributeInt("range_looks"));
            p.println("azimuth_looks:\t" + this.absRoot.getAttributeInt("azimuth_looks"));
            p.println("radar_frequency:\t" + this.absRoot.getAttributeString("radar_frequency"));
            p.println("prf:\t" + this.absRoot.getAttributeString("pulse_repetition_frequency"));
            p.flush();
        }
        catch (Exception e) {
            throw new IOException("GammaWriter unable to write par file " + e.getMessage());
        }
    }

    public int getHighestElemSize() {
        int highestElemSize = 0;
        for (Band band : this.srcProduct.getBands()) {
            int elemSize;
            if (!this.writer.shouldWrite((ProductNode)band) || (elemSize = ProductData.getElemSize((int)band.getDataType())) <= highestElemSize) continue;
            highestElemSize = elemSize;
        }
        return highestElemSize;
    }

    private String getDataType() {
        int highestElemSize = this.getHighestElemSize();
        if (highestElemSize >= 4) {
            return "FCOMPLEX";
        }
        return "SCOMPLEX";
    }

    private File createParFile(File file) {
        String name = FileUtils.getFilenameWithoutExtension((File)file);
        String ext = FileUtils.getExtension((String)name);
        String newExt = ".par";
        if ((ext == null || !ext.endsWith("slc")) && this.isComplex) {
            newExt = this.isCoregistered ? ".rslc" + newExt : ".slc" + newExt;
        }
        name = name + newExt;
        return new File(file.getParent(), name);
    }
}

