/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.gamma;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class HeaderParser {
    private final Map<String, String> header;

    public HeaderParser(Map<String, String> header) {
        this.header = header;
    }

    public static HeaderParser parse(Reader reader) throws IOException {
        LinkedHashMap<String, String> header;
        BufferedReader bufferedReader = new BufferedReader(reader);
        LinkedHashMap<String, String> currentMap = header = new LinkedHashMap<String, String>();
        String line = bufferedReader.readLine();
        while (line != null) {
            if (line.contains(":")) {
                String[] keyValue = line.split(":", 2);
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                if (value.startsWith("{")) {
                    value = value.substring(1).trim();
                    while (!value.endsWith("}")) {
                        String continuedLine = bufferedReader.readLine();
                        value = value + " " + continuedLine.trim();
                        value = value.trim();
                    }
                    value = value.substring(0, value.length() - 1);
                }
                currentMap.put(key, value);
            }
            line = bufferedReader.readLine();
        }
        return new HeaderParser(header);
    }

    boolean contains(String key) {
        return this.header.containsKey(key);
    }

    String getString(String key) {
        if (!this.contains(key)) {
            throw new IllegalArgumentException("Missing mandatory header key: " + key);
        }
        return this.header.get(key);
    }

    String getNumericString(String key) {
        if (!this.contains(key)) {
            throw new IllegalArgumentException("Missing mandatory header key: " + key);
        }
        String val = this.header.get(key).trim();
        int lastDigit = val.length();
        if (val.indexOf(32) > 0) {
            lastDigit = val.indexOf(32);
        }
        return val.substring(0, lastDigit);
    }

    String getString(String key, String defaultValue) {
        return this.contains(key) ? this.getString(key) : defaultValue;
    }

    String[] getStrings(String key) {
        String v = this.header.get(key);
        if (v == null) {
            return new String[0];
        }
        String[] splits = v.split(",");
        ArrayList<String> splitsTrimmed = new ArrayList<String>(splits.length);
        for (String split : splits) {
            String trimmed = split.trim();
            if (trimmed.isEmpty()) continue;
            splitsTrimmed.add(trimmed);
        }
        return splitsTrimmed.toArray(new String[splitsTrimmed.size()]);
    }

    int getInt(String key) {
        if (!this.contains(key)) {
            throw new IllegalArgumentException("Missing mandatory header key: " + key);
        }
        return Integer.parseInt(this.getNumericString(key));
    }

    int getInt(String key, int defaultValue) {
        return this.contains(key) ? this.getInt(key) : defaultValue;
    }

    int[] getInts(String key) {
        String[] elems = this.getStrings(key);
        int[] ints = new int[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            ints[i] = Integer.parseInt(elems[i]);
        }
        return ints;
    }

    double getDouble(String key) {
        if (!this.contains(key)) {
            throw new IllegalArgumentException("Missing mandatory header key: " + key);
        }
        return Double.parseDouble(this.getNumericString(key));
    }

    double getDouble(String key, int defaultValue) {
        return this.contains(key) ? this.getDouble(key) : (double)defaultValue;
    }

    double[] getDoubles(String key) {
        String[] elems = this.getStrings(key);
        double[] doubles = new double[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            doubles[i] = Double.parseDouble(elems[i]);
        }
        return doubles;
    }

    Set<Map.Entry<String, String>> getHeaderEntries() {
        return this.header.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Header\n");
        HeaderParser.mapToString(sb, this.header);
        return sb.toString();
    }

    private static void mapToString(StringBuilder sb, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
    }
}

