/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.gamma;

import java.io.File;
import java.util.Locale;
import org.esa.s1tbx.io.gamma.GammaReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class GammaProductReaderPlugIn
implements ProductReaderPlugIn {
    public static final String DESCRIPTION = "Gamma File Format";
    public static final String[] FORMATS = new String[]{"Gamma"};
    public static final String EXT = ".par";

    public DecodeQualification getDecodeQualification(Object input) {
        String filename;
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file != null && (filename = file.getName().toLowerCase()).endsWith(EXT)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{File.class};
    }

    public ProductReader createReaderInstance() {
        return new GammaReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter();
    }

    public String[] getFormatNames() {
        return FORMATS;
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{EXT};
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }

    public static class FileFilter
    extends SnapFileFilter {
        public FileFilter() {
            this.setFormatName(FORMATS[0]);
            this.setDescription(GammaProductReaderPlugIn.DESCRIPTION);
            this.setExtensions(new String[]{GammaProductReaderPlugIn.EXT});
        }

        public boolean accept(File file) {
            if (super.accept(file)) {
                String name = file.getName().toLowerCase();
                if (file.isDirectory() || name.endsWith(GammaProductReaderPlugIn.EXT)) {
                    return true;
                }
            }
            return false;
        }
    }
}

