/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.cosmo;

import java.io.File;
import org.esa.s1tbx.io.cosmo.CosmoSkymedReader;
import org.esa.s1tbx.io.netcdf.NetCDFReaderPlugIn;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;

public class CosmoSkymedReaderPlugIn
extends NetCDFReaderPlugIn {
    private static final String[] COSMO_FORMAT_NAMES = new String[]{"CosmoSkymed"};
    private static final String[] COSMO_FORMAT_FILE_EXTENSIONS = new String[]{"h5"};
    private static final String COSMO_PLUGIN_DESCRIPTION = "Cosmo-Skymed Products";
    private static final String COSMO_FILE_PREFIX = "cs";

    public CosmoSkymedReaderPlugIn() {
        this.FORMAT_NAMES = COSMO_FORMAT_NAMES;
        this.FORMAT_FILE_EXTENSIONS = COSMO_FORMAT_FILE_EXTENSIONS;
        this.PLUGIN_DESCRIPTION = COSMO_PLUGIN_DESCRIPTION;
    }

    @Override
    protected DecodeQualification checkProductQualification(File file) {
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".h5") && fileName.startsWith(COSMO_FILE_PREFIX)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    @Override
    public ProductReader createReaderInstance() {
        return new CosmoSkymedReader(this);
    }
}

