/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.radarsat;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CEOSLeaderFile;
import org.jdom2.Document;

class RadarsatTrailerFile
extends CEOSLeaderFile {
    private static final String mission = "radarsat";
    private static final String trailer_recordDefinitionFile = "trailer_file.xml";
    private static final Document trailerXML = BinaryDBReader.loadDefinitionFile("radarsat", "trailer_file.xml");
    private static final Document sceneXML = BinaryDBReader.loadDefinitionFile("radarsat", "scene_record.xml");
    private static final Document mapProjXML = BinaryDBReader.loadDefinitionFile("radarsat", "map_proj_record.xml");
    private static final Document dataQualityXML = BinaryDBReader.loadDefinitionFile("radarsat", "data_quality_summary_record.xml");
    private static final Document histogramXML = BinaryDBReader.loadDefinitionFile("radarsat", "data_histogram_record.xml");
    private static final Document detailProcXML = BinaryDBReader.loadDefinitionFile("radarsat", "detailed_processing_record.xml");
    private static final Document platformXML = BinaryDBReader.loadDefinitionFile("radarsat", "platform_position_record.xml");
    private static final Document attitudeXML = BinaryDBReader.loadDefinitionFile("radarsat", "attitude_record.xml");
    private static final Document radiometricXML = BinaryDBReader.loadDefinitionFile("radarsat", "radiometric_record.xml");
    private static final Document radiometricCompXML = BinaryDBReader.loadDefinitionFile("radarsat", "radiometric_compensation_record.xml");
    private static final Document facilityXML = BinaryDBReader.loadDefinitionFile("radarsat", "facility_record.xml");

    public RadarsatTrailerFile(ImageInputStream stream) throws IOException {
        int i;
        BinaryFileReader reader = new BinaryFileReader(stream);
        this.leaderFDR = new BinaryRecord(reader, -1L, trailerXML, trailer_recordDefinitionFile);
        reader.seek(this.leaderFDR.getRecordEndPosition());
        int num = this.leaderFDR.getAttributeInt("Number of data set summary records");
        for (i = 0; i < num; ++i) {
            this.sceneHeaderRecord = new BinaryRecord(reader, -1L, sceneXML, "scene_record.xml");
            reader.seek(this.sceneHeaderRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of map projection data records");
        for (i = 0; i < num; ++i) {
            this.mapProjRecord = new BinaryRecord(reader, -1L, mapProjXML, "map_proj_record.xml");
            reader.seek(this.mapProjRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of data quality summary records");
        for (i = 0; i < num; ++i) {
            this.dataQualityRecord = new BinaryRecord(reader, -1L, dataQualityXML, "data_quality_summary_record.xml");
            reader.seek(this.dataQualityRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of data histograms records");
        for (i = 0; i < num; ++i) {
            this.histogramRecord = new BinaryRecord(reader, -1L, histogramXML, "data_histogram_record.xml");
            reader.seek(this.histogramRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of det. processing records");
        for (i = 0; i < num; ++i) {
            this.detailedProcessingRecord = new BinaryRecord(reader, -1L, detailProcXML, "detailed_processing_record.xml");
            reader.seek(this.detailedProcessingRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of platform pos. data records");
        for (i = 0; i < num; ++i) {
            this.platformPositionRecord = new BinaryRecord(reader, -1L, platformXML, "platform_position_record.xml");
            reader.seek(this.platformPositionRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of attitude data records");
        for (i = 0; i < num; ++i) {
            this.attitudeRecord = new BinaryRecord(reader, -1L, attitudeXML, "attitude_record.xml");
            reader.seek(this.attitudeRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of radiometric data records");
        for (i = 0; i < num; ++i) {
            this.radiometricRecord = new BinaryRecord(reader, -1L, radiometricXML, "radiometric_record.xml");
            reader.seek(this.radiometricRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of rad. compensation records");
        for (i = 0; i < num; ++i) {
            this.radiometricCompRecord = new BinaryRecord(reader, -1L, radiometricCompXML, "radiometric_compensation_record.xml");
            reader.seek(this.radiometricCompRecord.getRecordEndPosition());
        }
        num = this.leaderFDR.getAttributeInt("Number of facility data records");
        for (i = 0; i < num; ++i) {
            this.facilityRecord = new BinaryRecord(reader, -1L, facilityXML, "facility_record.xml");
            reader.seek(this.facilityRecord.getRecordEndPosition());
        }
        reader.close();
    }
}

