/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.radarsat;

import java.io.File;
import org.esa.s1tbx.io.ceos.CEOSProductReaderPlugIn;
import org.esa.s1tbx.io.ceos.radarsat.RadarsatConstants;
import org.esa.s1tbx.io.ceos.radarsat.RadarsatProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;

public class RadarsatProductReaderPlugIn
extends CEOSProductReaderPlugIn {
    public RadarsatProductReaderPlugIn() {
        this.constants = new RadarsatConstants();
    }

    @Override
    public ProductReader createReaderInstance() {
        return new RadarsatProductReader(this);
    }

    @Override
    protected DecodeQualification checkProductQualification(File file) {
        String name = file.getName().toUpperCase();
        if (name.endsWith(".ZIP") && name.startsWith("R1_")) {
            return DecodeQualification.INTENDED;
        }
        for (String prefix : this.constants.getVolumeFilePrefix()) {
            if (!name.startsWith(prefix) && !name.endsWith('.' + prefix)) continue;
            RadarsatProductReader reader = new RadarsatProductReader(this);
            return reader.checkProductQualification(file);
        }
        return DecodeQualification.UNABLE;
    }
}

