/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.radarsat;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.jdom2.Document;

class RadarsatImageFile
extends CEOSImageFile {
    private static final String mission = "radarsat";
    private static final String image_recordDefinitionFile = "image_file.xml";
    private static final String image_recordDefinition = "image_record.xml";
    private static final Document imgDefXML = BinaryDBReader.loadDefinitionFile("radarsat", "image_file.xml");
    private static final Document imgRecordXML = BinaryDBReader.loadDefinitionFile("radarsat", "image_record.xml");

    public RadarsatImageFile(ImageInputStream imageStream, BinaryRecord histogramRecord) throws IOException, IllegalBinaryFormatException {
        this.binaryReader = new BinaryFileReader(imageStream);
        this.imageFDR = new BinaryRecord(this.binaryReader, -1L, imgDefXML, image_recordDefinitionFile);
        this.binaryReader.seek(this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()));
        if (this.getRasterHeight() == 0) {
            int height = histogramRecord.getAttributeInt("Data samples in line");
            this.imageFDR.getBinaryDatabase().set("Number of lines per data set", height);
        }
        this.imageRecords = new BinaryRecord[this.getRasterHeight()];
        this.imageRecords[0] = this.createNewImageRecord(0);
        this._imageRecordLength = this.imageRecords[0].getRecordLength();
        this.startPosImageRecords = this.imageRecords[0].getStartPos();
        this.imageHeaderLength = this.imageFDR.getAttributeInt("Number of bytes of prefix data per record");
    }

    @Override
    protected BinaryRecord createNewImageRecord(int line) throws IOException {
        long pos = this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()) + (long)line * this._imageRecordLength;
        return new BinaryRecord(this.binaryReader, pos, imgRecordXML, image_recordDefinition);
    }
}

