/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.jers;

import com.bc.ceres.core.VirtualDir;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.esa.s1tbx.io.ceos.CEOSProductDirectory;
import org.esa.s1tbx.io.ceos.jers.JERSConstants;
import org.esa.s1tbx.io.ceos.jers.JERSImageFile;
import org.esa.s1tbx.io.ceos.jers.JERSLeaderFile;
import org.esa.s1tbx.io.ceos.jers.JERSTrailerFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

class JERSProductDirectory
extends CEOSProductDirectory {
    private JERSImageFile[] imageFiles = null;
    private JERSLeaderFile leaderFile = null;
    private JERSTrailerFile trailerFile = null;
    private final transient Map<String, JERSImageFile> bandImageFileMap = new HashMap<String, JERSImageFile>(1);

    public JERSProductDirectory(VirtualDir dir) {
        Guardian.assertNotNull((String)"dir", (Object)dir);
        this.constants = new JERSConstants();
        this.productDir = dir;
    }

    @Override
    protected void readProductDirectory() throws IOException, IllegalBinaryFormatException {
        this.readVolumeDirectoryFileStream();
        this.leaderFile = new JERSLeaderFile(this.getCEOSFile((String[])this.constants.getLeaderFilePrefix())[0].imgInputStream);
        CEOSProductDirectory.CeosFile[] ceosFiles = this.getCEOSFile(this.constants.getImageFilePrefix());
        ArrayList<JERSImageFile> imgArray = new ArrayList<JERSImageFile>(ceosFiles.length);
        for (CEOSProductDirectory.CeosFile imageFile : ceosFiles) {
            try {
                JERSImageFile imgFile = new JERSImageFile(imageFile.imgInputStream);
                imgArray.add(imgFile);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.imageFiles = imgArray.toArray(new JERSImageFile[imgArray.size()]);
        this.productType = this.leaderFile.getSceneRecord().getAttributeString("Product type descriptor");
        this.sceneWidth = this.imageFiles[0].getRasterWidth();
        this.sceneHeight = this.imageFiles[0].getRasterHeight();
        JERSProductDirectory.assertSameWidthAndHeightForAllImages(this.imageFiles, this.sceneWidth, this.sceneHeight);
    }

    @Override
    public Product createProduct() throws IOException {
        Product product = new Product(this.getProductName(), this.productType, this.sceneWidth, this.sceneHeight);
        if (this.imageFiles.length > 1) {
            int index = 1;
            for (JERSImageFile imageFile : this.imageFiles) {
                if (this.isProductSLC) {
                    Band bandI = this.createBand(product, "i_" + index, "real", imageFile);
                    Band bandQ = this.createBand(product, "q_" + index, "imaginary", imageFile);
                    ReaderUtils.createVirtualIntensityBand((Product)product, (Band)bandI, (Band)bandQ, (String)("_" + index));
                } else {
                    Band band = this.createBand(product, "Amplitude_" + index, "amplitude", imageFile);
                    SARReader.createVirtualIntensityBand(product, band, "_" + index);
                }
                ++index;
            }
        } else {
            JERSImageFile imageFile = this.imageFiles[0];
            if (this.isProductSLC) {
                Band bandI = this.createBand(product, "i", "real", imageFile);
                Band bandQ = this.createBand(product, "q", "imaginary", imageFile);
                ReaderUtils.createVirtualIntensityBand((Product)product, (Band)bandI, (Band)bandQ, (String)"");
            } else {
                Band band = this.createBand(product, "Amplitude", "amplitude", imageFile);
                SARReader.createVirtualIntensityBand(product, band, "");
            }
        }
        product.setStartTime(JERSProductDirectory.getUTCScanStartTime(this.leaderFile.getSceneRecord(), null));
        product.setEndTime(JERSProductDirectory.getUTCScanStopTime(this.leaderFile.getSceneRecord(), null));
        product.setDescription(this.getProductDescription());
        ReaderUtils.addGeoCoding((Product)product, (float[])JERSLeaderFile.getLatCorners(this.leaderFile.getMapProjRecord()), (float[])JERSLeaderFile.getLonCorners(this.leaderFile.getMapProjRecord()));
        JERSProductDirectory.addTiePointGrids(product, this.leaderFile.getFacilityRecord(), this.leaderFile.getSceneRecord());
        this.addMetaData(product);
        return product;
    }

    public boolean isJERS() throws IOException {
        String volumeId = this.getVolumeId().toUpperCase();
        String logicalVolumeId = this.getLogicalVolumeId().toUpperCase();
        return volumeId.contains("JERS") || volumeId.contains("J1") || volumeId.contains("JE1") || logicalVolumeId.contains("JERS") || logicalVolumeId.contains("J1") || logicalVolumeId.contains("JE1");
    }

    @Override
    public CEOSImageFile getImageFile(Band band) {
        return this.bandImageFileMap.get(band.getName());
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.imageFiles.length; ++i) {
            this.imageFiles[i].close();
            this.imageFiles[i] = null;
        }
        this.imageFiles = null;
    }

    private Band createBand(Product product, String name, String unit, JERSImageFile imageFile) {
        Band band = this.createBand(product, name, unit, imageFile.getBitsPerSample());
        this.bandImageFileMap.put(name, imageFile);
        return band;
    }

    private void addMetaData(Product product) throws IOException {
        MetadataElement root = AbstractMetadata.addOriginalProductMetadata((MetadataElement)product.getMetadataRoot());
        MetadataElement leadMetadata = new MetadataElement("Leader");
        this.leaderFile.addMetadata(leadMetadata);
        root.addElement(leadMetadata);
        if (this.trailerFile != null) {
            MetadataElement trailMetadata = new MetadataElement("Trailer");
            this.trailerFile.addMetadata(trailMetadata);
            root.addElement(trailMetadata);
        }
        MetadataElement volMetadata = new MetadataElement("Volume");
        this.volumeDirectoryFile.assignMetadataTo(volMetadata);
        root.addElement(volMetadata);
        int c = 1;
        for (JERSImageFile imageFile : this.imageFiles) {
            imageFile.assignMetadataTo(root, c++);
        }
        JERSProductDirectory.addSummaryMetadata(this.findFile("summary.txt"), "Summary Information", root);
        this.addAbstractedMetadataHeader(product, product.getMetadataRoot());
    }

    private void addAbstractedMetadataHeader(Product product, MetadataElement root) {
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)root);
        BinaryRecord sceneRec = this.leaderFile.getSceneRecord();
        BinaryRecord mapProjRec = this.leaderFile.getMapProjRecord();
        BinaryRecord facilityRec = this.leaderFile.getFacilityRecord();
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT", (String)this.getProductName());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PRODUCT_TYPE", (String)this.getProductType());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SPH_DESCRIPTOR", (String)sceneRec.getAttributeString("Product type descriptor"));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"MISSION", (String)"JERS1");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ACQUISITION_MODE", (String)"Stripmap");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"antenna_pointing", (String)"right");
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PROC_TIME", (ProductData.UTC)JERSProductDirectory.getProcTime(this.volumeDirectoryFile.getVolumeDescriptorRecord()));
        ProductData.UTC startTime = JERSProductDirectory.getUTCScanStartTime(sceneRec, null);
        ProductData.UTC endTime = JERSProductDirectory.getUTCScanStopTime(sceneRec, null);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_line_time", (ProductData.UTC)startTime);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_line_time", (ProductData.UTC)endTime);
        if (mapProjRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (Double)mapProjRec.getAttributeDouble("1st line 1st pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (Double)mapProjRec.getAttributeDouble("1st line 1st pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (Double)mapProjRec.getAttributeDouble("1st line last valid pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (Double)mapProjRec.getAttributeDouble("1st line last valid pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (Double)mapProjRec.getAttributeDouble("Last line 1st pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (Double)mapProjRec.getAttributeDouble("Last line 1st pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (Double)mapProjRec.getAttributeDouble("Last line last valid pixel geodetic latitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (Double)mapProjRec.getAttributeDouble("Last line last valid pixel geodetic longitude"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)JERSProductDirectory.getPass(mapProjRec, sceneRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (Double)mapProjRec.getAttributeDouble("Nominal inter-pixel distance in output scene"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (Double)mapProjRec.getAttributeDouble("Nominal inter-line distance in output scene"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"srgr_flag", (int)JERSProductDirectory.isGroundRange(mapProjRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"map_projection", (String)this.getMapProjection(mapProjRec));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"geo_ref_system", (String)mapProjRec.getAttributeString("Name of reference ellipsoid"));
        } else if (sceneRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (Double)sceneRec.getAttributeDouble("Pixel spacing"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (Double)sceneRec.getAttributeDouble("Line spacing"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"PASS", (String)JERSProductDirectory.getPass(mapProjRec, sceneRec));
        }
        if (sceneRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"Processing_system_identifier", (String)sceneRec.getAttributeString("Processing system identifier").trim());
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"algorithm", (String)sceneRec.getAttributeString("Processing algorithm identifier"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ABS_ORBIT", (int)Integer.parseInt(sceneRec.getAttributeString("Orbit number").trim()));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"mds1_tx_rx_polar", (String)SARReader.findPolarizationInBandName(sceneRec.getAttributeString("Sensor ID and mode of operation for this channel")));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"algorithm", (String)sceneRec.getAttributeString("Processing algorithm identifier"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_looks", (Double)sceneRec.getAttributeDouble("Nominal number of looks processed in azimuth"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_looks", (Double)sceneRec.getAttributeDouble("Nominal number of looks processed in range"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"pulse_repetition_frequency", (Double)sceneRec.getAttributeDouble("Pulse Repetition Frequency"));
            double radarFreq = sceneRec.getAttributeDouble("Radar frequency") * 1000.0;
            if (radarFreq == 0.0) {
                radarFreq = JERSProductDirectory.getRadarFrequency(sceneRec);
            }
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"radar_frequency", (double)radarFreq);
            Double slantRangeTime = sceneRec.getAttributeDouble("Zero-doppler range time of first range pixel");
            if (slantRangeTime != null) {
                slantRangeTime = slantRangeTime * 0.001;
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"slant_range_to_first_pixel", (double)(slantRangeTime * 1.49896229E8));
            }
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_sampling_rate", (Double)sceneRec.getAttributeDouble("Range sampling rate"));
            double rangeBW = sceneRec.getAttributeDouble("Total processor bandwidth in range");
            double azimuthBW = sceneRec.getAttributeDouble("Total processor bandwidth in azimuth");
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_bandwidth", (double)rangeBW);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_bandwidth", (double)azimuthBW);
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"SAMPLE_TYPE", (String)this.getSampleType());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"line_time_interval", (double)ReaderUtils.getLineTimeInterval((ProductData.UTC)startTime, (ProductData.UTC)endTime, (int)this.sceneHeight));
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_output_lines", (int)product.getSceneRasterHeight());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"num_samples_per_line", (int)product.getSceneRasterWidth());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"total_size", (int)ReaderUtils.getTotalSize((Product)product));
        if (facilityRec != null) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)AbstractMetadata.parseUTC((String)facilityRec.getAttributeString("Time of input state vector used to processed the image")));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"ant_elev_corr_flag", (int)facilityRec.getAttributeInt("Antenna pattern correction flag"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spread_comp_flag", (int)facilityRec.getAttributeInt("Range spreading loss compensation flag"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"replica_power_corr_flag", (int)0);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"abs_calibration_flag", (int)0);
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"calibration_factor", (Double)facilityRec.getAttributeDouble("Absolute calibration constant K"));
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)0);
        }
        JERSProductDirectory.addOrbitStateVectors(absRoot, this.leaderFile.getPlatformPositionRecord());
    }

    private String getMapProjection(BinaryRecord mapProjRec) {
        if (this.productType.contains("IMG") || this.productType.contains("GEC")) {
            return mapProjRec.getAttributeString("Map projection descriptor");
        }
        return " ";
    }

    private String getProductName() {
        return this.volumeDirectoryFile.getProductName();
    }

    private String getProductDescription() {
        BinaryRecord sceneRecord = this.leaderFile.getSceneRecord();
        String level = "";
        if (sceneRecord != null) {
            level = sceneRecord.getAttributeString("Scene reference number").trim();
        }
        return "JERS product " + level;
    }
}

