/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.ers;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CeosHelper;
import org.esa.snap.core.datamodel.MetadataElement;
import org.jdom2.Document;

class ERSLeaderFile {
    private final BinaryRecord _leaderFDR;
    private final BinaryRecord _sceneHeaderRecord;
    private final BinaryRecord _mapProjRecord;
    private final BinaryRecord _platformPositionRecord;
    private final BinaryRecord _facilityRecord;
    private final BinaryRecord _facilityRelatedPCSRecord;
    private static final String mission = "ers";
    private static final String leader_recordDefinitionFile = "leader_file.xml";
    private static final String scene_recordDefinitionFile = "scene_record.xml";
    private static final String mapproj_recordDefinitionFile = "map_proj_record.xml";
    private static final String platform_recordDefinitionFile = "platform_position_record.xml";
    private static final String facility_recordDefinitionFile = "facility_record.xml";
    private static final String facilityRelatedPCS_recordDefinitionFile = "facility_related_pcs_record.xml";
    private static final Document leaderXML = BinaryDBReader.loadDefinitionFile("ers", "leader_file.xml");
    private static final Document sceneXML = BinaryDBReader.loadDefinitionFile("ers", "scene_record.xml");
    private static final Document mapProjXML = BinaryDBReader.loadDefinitionFile("ers", "map_proj_record.xml");
    private static final Document platformXML = BinaryDBReader.loadDefinitionFile("ers", "platform_position_record.xml");
    private static final Document facilityXML = BinaryDBReader.loadDefinitionFile("ers", "facility_record.xml");
    private static final Document facilityRelXML = BinaryDBReader.loadDefinitionFile("ers", "facility_related_pcs_record.xml");

    public ERSLeaderFile(ImageInputStream leaderStream) throws IOException {
        BinaryFileReader reader = new BinaryFileReader(leaderStream);
        this._leaderFDR = new BinaryRecord(reader, -1L, leaderXML, leader_recordDefinitionFile);
        reader.seek(this._leaderFDR.getRecordEndPosition());
        this._sceneHeaderRecord = new BinaryRecord(reader, -1L, sceneXML, scene_recordDefinitionFile);
        reader.seek(this._sceneHeaderRecord.getRecordEndPosition());
        this._mapProjRecord = new BinaryRecord(reader, -1L, mapProjXML, mapproj_recordDefinitionFile);
        reader.seek(this._mapProjRecord.getRecordEndPosition());
        this._platformPositionRecord = new BinaryRecord(reader, -1L, platformXML, platform_recordDefinitionFile);
        reader.seek(this._platformPositionRecord.getRecordEndPosition());
        this._facilityRecord = new BinaryRecord(reader, -1L, facilityXML, facility_recordDefinitionFile);
        reader.seek(this._facilityRecord.getRecordEndPosition());
        if (reader.getCurrentPos() + 4000L < reader.getLength()) {
            this._facilityRelatedPCSRecord = new BinaryRecord(reader, -1L, facilityRelXML, facilityRelatedPCS_recordDefinitionFile);
            reader.seek(this._facilityRelatedPCSRecord.getRecordEndPosition());
        } else {
            this._facilityRelatedPCSRecord = null;
        }
        reader.close();
    }

    public String getProductLevel() {
        return this._sceneHeaderRecord.getAttributeString("Scene reference number").trim();
    }

    public final BinaryRecord getSceneRecord() {
        return this._sceneHeaderRecord;
    }

    public final BinaryRecord getFacilityRecord() {
        return this._facilityRecord;
    }

    public final BinaryRecord getMapProjRecord() {
        return this._mapProjRecord;
    }

    public final BinaryRecord getPlatformPositionRecord() {
        return this._platformPositionRecord;
    }

    public void addLeaderMetadata(MetadataElement sphElem) {
        CeosHelper.addMetadata(sphElem, this._leaderFDR, "Leader File Descriptor");
        CeosHelper.addMetadata(sphElem, this._sceneHeaderRecord, "Scene Parameters");
        CeosHelper.addMetadata(sphElem, this._mapProjRecord, "Map Projection");
        CeosHelper.addMetadata(sphElem, this._platformPositionRecord, "Platform Position");
        CeosHelper.addMetadata(sphElem, this._facilityRecord, "Facility Related");
        CeosHelper.addMetadata(sphElem, this._facilityRelatedPCSRecord, "Facility Related PCS");
    }
}

