/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.ers;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.jdom2.Document;

class ERSImageFile
extends CEOSImageFile {
    private static final String mission = "ers";
    private static final String image_DefinitionFile = "image_file.xml";
    private static final String image_recordDefinition = "image_record.xml";
    private static final Document imgDefXML = BinaryDBReader.loadDefinitionFile("ers", "image_file.xml");
    private static final Document imgRecordXML = BinaryDBReader.loadDefinitionFile("ers", "image_record.xml");

    public ERSImageFile(ImageInputStream imageStream) throws IOException, IllegalBinaryFormatException {
        this.binaryReader = new BinaryFileReader(imageStream);
        this.imageFDR = new BinaryRecord(this.binaryReader, -1L, imgDefXML, image_DefinitionFile);
        this.binaryReader.seek(this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()));
        this.imageRecords = new BinaryRecord[this.imageFDR.getAttributeInt("Number of lines per data set").intValue()];
        this.imageRecords[0] = this.createNewImageRecord(0);
        this._imageRecordLength = this.imageRecords[0].getRecordLength();
        this.startPosImageRecords = this.imageRecords[0].getStartPos();
        this.imageHeaderLength = 12;
    }

    @Override
    protected BinaryRecord createNewImageRecord(int line) throws IOException {
        long pos = this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()) + (long)line * this._imageRecordLength;
        return new BinaryRecord(this.binaryReader, pos, imgRecordXML, image_recordDefinition);
    }
}

