/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos2;

import java.io.File;
import org.esa.s1tbx.io.ceos.CEOSProductReaderPlugIn;
import org.esa.s1tbx.io.ceos.alos2.Alos2Constants;
import org.esa.s1tbx.io.ceos.alos2.Alos2ProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.engine_utilities.util.ZipUtils;

public class Alos2ProductReaderPlugIn
extends CEOSProductReaderPlugIn {
    public Alos2ProductReaderPlugIn() {
        this.constants = new Alos2Constants();
    }

    @Override
    public ProductReader createReaderInstance() {
        return new Alos2ProductReader(this);
    }

    @Override
    protected DecodeQualification checkProductQualification(File file) {
        String name = file.getName().toUpperCase();
        if (name.contains("ALOS2")) {
            for (String prefix : this.constants.getVolumeFilePrefix()) {
                if (!name.startsWith(prefix)) continue;
                Alos2ProductReader reader = new Alos2ProductReader(this);
                return reader.checkProductQualification(file);
            }
        }
        if (name.endsWith(".ZIP") && ZipUtils.findInZip((File)file, (String)"vol-alos2", (String)"")) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }
}

