/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos2;

import com.bc.ceres.core.VirtualDir;
import java.io.IOException;
import java.util.ArrayList;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.s1tbx.io.ceos.CEOSProductDirectory;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarImageFile;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarProductDirectory;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarTrailerFile;
import org.esa.s1tbx.io.ceos.alos2.Alos2Constants;
import org.esa.s1tbx.io.ceos.alos2.Alos2LeaderFile;

public class Alos2ProductDirectory
extends AlosPalsarProductDirectory {
    public Alos2ProductDirectory(VirtualDir dir) {
        super(dir);
        this.constants = new Alos2Constants();
        this.productDir = dir;
    }

    @Override
    protected void readProductDirectory() throws IOException, IllegalBinaryFormatException {
        this.readVolumeDirectoryFileStream();
        this.updateProductType();
        this.leaderFile = new Alos2LeaderFile(this.getCEOSFile((String[])this.constants.getLeaderFilePrefix())[0].imgInputStream);
        CEOSProductDirectory.CeosFile[] trlFile = this.getCEOSFile(this.constants.getTrailerFilePrefix());
        if (trlFile != null) {
            this.trailerFile = new AlosPalsarTrailerFile(trlFile[0].imgInputStream);
        }
        CEOSProductDirectory.CeosFile[] ceosFiles = this.getCEOSFile(this.constants.getImageFilePrefix());
        ArrayList<AlosPalsarImageFile> imgArray = new ArrayList<AlosPalsarImageFile>(ceosFiles.length);
        for (CEOSProductDirectory.CeosFile imageFile : ceosFiles) {
            try {
                AlosPalsarImageFile imgFile = new AlosPalsarImageFile(imageFile.imgInputStream, this.getProductLevel(), imageFile.fileName);
                imgArray.add(imgFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.imageFiles = imgArray.toArray(new AlosPalsarImageFile[imgArray.size()]);
        this.sceneWidth = this.imageFiles[0].getRasterWidth();
        this.sceneHeight = this.imageFiles[0].getRasterHeight();
        Alos2ProductDirectory.assertSameWidthAndHeightForAllImages(this.imageFiles, this.sceneWidth, this.sceneHeight);
        if (this.leaderFile.getProductLevel() == 0 || this.leaderFile.getProductLevel() == 1) {
            this.isProductSLC = true;
        }
    }

    public boolean isALOS2() throws IOException {
        String volumeId = this.getVolumeId().toUpperCase();
        String logicalVolumeId = this.getLogicalVolumeId().toUpperCase();
        return volumeId.contains("ALOS2") || logicalVolumeId.contains("ALOS2");
    }

    @Override
    protected String getMission() {
        return "ALOS2";
    }

    @Override
    protected String getProductDescription() {
        return "ALOS 2 product " + this.leaderFile.getProductLevel();
    }
}

