/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos2;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CeosRecordHeader;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarLeaderFile;
import org.jdom2.Document;

public class Alos2LeaderFile
extends AlosPalsarLeaderFile {
    protected static final String mission = "alos2";
    private static final String leader_recordDefinitionFile = "leader_file.xml";
    private static final String facility_record1_5DefinitionFile = "facility_record1_5.xml";
    private static final Document leaderXML = BinaryDBReader.loadDefinitionFile("alos2", "leader_file.xml");
    private static final Document facilityXML = BinaryDBReader.loadDefinitionFile("alos2", "facility_record.xml");
    private static final Document facility1_5XML = BinaryDBReader.loadDefinitionFile("alos2", "facility_record1_5.xml");

    public Alos2LeaderFile(ImageInputStream stream) throws IOException {
        super(stream, leaderXML);
    }

    @Override
    protected void readFacilityRelatedRecords(BinaryFileReader reader) {
        for (int i = 0; i < this.leaderFDR.getAttributeInt("Number of facility data records"); ++i) {
            try {
                CeosRecordHeader header = new CeosRecordHeader(reader);
                int level = this.getProductLevel();
                if (level == 0 || level == 1) {
                    int facilityRecordNum = 11;
                    while (header.getRecordNum() < facilityRecordNum && header.getRecordLength() > 0) {
                        header.seekToEnd();
                        header = new CeosRecordHeader(reader);
                    }
                    this.facilityRecord = new BinaryRecord(reader, -1L, facilityXML, "facility_record.xml");
                    header.seekToEnd();
                    continue;
                }
                this.facilityRecord = new BinaryRecord(reader, -1L, facility1_5XML, facility_record1_5DefinitionFile);
                header.seekToEnd();
                continue;
            }
            catch (Exception e) {
                System.out.println("Unable to read ALOS facility record: " + e.getMessage());
            }
        }
    }
}

