/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.SystemUtils;

public class TiePointGridLazy
extends TiePointGrid {
    private boolean hasData = false;

    public TiePointGridLazy(String name, int gridWidth, int gridHeight, double offsetX, double offsetY, double subSamplingX, double subSamplingY, float[] tiePoints) {
        super(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints, DISCONT_NONE);
    }

    private void initData() {
        try {
            this.getProductReader().readTiePointGridRasterData((TiePointGrid)this, 0, 0, this.getGridWidth(), this.getGridHeight(), super.getData(), ProgressMonitor.NULL);
            this.hasData = true;
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to load TPG: " + e.getMessage());
        }
    }

    public ProductData getGridData() {
        if (!this.hasData) {
            this.initData();
        }
        return super.getData();
    }

    public double getPixelDouble(double x, double y) {
        if (!this.hasData) {
            this.initData();
        }
        return super.getPixelDouble(x, y);
    }

    public int[] getPixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) {
        if (!this.hasData) {
            this.initData();
        }
        return super.getPixels(x, y, w, h, pixels, pm);
    }

    public double[] getPixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) {
        if (!this.hasData) {
            this.initData();
        }
        return super.getPixels(x, y, w, h, pixels, pm);
    }

    public float[] getPixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) {
        if (!this.hasData) {
            this.initData();
        }
        return super.getPixels(x, y, w, h, pixels, pm);
    }
}

