/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos;

import java.io.File;
import org.esa.s1tbx.io.ceos.CEOSProductReaderPlugIn;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarConstants;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;

public class AlosPalsarProductReaderPlugIn
extends CEOSProductReaderPlugIn {
    public AlosPalsarProductReaderPlugIn() {
        this.constants = new AlosPalsarConstants();
    }

    @Override
    public ProductReader createReaderInstance() {
        return new AlosPalsarProductReader(this);
    }

    @Override
    protected DecodeQualification checkProductQualification(File file) {
        String name = file.getName().toUpperCase();
        if (name.endsWith(".ZIP") && (name.startsWith("ALPSR") || name.startsWith("ALOS") && !name.startsWith("ALOS2"))) {
            return DecodeQualification.INTENDED;
        }
        for (String prefix : this.constants.getVolumeFilePrefix()) {
            if (!name.startsWith(prefix) || name.contains("ALOS2")) continue;
            AlosPalsarProductReader reader = new AlosPalsarProductReader(this);
            return reader.checkProductQualification(file);
        }
        return DecodeQualification.UNABLE;
    }
}

