/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import java.io.File;
import java.io.IOException;
import org.esa.s1tbx.io.ceos.CEOSProductDirectory;
import org.esa.s1tbx.io.ceos.CEOSProductReader;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarImageFile;
import org.esa.s1tbx.io.ceos.alos.AlosPalsarProductDirectory;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;

public class AlosPalsarProductReader
extends CEOSProductReader {
    public AlosPalsarProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    @Override
    protected CEOSProductDirectory createProductDirectory(VirtualDir productDir) {
        return new AlosPalsarProductDirectory(productDir);
    }

    DecodeQualification checkProductQualification(File file) {
        try {
            this.dataDir = this.createProductDirectory(this.createProductDir(file));
            AlosPalsarProductDirectory alosDataDir = (AlosPalsarProductDirectory)this.dataDir;
            if (alosDataDir.isALOS()) {
                return DecodeQualification.INTENDED;
            }
            return DecodeQualification.UNABLE;
        }
        catch (Exception e) {
            return DecodeQualification.UNABLE;
        }
    }

    public void readTiePointGridRasterData(TiePointGrid tpg, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AlosPalsarProductDirectory alosDataDir = (AlosPalsarProductDirectory)this.dataDir;
        alosDataDir.readTiePointGridRasterData(tpg, destBuffer, pm);
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        try {
            AlosPalsarProductDirectory dataDir = (AlosPalsarProductDirectory)this.dataDir;
            AlosPalsarImageFile imageFile = (AlosPalsarImageFile)dataDir.getImageFile(destBand);
            if (dataDir.isSLC()) {
                boolean oneOf2;
                boolean bl = oneOf2 = destBand.getUnit().equals("real") || !destBand.getName().startsWith("q");
                if (dataDir.getProductLevel() == 0) {
                    imageFile.readBandRasterDataSLCByte(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, oneOf2, pm);
                } else {
                    imageFile.readBandRasterDataSLCFloat(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, oneOf2, pm);
                }
            } else {
                imageFile.readBandRasterDataShort(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, pm);
            }
        }
        catch (Exception e) {
            this.handleReaderException(e);
        }
    }
}

