/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CEOSLeaderFile;
import org.esa.s1tbx.io.ceos.CeosRecordHeader;
import org.jdom2.Document;

public class AlosPalsarLeaderFile
extends CEOSLeaderFile {
    protected static final String mission = "alos";
    private static final String leader_recordDefinitionFile = "leader_file.xml";
    private int productLevel = -1;
    private static final String facility_record1_5DefinitionFile = "facility_record1_5.xml";
    private static final Document leaderXML = BinaryDBReader.loadDefinitionFile("alos", "leader_file.xml");
    private static final Document sceneXML = BinaryDBReader.loadDefinitionFile("alos", "scene_record.xml");
    private static final Document mapProjXML = BinaryDBReader.loadDefinitionFile("alos", "map_proj_record.xml");
    private static final Document platformXML = BinaryDBReader.loadDefinitionFile("alos", "platform_position_record.xml");
    private static final Document attitudeXML = BinaryDBReader.loadDefinitionFile("alos", "attitude_record.xml");
    private static final Document radiometricXML = BinaryDBReader.loadDefinitionFile("alos", "radiometric_record.xml");
    private static final Document dataQualityXML = BinaryDBReader.loadDefinitionFile("alos", "data_quality_summary_record.xml");
    private static final Document facilityXML = BinaryDBReader.loadDefinitionFile("alos", "facility_record.xml");
    private static final Document facility1_5XML = BinaryDBReader.loadDefinitionFile("alos", "facility_record1_5.xml");

    public AlosPalsarLeaderFile(ImageInputStream stream) throws IOException {
        this(stream, leaderXML);
    }

    public AlosPalsarLeaderFile(ImageInputStream stream, Document fdrXML) throws IOException {
        int i;
        BinaryFileReader reader = new BinaryFileReader(stream);
        CeosRecordHeader header = new CeosRecordHeader(reader);
        this.leaderFDR = new BinaryRecord(reader, -1L, fdrXML, leader_recordDefinitionFile);
        header.seekToEnd();
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of data set summary records"); ++i) {
            header = new CeosRecordHeader(reader);
            this.sceneHeaderRecord = new BinaryRecord(reader, -1L, sceneXML, "scene_record.xml");
            header.seekToEnd();
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of map projection data records"); ++i) {
            try {
                header = new CeosRecordHeader(reader);
                this.mapProjRecord = new BinaryRecord(reader, -1L, mapProjXML, "map_proj_record.xml");
                header.seekToEnd();
                continue;
            }
            catch (Exception e) {
                System.out.println("unable to read projection");
            }
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of platform pos. data records"); ++i) {
            try {
                header = new CeosRecordHeader(reader);
                this.platformPositionRecord = new BinaryRecord(reader, -1L, platformXML, "platform_position_record.xml");
                header.seekToEnd();
                continue;
            }
            catch (Exception e) {
                System.out.println("unable to read platform pos");
            }
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of attitude data records"); ++i) {
            try {
                header = new CeosRecordHeader(reader);
                this.attitudeRecord = new BinaryRecord(reader, -1L, attitudeXML, "attitude_record.xml");
                header.seekToEnd();
                continue;
            }
            catch (Exception e) {
                System.out.println("unable to read attitude");
            }
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of radiometric data records"); ++i) {
            try {
                header = new CeosRecordHeader(reader);
                this.radiometricRecord = new BinaryRecord(reader, -1L, radiometricXML, "radiometric_record.xml");
                header.seekToEnd();
                continue;
            }
            catch (Exception e) {
                System.out.println("unable to read radiometric");
            }
        }
        for (i = 0; i < this.leaderFDR.getAttributeInt("Number of data quality summary records"); ++i) {
            try {
                header = new CeosRecordHeader(reader);
                this.dataQualityRecord = new BinaryRecord(reader, -1L, dataQualityXML, "data_quality_summary_record.xml");
                header.seekToEnd();
                continue;
            }
            catch (Exception e) {
                System.out.println("unable to read quality");
            }
        }
        int num = this.leaderFDR.getAttributeInt("Number of det. processing records");
        this.readFacilityRelatedRecords(reader);
        reader.close();
        if (this.getProductLevel() == 0) {
            throw new IOException("ALOS L0 products are not supported");
        }
    }

    protected void readFacilityRelatedRecords(BinaryFileReader reader) {
        for (int i = 0; i < this.leaderFDR.getAttributeInt("Number of facility data records"); ++i) {
            try {
                CeosRecordHeader header = new CeosRecordHeader(reader);
                int level = this.getProductLevel();
                if (level == 0 || level == 1) {
                    int facilityRecordNum = 17;
                    while (header.getRecordNum() < facilityRecordNum && header.getRecordLength() > 0) {
                        header.seekToEnd();
                        header = new CeosRecordHeader(reader);
                    }
                    this.facilityRecord = new BinaryRecord(reader, -1L, facilityXML, "facility_record.xml");
                    header.seekToEnd();
                    continue;
                }
                this.facilityRecord = new BinaryRecord(reader, -1L, facility1_5XML, facility_record1_5DefinitionFile);
                header.seekToEnd();
                continue;
            }
            catch (Exception e) {
                System.out.println("Unable to read ALOS facility record: " + e.getMessage());
            }
        }
    }

    public final int getProductLevel() {
        if (this.productLevel < 0) {
            String level = null;
            if (this.sceneHeaderRecord != null) {
                level = this.sceneHeaderRecord.getAttributeString("Product level code");
            }
            if (level != null) {
                if (level.contains("1.5")) {
                    this.productLevel = 3;
                } else if (level.contains("1.1")) {
                    this.productLevel = 1;
                } else if (level.contains("1.0")) {
                    this.productLevel = 0;
                } else if (level.contains("4.1")) {
                    this.productLevel = 4;
                } else if (level.contains("4.2")) {
                    this.productLevel = 5;
                }
            }
        }
        return this.productLevel;
    }

    public String getProductType() {
        return this.sceneHeaderRecord.getAttributeString("Product type specifier");
    }
}

