/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos.alos;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.jdom2.Document;

public class AlosPalsarImageFile
extends CEOSImageFile {
    private static final String mission = "alos";
    private static final String image_DefinitionFile = "image_file.xml";
    private static final String image_recordDefinition = "image_record.xml";
    private static final String processedData_recordDefinition = "processed_data_record.xml";
    private final String imageFileName;
    private final int productLevel;
    private static final Document imgDefXML = BinaryDBReader.loadDefinitionFile("alos", "image_file.xml");
    private static final Document imgRecordXML = BinaryDBReader.loadDefinitionFile("alos", "image_record.xml");
    private static final Document procDataXML = BinaryDBReader.loadDefinitionFile("alos", "processed_data_record.xml");

    public AlosPalsarImageFile(ImageInputStream imageStream, int prodLevel, String fileName) throws IOException {
        this.productLevel = prodLevel;
        this.imageFileName = fileName.toUpperCase();
        this.binaryReader = new BinaryFileReader(imageStream);
        this.imageFDR = new BinaryRecord(this.binaryReader, -1L, imgDefXML, image_DefinitionFile);
        this.binaryReader.seek(this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()));
        this.imageRecords = new BinaryRecord[this.imageFDR.getAttributeInt("Number of lines per data set").intValue()];
        this.imageRecords[0] = this.createNewImageRecord(0);
        this._imageRecordLength = this.imageRecords[0].getRecordLength();
        this.startPosImageRecords = this.imageRecords[0].getStartPos();
        this.imageHeaderLength = this.imageFDR.getAttributeInt("Number of bytes of prefix data per record");
    }

    @Override
    protected BinaryRecord createNewImageRecord(int line) throws IOException {
        long pos = this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()) + (long)line * this._imageRecordLength;
        if (this.productLevel == 3) {
            return new BinaryRecord(this.binaryReader, pos, procDataXML, processedData_recordDefinition);
        }
        return new BinaryRecord(this.binaryReader, pos, imgRecordXML, image_recordDefinition);
    }

    public String getPolarization() {
        if (this.imageFileName.startsWith("IMG-") && this.imageFileName.length() > 6) {
            String pol = this.imageFileName.substring(4, 6);
            if (pol.equals("HH") || pol.equals("VV") || pol.equals("HV") || pol.equals("VH")) {
                return pol;
            }
            if (this.imageRecords[0] != null) {
                try {
                    int tx = this.imageRecords[0].getAttributeInt("Transmitted polarization");
                    int rx = this.imageRecords[0].getAttributeInt("Received polarization");
                    pol = tx == 1 ? "V" : "H";
                    pol = rx == 1 ? pol + "V" : pol + "H";
                    return pol;
                }
                catch (Exception e) {
                    return "";
                }
            }
        }
        return "";
    }
}

