/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos;

import java.io.IOException;
import org.esa.s1tbx.io.binary.BinaryFileReader;

public class CeosRecordHeader {
    private final BinaryFileReader reader;
    private final long startPos;
    private int recordNum;
    private int firstRecordSubtype;
    private int recordTypeCode;
    private int secondRecordSubtype;
    private int thirdRecordSubtype;
    private int recordLength;

    public CeosRecordHeader(BinaryFileReader reader) throws IOException {
        this.reader = reader;
        this.startPos = reader.getCurrentPos();
        try {
            this.recordNum = reader.readB4();
            this.firstRecordSubtype = reader.readB1();
            this.recordTypeCode = reader.readB1();
            this.secondRecordSubtype = reader.readB1();
            this.thirdRecordSubtype = reader.readB1();
            this.recordLength = reader.readB4();
        }
        catch (Exception exception) {
            // empty catch block
        }
        reader.seek(this.startPos);
    }

    public int getRecordNum() {
        return this.recordNum;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void seekToEnd() throws IOException {
        this.reader.seek(this.startPos + (long)this.recordLength);
    }
}

