/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos;

import java.io.File;
import java.util.Locale;
import org.esa.s1tbx.io.ceos.CEOSConstants;
import org.esa.s1tbx.io.ceos.ers.ERSProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class CEOSProductReaderPlugIn
implements ProductReaderPlugIn {
    protected CEOSConstants constants;

    public DecodeQualification getDecodeQualification(Object input) {
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file == null) {
            return DecodeQualification.UNABLE;
        }
        return this.checkProductQualification(file);
    }

    protected DecodeQualification checkProductQualification(File file) {
        String name = file.getName().toUpperCase();
        for (String prefix : this.constants.getVolumeFilePrefix()) {
            if (!name.startsWith(prefix)) continue;
            return DecodeQualification.SUITABLE;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return CEOSConstants.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new ERSProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter();
    }

    public String[] getFormatNames() {
        return this.constants.getFormatNames();
    }

    public String[] getDefaultFileExtensions() {
        return this.constants.getForamtFileExtensions();
    }

    public String getDescription(Locale locale) {
        return this.constants.getPluginDescription();
    }

    public class FileFilter
    extends SnapFileFilter {
        public FileFilter() {
            this.setFormatName(CEOSProductReaderPlugIn.this.constants.getFormatNames()[0]);
            this.setDescription(CEOSProductReaderPlugIn.this.constants.getPluginDescription());
        }

        public boolean accept(File file) {
            if (super.accept(file)) {
                if (file.isDirectory()) {
                    return true;
                }
                String name = file.getName().toUpperCase();
                for (String prefix : CEOSProductReaderPlugIn.this.constants.getVolumeFilePrefix()) {
                    if (!name.startsWith(prefix)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

