/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import java.io.File;
import java.io.IOException;
import org.esa.s1tbx.io.SARReader;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.esa.s1tbx.io.ceos.CEOSProductDirectory;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ZipUtils;

public abstract class CEOSProductReader
extends SARReader {
    private VirtualDir productDir = null;
    protected CEOSProductDirectory dataDir = null;

    protected CEOSProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected abstract CEOSProductDirectory createProductDirectory(VirtualDir var1);

    public void close() throws IOException {
        if (this.dataDir != null) {
            this.dataDir.close();
            this.dataDir = null;
        }
        super.close();
    }

    protected VirtualDir createProductDir(File inputFile) {
        if (ZipUtils.isZip((File)inputFile)) {
            return VirtualDir.create((File)inputFile);
        }
        return VirtualDir.create((File)inputFile.getParentFile());
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        File inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        this.productDir = this.createProductDir(inputFile);
        Product product = null;
        try {
            this.dataDir = this.createProductDirectory(this.productDir);
            this.dataDir.readProductDirectory();
            product = this.dataDir.createProduct();
            product.setFileLocation(inputFile);
            CEOSProductReader.setQuicklookBandName(product);
            this.addQuicklooks(product, this.productDir);
            product.getGcpGroup();
            product.setProductReader((ProductReader)this);
            product.setModified(false);
        }
        catch (Exception e) {
            this.handleReaderException(e);
        }
        return product;
    }

    protected void addQuicklooks(Product product, VirtualDir productDir) throws IOException {
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        try {
            CEOSImageFile imageFile = this.dataDir.getImageFile(destBand);
            int bitsPerSample = imageFile.getBitsPerSample();
            if (bitsPerSample == 8) {
                if (this.dataDir.isSLC()) {
                    boolean oneOf2 = destBand.getUnit().equals("real") || !destBand.getName().startsWith("q");
                    imageFile.readBandRasterDataSLCByte(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, oneOf2, pm);
                } else {
                    imageFile.readBandRasterDataByte(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, pm);
                }
            } else if (this.dataDir.isSLC()) {
                boolean oneOf2 = destBand.getUnit().equals("real") || !destBand.getName().startsWith("q");
                int samplesPerGroup = imageFile.getSamplesPerDataGroup();
                int elemSize = samplesPerGroup * ProductData.getElemSize((int)destBuffer.getType());
                imageFile.readBandRasterDataSLC(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, oneOf2, elemSize);
            } else {
                imageFile.readBandRasterDataShort(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destWidth, destBuffer, pm);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

