/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos;

import com.bc.ceres.core.VirtualDir;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.s1tbx.io.FileImageInputStreamExtImpl;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;
import org.esa.s1tbx.io.ceos.CEOSConstants;
import org.esa.s1tbx.io.ceos.CEOSImageFile;
import org.esa.s1tbx.io.ceos.CEOSVolumeDirectoryFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public abstract class CEOSProductDirectory {
    protected CEOSConstants constants = null;
    protected VirtualDir productDir;
    protected CEOSVolumeDirectoryFile volumeDirectoryFile = null;
    protected boolean isProductSLC = false;
    protected String productType = null;
    protected int sceneWidth = 0;
    protected int sceneHeight = 0;
    public static final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-DDD-HH:mm:ss");
    private static final DateFormat standardDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");

    protected abstract void readProductDirectory() throws IOException, IllegalBinaryFormatException;

    public abstract Product createProduct() throws IOException;

    public abstract CEOSImageFile getImageFile(Band var1);

    public abstract void close() throws IOException;

    protected final void readVolumeDirectoryFileStream() throws IOException {
        Guardian.assertNotNull((String)"productDir", (Object)this.productDir);
        Guardian.assertNotNull((String)"constants", (Object)this.constants);
        CeosFile[] volumeFile = this.getCEOSFile(this.constants.getVolumeFilePrefix());
        BinaryFileReader binaryReader = new BinaryFileReader(volumeFile[0].imgInputStream);
        String mission = this.constants.getMission();
        this.volumeDirectoryFile = new CEOSVolumeDirectoryFile(binaryReader, mission);
        this.volumeDirectoryFile.readFilePointersAndTextRecords(binaryReader, mission);
        binaryReader.close();
        this.productType = this.volumeDirectoryFile.getProductType();
        if (null == this.productType || this.productType.equals("unknown")) {
            throw new IOException("Unable to read level 0 product");
        }
        this.isProductSLC = this.productType.contains("SLC") || this.productType.contains("COMPLEX") || this.productType.contains("1.1");
    }

    private void readVolumeDiscriptor() throws IOException {
        CeosFile[] volumeFile = this.getCEOSFile(this.constants.getVolumeFilePrefix());
        BinaryFileReader binaryReader = new BinaryFileReader(volumeFile[0].imgInputStream);
        String mission = this.constants.getMission();
        if (this.volumeDirectoryFile == null) {
            this.volumeDirectoryFile = new CEOSVolumeDirectoryFile(binaryReader, mission);
        }
        binaryReader.close();
    }

    public boolean isSLC() {
        return this.isProductSLC;
    }

    protected String getSampleType() {
        if (this.isProductSLC) {
            return "COMPLEX";
        }
        return "DETECTED";
    }

    protected final String getVolumeId() throws IOException {
        if (this.volumeDirectoryFile == null) {
            this.readVolumeDiscriptor();
        }
        return this.volumeDirectoryFile.getVolumeDescriptorRecord().getAttributeString("Volume set ID");
    }

    protected final String getLogicalVolumeId() throws IOException {
        if (this.volumeDirectoryFile == null) {
            this.readVolumeDiscriptor();
        }
        return this.volumeDirectoryFile.getVolumeDescriptorRecord().getAttributeString("Logical volume ID");
    }

    protected String getProductType() {
        return this.productType;
    }

    protected static void addTiePointGrids(Product product, BinaryRecord facility, BinaryRecord scene) {
        try {
            int gridWidth = 11;
            int gridHeight = 11;
            float subSamplingX = (float)product.getSceneRasterWidth() / 10.0f;
            float subSamplingY = (float)product.getSceneRasterHeight() / 10.0f;
            if (facility != null) {
                double angle1 = facility.getAttributeDouble("Incidence angle at first range pixel");
                double angle2 = facility.getAttributeDouble("Incidence angle at centre range pixel");
                double angle3 = facility.getAttributeDouble("Incidence angle at last valid range pixel");
                float[] angles = new float[]{(float)angle1, (float)angle2, (float)angle3};
                float[] fineAngles = new float[121];
                ReaderUtils.createFineTiePointGrid((int)3, (int)1, (int)11, (int)11, (float[])angles, (float[])fineAngles);
                TiePointGrid incidentAngleGrid = new TiePointGrid("incident_angle", 11, 11, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, fineAngles);
                incidentAngleGrid.setUnit("deg");
                product.addTiePointGrid(incidentAngleGrid);
            }
            if (scene != null) {
                double time1 = scene.getAttributeDouble("Zero-doppler range time of first range pixel") * 1000000.0;
                double time2 = scene.getAttributeDouble("Zero-doppler range time of centre range pixel") * 1000000.0;
                double time3 = scene.getAttributeDouble("Zero-doppler range time of last range pixel") * 1000000.0;
                float[] times = new float[]{(float)time1, (float)time2, (float)time3};
                float[] fineTimes = new float[121];
                ReaderUtils.createFineTiePointGrid((int)3, (int)1, (int)11, (int)11, (float[])times, (float[])fineTimes);
                TiePointGrid slantRangeTimeGrid = new TiePointGrid("slant_range_time", 11, 11, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, fineTimes);
                slantRangeTimeGrid.setUnit("ns");
                product.addTiePointGrid(slantRangeTimeGrid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Band createBand(Product product, String name, String unit, int bitsPerSample) {
        int dataType = 21;
        if (bitsPerSample == 16) {
            dataType = this.isProductSLC ? 11 : 21;
        } else if (bitsPerSample == 32) {
            dataType = 30;
        } else if (bitsPerSample == 8) {
            dataType = this.isProductSLC ? 10 : 20;
        }
        Band band = new Band(name, dataType, this.sceneWidth, this.sceneHeight);
        band.setDescription(name);
        band.setUnit(unit);
        band.setNoDataValue(0.0);
        band.setNoDataValueUsed(true);
        product.addBand(band);
        return band;
    }

    protected static ProductData.UTC getProcTime(BinaryRecord volDescRec) {
        try {
            String procDate = volDescRec.getAttributeString("Logical volume preparation date").trim();
            String procTime = volDescRec.getAttributeString("Logical volume preparation time").trim();
            return ProductData.UTC.parse((String)(procDate + procTime), (String)"yyyyMMddHHmmss");
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            return AbstractMetadata.NO_METADATA_UTC;
        }
    }

    protected static String getPass(BinaryRecord mapProjRec, BinaryRecord sceneRec) {
        Double heading;
        if (mapProjRec != null && (heading = mapProjRec.getAttributeDouble("Platform heading at nadir corresponding to scene centre")) != null) {
            if (heading > 90.0 && heading < 270.0) {
                return "DESCENDING";
            }
            return "ASCENDING";
        }
        if (sceneRec != null) {
            String pass = sceneRec.getAttributeString("Ascending or Descending flag");
            if (pass == null) {
                pass = sceneRec.getAttributeString("Time direction indicator along line direction");
            }
            if (pass != null) {
                if (pass.toUpperCase().trim().startsWith("DESC")) {
                    return "DESCENDING";
                }
                return "ASCENDING";
            }
        }
        return " ";
    }

    protected static ProductData.UTC getUTCScanStartTime(BinaryRecord sceneRec, BinaryRecord detailProcRec) {
        String startTime;
        if (sceneRec != null && (startTime = sceneRec.getAttributeString("Zero-doppler azimuth time of first azimuth pixel")) != null) {
            return AbstractMetadata.parseUTC((String)startTime);
        }
        if (detailProcRec != null && (startTime = detailProcRec.getAttributeString("Processing start time")) != null) {
            return AbstractMetadata.parseUTC((String)startTime, (DateFormat)dateFormat);
        }
        return AbstractMetadata.NO_METADATA_UTC;
    }

    protected static ProductData.UTC getUTCScanStopTime(BinaryRecord sceneRec, BinaryRecord detailProcRec) {
        String endTime;
        if (sceneRec != null && (endTime = sceneRec.getAttributeString("Zero-doppler azimuth time of last azimuth pixel")) != null) {
            return AbstractMetadata.parseUTC((String)endTime);
        }
        if (detailProcRec != null && (endTime = detailProcRec.getAttributeString("Processing stop time")) != null) {
            return AbstractMetadata.parseUTC((String)endTime, (DateFormat)dateFormat);
        }
        return AbstractMetadata.NO_METADATA_UTC;
    }

    protected static void addSummaryMetadata(InputStream summaryStream, String name, MetadataElement parent) throws IOException {
        if (summaryStream == null) {
            return;
        }
        MetadataElement summaryMetadata = new MetadataElement(name);
        Properties properties = new Properties();
        properties.load(summaryStream);
        Set<Map.Entry<Object, Object>> unsortedEntries = properties.entrySet();
        TreeSet<Map.Entry<Object, Object>> sortedEntries = new TreeSet<Map.Entry<Object, Object>>(new Comparator(){

            public int compare(Object a, Object b) {
                Map.Entry entryA = (Map.Entry)a;
                Map.Entry entryB = (Map.Entry)b;
                return ((String)entryA.getKey()).compareTo((String)entryB.getKey());
            }
        });
        sortedEntries.addAll(unsortedEntries);
        for (Object e : sortedEntries) {
            Map.Entry entry = (Map.Entry)e;
            String data = ((String)entry.getValue()).trim();
            String strippedData = "";
            if (data.length() > 2) {
                strippedData = data.substring(1, data.length() - 1);
            }
            MetadataAttribute attribute = new MetadataAttribute((String)entry.getKey(), (ProductData)new ProductData.ASCII(strippedData), true);
            summaryMetadata.addAttribute(attribute);
        }
        parent.addElement(summaryMetadata);
    }

    protected static void assertSameWidthAndHeightForAllImages(CEOSImageFile[] imageFiles, int width, int height) {
        for (int i = 0; i < imageFiles.length; ++i) {
            CEOSImageFile imageFile = imageFiles[i];
            Guardian.assertTrue((String)("_sceneWidth == imageFile[" + i + "].getRasterWidth()"), (width == imageFile.getRasterWidth() ? 1 : 0) != 0);
            Guardian.assertTrue((String)("_sceneHeight == imageFile[" + i + "].getRasterHeight()"), (height == imageFile.getRasterHeight() ? 1 : 0) != 0);
        }
    }

    protected static double getRadarFrequency(BinaryRecord sceneRec) {
        double wavelength = sceneRec.getAttributeDouble("Radar wavelength");
        return 2.99792458E8 / wavelength / 1000000.0;
    }

    protected static int isGroundRange(BinaryRecord mapProjRec) {
        String projDesc = mapProjRec.getAttributeString("Map projection descriptor").toLowerCase();
        if (projDesc.contains("slant")) {
            return 0;
        }
        return 1;
    }

    protected static void addOrbitStateVectors(MetadataElement absRoot, BinaryRecord platformPosRec) {
        if (platformPosRec == null) {
            return;
        }
        MetadataElement orbitVectorListElem = absRoot.getElement("Orbit_State_Vectors");
        int numPoints = platformPosRec.getAttributeInt("Number of data points");
        for (int i = 1; i <= numPoints; ++i) {
            CEOSProductDirectory.addVector("orbit_vector", orbitVectorListElem, platformPosRec, i);
        }
        if (absRoot.getAttributeUTC("STATE_VECTOR_TIME", AbstractMetadata.NO_METADATA_UTC).equalElems((ProductData)AbstractMetadata.NO_METADATA_UTC)) {
            AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"STATE_VECTOR_TIME", (ProductData.UTC)CEOSProductDirectory.getOrbitTime(platformPosRec, 1));
        }
    }

    private static void addVector(String name, MetadataElement orbitVectorListElem, BinaryRecord platformPosRec, int num) {
        MetadataElement orbitVectorElem = new MetadataElement(name + num);
        orbitVectorElem.setAttributeUTC("time", CEOSProductDirectory.getOrbitTime(platformPosRec, num));
        orbitVectorElem.setAttributeDouble("x_pos", platformPosRec.getAttributeDouble("Position vector X " + num).doubleValue());
        orbitVectorElem.setAttributeDouble("y_pos", platformPosRec.getAttributeDouble("Position vector Y " + num).doubleValue());
        orbitVectorElem.setAttributeDouble("z_pos", platformPosRec.getAttributeDouble("Position vector Z " + num).doubleValue());
        orbitVectorElem.setAttributeDouble("x_vel", platformPosRec.getAttributeDouble("Velocity vector X' " + num).doubleValue());
        orbitVectorElem.setAttributeDouble("y_vel", platformPosRec.getAttributeDouble("Velocity vector Y' " + num).doubleValue());
        orbitVectorElem.setAttributeDouble("z_vel", platformPosRec.getAttributeDouble("Velocity vector Z' " + num).doubleValue());
        orbitVectorListElem.addElement(orbitVectorElem);
    }

    protected static ProductData.UTC getOrbitTime(BinaryRecord platformPosRec, int num) {
        int year = platformPosRec.getAttributeInt("Year of data point");
        int month = platformPosRec.getAttributeInt("Month of data point");
        int day = platformPosRec.getAttributeInt("Day of data point");
        Double secondsOfDay = platformPosRec.getAttributeDouble("Seconds of day");
        if (secondsOfDay == null) {
            secondsOfDay = 0.0;
        }
        double hoursf = secondsOfDay / 3600.0;
        int hour = (int)hoursf;
        double minutesf = (hoursf - (double)hour) * 60.0;
        int minute = (int)minutesf;
        float second = ((float)minutesf - (float)minute) * 60.0f;
        Double interval = platformPosRec.getAttributeDouble("Time interval between DATA points");
        if (interval == null || interval <= 0.0) {
            SystemUtils.LOG.info("CEOSProductDirectory: Time interval between DATA points in Platform Position Data is " + interval);
            interval = 0.0;
        }
        second = (float)((double)second + interval * (double)(num - 1));
        return AbstractMetadata.parseUTC((String)(String.valueOf(year) + '-' + month + '-' + day + ' ' + hour + ':' + minute + ':' + second), (DateFormat)standardDateFormat);
    }

    protected static void addSRGRCoefficients(MetadataElement absRoot, BinaryRecord facilityRec) {
        if (facilityRec == null) {
            return;
        }
        MetadataElement srgrCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
        MetadataElement srgrListElem = new MetadataElement("srgr_coef_list");
        srgrCoefficientsElem.addElement(srgrListElem);
        ProductData.UTC utcTime = absRoot.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
        srgrListElem.setAttributeUTC("zero_doppler_time", utcTime);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (int)31, (String)"m", (String)"Ground Range Origin");
        AbstractMetadata.setAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (double)0.0);
        CEOSProductDirectory.addSRGRCoef(srgrListElem, facilityRec, "coefficients of the ground range to slant range conversion polynomial 1", 1);
        CEOSProductDirectory.addSRGRCoef(srgrListElem, facilityRec, "coefficients of the ground range to slant range conversion polynomial 2", 2);
        CEOSProductDirectory.addSRGRCoef(srgrListElem, facilityRec, "coefficients of the ground range to slant range conversion polynomial 3", 3);
        CEOSProductDirectory.addSRGRCoef(srgrListElem, facilityRec, "coefficients of the ground range to slant range conversion polynomial 4", 4);
    }

    protected static void addSRGRCoef(MetadataElement srgrListElem, BinaryRecord rec, String tag, int cnt) {
        MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
        srgrListElem.addElement(coefElem);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"srgr_coef", (int)31, (String)"", (String)"SRGR Coefficient");
        AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (Double)rec.getAttributeDouble(tag));
    }

    protected static void addDopplerCentroidCoefficients(MetadataElement absRoot, BinaryRecord sceneRec) {
        if (sceneRec == null) {
            return;
        }
        MetadataElement dopCoefficientsElem = absRoot.getElement("Doppler_Centroid_Coefficients");
        MetadataElement dopListElem = new MetadataElement("dop_coef_list");
        dopCoefficientsElem.addElement(dopListElem);
        ProductData.UTC utcTime = absRoot.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
        dopListElem.setAttributeUTC("zero_doppler_time", utcTime);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)dopListElem, (String)"slant_range_time", (int)31, (String)"ns", (String)"Slant Range Time");
        AbstractMetadata.setAttribute((MetadataElement)dopListElem, (String)"slant_range_time", (double)0.0);
        CEOSProductDirectory.addDopCoef(dopListElem, sceneRec, "Cross track Doppler frequency centroid constant term", 1);
        CEOSProductDirectory.addDopCoef(dopListElem, sceneRec, "Cross track Doppler frequency centroid linear term", 2);
        CEOSProductDirectory.addDopCoef(dopListElem, sceneRec, "Cross track Doppler frequency centroid quadratic term", 3);
    }

    protected static void addDopCoef(MetadataElement dopListElem, BinaryRecord rec, String tag, int cnt) {
        MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
        dopListElem.addElement(coefElem);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"dop_coef", (int)31, (String)"", (String)tag);
        AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"dop_coef", (Double)rec.getAttributeDouble(tag));
    }

    protected InputStream findFile(String fileName) throws IOException {
        try {
            if (this.productDir.isCompressed()) {
                String folder = "";
                String[] fileList = this.productDir.list("");
                while (fileList.length > 0 && fileList.length <= 3) {
                    folder = folder + fileList[0] + '/';
                    fileList = this.productDir.list(folder);
                }
                if (!folder.isEmpty() && !folder.endsWith("/")) {
                    folder = folder + "/";
                }
                return this.productDir.getInputStream(folder + fileName);
            }
            return new FileInputStream(new File(this.productDir.getBasePath(), fileName));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected CeosFile[] getCEOSFile(String[] prefixList) throws IOException {
        ArrayList<CeosFile> list = new ArrayList<CeosFile>(4);
        String folder = "";
        String[] fileList = this.productDir.list("");
        while (fileList.length > 0 && fileList.length <= 3) {
            folder = folder + fileList[0] + '/';
            fileList = this.productDir.list(folder);
        }
        if (!folder.isEmpty() && !folder.endsWith("/")) {
            folder = folder + "/";
        }
        for (String name : fileList) {
            name = name.toUpperCase();
            for (String prefix : prefixList) {
                if (!name.startsWith(prefix) && !name.endsWith('.' + prefix)) continue;
                ImageInputStreamImpl stream = this.productDir.isCompressed() ? new MemoryCacheImageInputStream(this.productDir.getInputStream(folder + name)) : new FileImageInputStreamExtImpl(this.productDir.getFile(folder + name));
                list.add(new CeosFile(stream, name));
            }
        }
        return list.toArray(new CeosFile[list.size()]);
    }

    public static class CeosFile {
        public ImageInputStream imgInputStream;
        public String fileName;

        public CeosFile(ImageInputStream imgInputStream, String fileName) {
            this.imgInputStream = imgInputStream;
            this.fileName = fileName;
        }
    }
}

