/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.BinaryDBReader;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.s1tbx.io.ceos.CeosHelper;
import org.esa.snap.core.datamodel.MetadataElement;
import org.jdom2.Document;

public class CEOSLeaderFile {
    protected BinaryRecord leaderFDR = null;
    protected BinaryRecord sceneHeaderRecord = null;
    protected BinaryRecord platformPositionRecord = null;
    protected BinaryRecord mapProjRecord = null;
    protected BinaryRecord dataQualityRecord = null;
    protected BinaryRecord histogramRecord = null;
    protected BinaryRecord attitudeRecord = null;
    protected BinaryRecord radiometricRecord = null;
    protected BinaryRecord radiometricCompRecord = null;
    protected BinaryRecord detailedProcessingRecord = null;
    protected BinaryRecord facilityRecord = null;
    protected static final String scene_recordDefinitionFile = "scene_record.xml";
    protected static final String platformPosition_recordDefinitionFile = "platform_position_record.xml";
    protected static final String mapproj_recordDefinitionFile = "map_proj_record.xml";
    protected static final String dataQuality_recordDefinitionFile = "data_quality_summary_record.xml";
    protected static final String histogram_recordDefinitionFile = "data_histogram_record.xml";
    protected static final String attitude_recordDefinitionFile = "attitude_record.xml";
    protected static final String radiometric_recordDefinitionFile = "radiometric_record.xml";
    protected static final String radiometric_comp_recordDefinitionFile = "radiometric_compensation_record.xml";
    protected static final String detailedProcessing_recordDefinitionFile = "detailed_processing_record.xml";
    protected static final String facility_recordDefinitionFile = "facility_record.xml";
    private static Document sceneXML;
    private static Document mapProjXML;
    private static Document platformXML;
    private static Document attitudeXML;
    private static Document radiometricXML;
    private static Document radiometricCompXML;
    private static Document dataQualityXML;
    private static Document histogramXML;
    private static Document detailProcXML;
    private static Document facilityXML;

    protected CEOSLeaderFile() {
    }

    protected CEOSLeaderFile(ImageInputStream stream, String mission, String defnFile) throws IOException {
        int i;
        BinaryFileReader reader = new BinaryFileReader(stream);
        Document leaderXML = BinaryDBReader.loadDefinitionFile(mission, defnFile);
        this.leaderFDR = new BinaryRecord(reader, -1L, leaderXML, defnFile);
        reader.seek(this.leaderFDR.getRecordEndPosition());
        int num = this.leaderFDR.getAttributeInt("Number of data set summary records");
        if (sceneXML == null && num > 0) {
            sceneXML = BinaryDBReader.loadDefinitionFile(mission, scene_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.sceneHeaderRecord = new BinaryRecord(reader, -1L, sceneXML, scene_recordDefinitionFile);
                reader.seek(this.sceneHeaderRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of map projection data records");
        if (mapProjXML == null && num > 0) {
            mapProjXML = BinaryDBReader.loadDefinitionFile(mission, mapproj_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.mapProjRecord = new BinaryRecord(reader, -1L, mapProjXML, mapproj_recordDefinitionFile);
                reader.seek(this.mapProjRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of platform pos. data records");
        if (platformXML == null && num > 0) {
            platformXML = BinaryDBReader.loadDefinitionFile(mission, platformPosition_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.platformPositionRecord = new BinaryRecord(reader, -1L, platformXML, platformPosition_recordDefinitionFile);
                reader.seek(this.platformPositionRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of attitude data records");
        if (attitudeXML == null && num > 0) {
            attitudeXML = BinaryDBReader.loadDefinitionFile(mission, attitude_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.attitudeRecord = new BinaryRecord(reader, -1L, attitudeXML, attitude_recordDefinitionFile);
                reader.seek(this.attitudeRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of radiometric data records");
        if (radiometricXML == null && num > 0) {
            radiometricXML = BinaryDBReader.loadDefinitionFile(mission, radiometric_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.radiometricRecord = new BinaryRecord(reader, -1L, radiometricXML, radiometric_recordDefinitionFile);
                reader.seek(this.radiometricRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of rad. compensation records");
        if (radiometricCompXML == null && num > 0) {
            radiometricCompXML = BinaryDBReader.loadDefinitionFile(mission, radiometric_comp_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.radiometricCompRecord = new BinaryRecord(reader, -1L, radiometricCompXML, radiometric_comp_recordDefinitionFile);
                reader.seek(this.radiometricCompRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of data quality summary records");
        if (dataQualityXML == null && num > 0) {
            dataQualityXML = BinaryDBReader.loadDefinitionFile(mission, dataQuality_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.dataQualityRecord = new BinaryRecord(reader, -1L, dataQualityXML, dataQuality_recordDefinitionFile);
                reader.seek(this.dataQualityRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of data histograms records");
        if (histogramXML == null && num > 0) {
            histogramXML = BinaryDBReader.loadDefinitionFile(mission, histogram_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.histogramRecord = new BinaryRecord(reader, -1L, histogramXML, histogram_recordDefinitionFile);
                reader.seek(this.histogramRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of det. processing records");
        if (detailProcXML == null && num > 0) {
            detailProcXML = BinaryDBReader.loadDefinitionFile(mission, detailedProcessing_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.detailedProcessingRecord = new BinaryRecord(reader, -1L, detailProcXML, detailedProcessing_recordDefinitionFile);
                reader.seek(this.detailedProcessingRecord.getRecordEndPosition());
            }
        }
        num = this.leaderFDR.getAttributeInt("Number of facility data records");
        if (facilityXML == null && num > 0) {
            facilityXML = BinaryDBReader.loadDefinitionFile(mission, facility_recordDefinitionFile);
            for (i = 0; i < num; ++i) {
                this.facilityRecord = new BinaryRecord(reader, -1L, facilityXML, facility_recordDefinitionFile);
                reader.seek(this.facilityRecord.getRecordEndPosition());
            }
        }
        reader.close();
    }

    public final BinaryRecord getSceneRecord() {
        return this.sceneHeaderRecord;
    }

    public BinaryRecord getMapProjRecord() {
        return this.mapProjRecord;
    }

    public BinaryRecord getPlatformPositionRecord() {
        return this.platformPositionRecord;
    }

    public BinaryRecord getHistogramRecord() {
        return this.histogramRecord;
    }

    public BinaryRecord getRadiometricRecord() {
        return this.radiometricRecord;
    }

    public BinaryRecord getFacilityRecord() {
        return this.facilityRecord;
    }

    public BinaryRecord getDetailedProcessingRecord() {
        return this.detailedProcessingRecord;
    }

    public static float[] getLatCorners(BinaryRecord mapProjRec) {
        if (mapProjRec == null) {
            return null;
        }
        Double latUL = mapProjRec.getAttributeDouble("1st line 1st pixel geodetic latitude");
        Double latUR = mapProjRec.getAttributeDouble("1st line last valid pixel geodetic latitude");
        Double latLL = mapProjRec.getAttributeDouble("Last line 1st pixel geodetic latitude");
        Double latLR = mapProjRec.getAttributeDouble("Last line last valid pixel geodetic latitude");
        if (latUL == null || latUR == null || latLL == null || latLR == null) {
            return null;
        }
        return new float[]{latUL.floatValue(), latUR.floatValue(), latLL.floatValue(), latLR.floatValue()};
    }

    public static float[] getLonCorners(BinaryRecord mapProjRec) {
        if (mapProjRec == null) {
            return null;
        }
        Double lonUL = mapProjRec.getAttributeDouble("1st line 1st pixel geodetic longitude");
        Double lonUR = mapProjRec.getAttributeDouble("1st line last valid pixel geodetic longitude");
        Double lonLL = mapProjRec.getAttributeDouble("Last line 1st pixel geodetic longitude");
        Double lonLR = mapProjRec.getAttributeDouble("Last line last valid pixel geodetic longitude");
        if (lonUL == null || lonUR == null || lonLL == null || lonLR == null) {
            return null;
        }
        return new float[]{lonUL.floatValue(), lonUR.floatValue(), lonLL.floatValue(), lonLR.floatValue()};
    }

    public void addMetadata(MetadataElement sphElem) {
        CeosHelper.addMetadata(sphElem, this.leaderFDR, "File Descriptor");
        CeosHelper.addMetadata(sphElem, this.sceneHeaderRecord, "Scene Parameters");
        CeosHelper.addMetadata(sphElem, this.mapProjRecord, "Map Projection");
        CeosHelper.addMetadata(sphElem, this.platformPositionRecord, "Platform Position");
        CeosHelper.addMetadata(sphElem, this.dataQualityRecord, "Data Quality");
        CeosHelper.addMetadata(sphElem, this.histogramRecord, "Histogram");
        CeosHelper.addMetadata(sphElem, this.attitudeRecord, "Attitude");
        CeosHelper.addMetadata(sphElem, this.radiometricRecord, "Radiometric");
        CeosHelper.addMetadata(sphElem, this.radiometricCompRecord, "Radiometric Compensation");
        CeosHelper.addMetadata(sphElem, this.detailedProcessingRecord, "Detailed Processing");
        CeosHelper.addMetadata(sphElem, this.facilityRecord, "Facility Related");
    }
}

