/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.ceos;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.s1tbx.io.binary.BinaryFileReader;
import org.esa.s1tbx.io.binary.BinaryRecord;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;

public abstract class CEOSImageFile {
    protected BinaryRecord imageFDR = null;
    protected BinaryFileReader binaryReader = null;
    protected BinaryRecord[] imageRecords = null;
    protected long _imageRecordLength = 0L;
    protected long startPosImageRecords = 0L;
    protected int imageHeaderLength = 0;

    public BinaryRecord getImageFileDescriptor() {
        return this.imageFDR;
    }

    public int getRasterWidth() {
        int width = this.imageFDR.getAttributeInt("Number of pixels per line per SAR channel");
        if (width == 0) {
            width = this.imageFDR.getAttributeInt("SAR DATA record length");
        }
        return width;
    }

    public int getRasterHeight() {
        return this.imageFDR.getAttributeInt("Number of lines per data set");
    }

    public int getBitsPerSample() {
        return this.imageFDR.getAttributeInt("Number of bits per sample");
    }

    public int getSamplesPerDataGroup() {
        return this.imageFDR.getAttributeInt("Number of samples per data group");
    }

    protected abstract BinaryRecord createNewImageRecord(int var1) throws IOException;

    BinaryRecord getImageRecord(int line) throws IOException {
        if (this.imageRecords[line] == null) {
            this.binaryReader.seek(this.imageFDR.getAbsolutPosition(this.imageFDR.getRecordLength()));
            this.imageRecords[line] = this.createNewImageRecord(line);
        }
        return this.imageRecords[line];
    }

    public double getSlantRangeToFirstPixel(int line) {
        try {
            BinaryRecord imgRec = this.getImageRecord(line);
            return imgRec.getAttributeInt("Slant range to 1st pixel").intValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getSlantRangeToMidPixel(int line) {
        try {
            BinaryRecord imgRec = this.getImageRecord(line);
            return imgRec.getAttributeInt("Slant range to mid-pixel").intValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getSlantRangeToLastPixel(int line) {
        try {
            BinaryRecord imgRec = this.getImageRecord(line);
            return imgRec.getAttributeInt("Slant range to last pixel").intValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public float[] getLatCorners() {
        try {
            BinaryRecord imgRec0 = this.getImageRecord(0);
            BinaryRecord imgRecN = this.getImageRecord(this.imageRecords.length - 1);
            float latUL = (float)imgRec0.getAttributeInt("First pixel latitude").intValue() / 1000000.0f;
            float latUR = (float)imgRec0.getAttributeInt("Last pixel latitude").intValue() / 1000000.0f;
            float latLL = (float)imgRecN.getAttributeInt("First pixel latitude").intValue() / 1000000.0f;
            float latLR = (float)imgRecN.getAttributeInt("Last pixel latitude").intValue() / 1000000.0f;
            return new float[]{latUL, latUR, latLL, latLR};
        }
        catch (Throwable e) {
            return null;
        }
    }

    public float[] getLonCorners() {
        try {
            BinaryRecord imgRec0 = this.getImageRecord(0);
            BinaryRecord imgRecN = this.getImageRecord(this.imageRecords.length - 1);
            float lonUL = (float)imgRec0.getAttributeInt("First pixel longitude").intValue() / 1000000.0f;
            float lonUR = (float)imgRec0.getAttributeInt("Last pixel longitude").intValue() / 1000000.0f;
            float lonLL = (float)imgRecN.getAttributeInt("First pixel longitude").intValue() / 1000000.0f;
            float lonLR = (float)imgRecN.getAttributeInt("Last pixel longitude").intValue() / 1000000.0f;
            return new float[]{lonUL, lonUR, lonLL, lonLR};
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void assignMetadataTo(MetadataElement rootElem, int count) {
        MetadataElement imgDescElem = new MetadataElement("Image Descriptor " + count);
        this.imageFDR.assignMetadataTo(imgDescElem);
        rootElem.addElement(imgDescElem);
        if (this.imageRecords[0] != null) {
            MetadataElement imgRecElem = new MetadataElement("Image Record ");
            this.imageRecords[0].assignMetadataTo(imgRecElem);
            imgDescElem.addElement(imgRecElem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandRasterDataShort(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destWidth, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int x = sourceOffsetX * ProductData.getElemSize((int)destBuffer.getType());
        long xpos = this.startPosImageRecords + (long)this.imageHeaderLength + (long)x;
        pm.beginTask("Reading band...", sourceMaxY - sourceOffsetY);
        try {
            short[] srcLine = new short[sourceWidth];
            short[] destLine = null;
            if (sourceStepX != 1) {
                destLine = new short[destWidth];
            }
            for (int y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                BinaryFileReader binaryFileReader = this.binaryReader;
                synchronized (binaryFileReader) {
                    this.binaryReader.seek(this._imageRecordLength * (long)y + xpos);
                    this.binaryReader.read(srcLine);
                }
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                if (sourceStepX == 1) {
                    System.arraycopy(srcLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                } else {
                    CEOSImageFile.copyLine(srcLine, destLine, sourceStepX);
                    System.arraycopy(destLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                }
                pm.worked(1);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandRasterDataInt(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destWidth, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int x = sourceOffsetX * ProductData.getElemSize((int)destBuffer.getType());
        long xpos = this.startPosImageRecords + (long)this.imageHeaderLength + (long)x;
        pm.beginTask("Reading band...", sourceMaxY - sourceOffsetY);
        try {
            int[] srcLine = new int[sourceWidth];
            int[] destLine = null;
            if (sourceStepX != 1) {
                destLine = new int[destWidth];
            }
            for (int y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                BinaryFileReader binaryFileReader = this.binaryReader;
                synchronized (binaryFileReader) {
                    this.binaryReader.seek(this._imageRecordLength * (long)y + xpos);
                    this.binaryReader.read(srcLine);
                }
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                if (sourceStepX == 1) {
                    System.arraycopy(srcLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                } else {
                    CEOSImageFile.copyLine(srcLine, destLine, sourceStepX);
                    System.arraycopy(destLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandRasterDataFloat(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destWidth, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int x = sourceOffsetX * ProductData.getElemSize((int)destBuffer.getType());
        long xpos = this.startPosImageRecords + (long)this.imageHeaderLength + (long)x;
        pm.beginTask("Reading band...", sourceMaxY - sourceOffsetY);
        try {
            float[] srcLine = new float[sourceWidth];
            float[] destLine = null;
            if (sourceStepX != 1) {
                destLine = new float[destWidth];
            }
            for (int y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                BinaryFileReader binaryFileReader = this.binaryReader;
                synchronized (binaryFileReader) {
                    this.binaryReader.seek(this._imageRecordLength * (long)y + xpos);
                    this.binaryReader.read(srcLine);
                }
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                if (sourceStepX == 1) {
                    System.arraycopy(srcLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                } else {
                    CEOSImageFile.copyLine(srcLine, destLine, sourceStepX);
                    System.arraycopy(destLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandRasterDataByte(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destWidth, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int x = sourceOffsetX * ProductData.getElemSize((int)destBuffer.getType());
        long xpos = this.startPosImageRecords + (long)this.imageHeaderLength + (long)x;
        pm.beginTask("Reading band...", sourceMaxY - sourceOffsetY);
        try {
            byte[] srcLine = new byte[sourceWidth];
            byte[] destLine = null;
            if (sourceStepX != 1) {
                destLine = new byte[destWidth];
            }
            for (int y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                BinaryFileReader binaryFileReader = this.binaryReader;
                synchronized (binaryFileReader) {
                    this.binaryReader.seek(this._imageRecordLength * (long)y + xpos);
                    this.binaryReader.read(srcLine);
                }
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                if (sourceStepX == 1) {
                    System.arraycopy(srcLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                } else {
                    CEOSImageFile.copyLine(srcLine, destLine, sourceStepX);
                    System.arraycopy(destLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandRasterDataSLC(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destWidth, ProductData destBuffer, boolean oneOf2, int elemSize) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int x = sourceOffsetX * elemSize;
        long xpos = this.startPosImageRecords + (long)this.imageHeaderLength + (long)x;
        try {
            short[] srcLine = new short[sourceWidth * 2];
            for (int y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                BinaryFileReader binaryFileReader = this.binaryReader;
                synchronized (binaryFileReader) {
                    this.binaryReader.seek(this._imageRecordLength * (long)y + xpos);
                    this.binaryReader.read(srcLine);
                }
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                if (oneOf2) {
                    CEOSImageFile.copyLine1Of2(srcLine, destBuffer, currentLineIndex, sourceStepX);
                    continue;
                }
                CEOSImageFile.copyLine2Of2(srcLine, destBuffer, currentLineIndex, sourceStepX);
            }
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandRasterDataSLCFloat(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destWidth, ProductData destBuffer, boolean oneOf2, ProgressMonitor pm) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int x = sourceOffsetX * 8;
        long xpos = this.startPosImageRecords + (long)this.imageHeaderLength + (long)x;
        pm.beginTask("Reading band...", sourceMaxY - sourceOffsetY);
        try {
            float[] srcLine = new float[sourceWidth * 2];
            for (int y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                BinaryFileReader binaryFileReader = this.binaryReader;
                synchronized (binaryFileReader) {
                    this.binaryReader.seek(this._imageRecordLength * (long)y + xpos);
                    this.binaryReader.read(srcLine);
                }
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                if (oneOf2) {
                    CEOSImageFile.copyLine1Of2(srcLine, destBuffer, currentLineIndex, sourceStepX);
                } else {
                    CEOSImageFile.copyLine2Of2(srcLine, destBuffer, currentLineIndex, sourceStepX);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandRasterDataSLCByte(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destWidth, ProductData destBuffer, boolean oneOf2, ProgressMonitor pm) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int x = sourceOffsetX * 2;
        long xpos = this.startPosImageRecords + (long)this.imageHeaderLength + (long)x;
        pm.beginTask("Reading band...", sourceMaxY - sourceOffsetY);
        try {
            byte[] srcLine = new byte[sourceWidth * 2];
            byte[] destLine = new byte[destWidth];
            for (int y = sourceOffsetY; y <= sourceMaxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                BinaryFileReader binaryFileReader = this.binaryReader;
                synchronized (binaryFileReader) {
                    this.binaryReader.seek(this._imageRecordLength * (long)y + xpos);
                    this.binaryReader.read(srcLine);
                }
                int currentLineIndex = (y - sourceOffsetY) * destWidth;
                if (oneOf2) {
                    CEOSImageFile.copyLine1Of2(srcLine, destLine, sourceStepX);
                } else {
                    CEOSImageFile.copyLine2Of2(srcLine, destLine, sourceStepX);
                }
                System.arraycopy(destLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private static void copyLine(short[] srcLine, short[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine(byte[] srcLine, byte[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine(int[] srcLine, int[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine(float[] srcLine, float[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine1Of2(short[] srcLine, ProductData destBuffer, int currentLineIndex, int sourceStepX) {
        int destLength = destBuffer.getNumElems();
        int srcLength = srcLine.length / 2;
        int x = currentLineIndex;
        for (int i = 0; x < destLength && i < srcLength; ++x, i += sourceStepX) {
            destBuffer.setElemDoubleAt(x, (double)srcLine[i << 1]);
        }
    }

    private static void copyLine1Of2(short[] srcLine, short[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i << 1];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine1Of2(byte[] srcLine, byte[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = srcLine[i << 1];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine1Of2(float[] srcLine, ProductData destBuffer, int currentLineIndex, int sourceStepX) {
        int destLength = destBuffer.getNumElems();
        int srcLength = srcLine.length / 2;
        int x = currentLineIndex;
        for (int i = 0; x < destLength && i < srcLength; ++x, i += sourceStepX) {
            destBuffer.setElemDoubleAt(x, (double)srcLine[i << 1]);
        }
    }

    private static void copyLine1Of2(float[] srcLine, float[] destLine, int sourceStepX) {
        int x = 0;
        int i = 0;
        while (x < destLine.length) {
            destLine[x] = (int)srcLine[i << 1];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine2Of2(short[] srcLine, ProductData destBuffer, int currentLineIndex, int sourceStepX) {
        int destLength = destBuffer.getNumElems();
        int srcLength = srcLine.length / 2;
        int x = currentLineIndex;
        for (int i = 0; x < destLength && i < srcLength; ++x, i += sourceStepX) {
            destBuffer.setElemDoubleAt(x, (double)srcLine[(i << 1) + 1]);
        }
    }

    private static void copyLine2Of2(short[] srcLine, short[] destLine, int sourceStepX) {
        int length = destLine.length;
        int x = 0;
        int i = 0;
        while (x < length) {
            destLine[x] = srcLine[(i << 1) + 1];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine2Of2(byte[] srcLine, byte[] destLine, int sourceStepX) {
        int length = destLine.length;
        int x = 0;
        int i = 0;
        while (x < length) {
            destLine[x] = srcLine[(i << 1) + 1];
            ++x;
            i += sourceStepX;
        }
    }

    private static void copyLine2Of2(float[] srcLine, ProductData destBuffer, int currentLineIndex, int sourceStepX) {
        int destLength = destBuffer.getNumElems();
        int srcLength = srcLine.length / 2;
        int x = currentLineIndex;
        for (int i = 0; x < destLength && i < srcLength; ++x, i += sourceStepX) {
            destBuffer.setElemDoubleAt(x, (double)srcLine[(i << 1) + 1]);
        }
    }

    private static void copyLine2Of2(float[] srcLine, float[] destLine, int sourceStepX) {
        int length = destLine.length;
        int x = 0;
        int i = 0;
        while (x < length) {
            destLine[x] = (int)srcLine[(i << 1) + 1];
            ++x;
            i += sourceStepX;
        }
    }

    public void close() throws IOException {
        this.binaryReader.close();
        this.binaryReader = null;
    }
}

